/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.ErrorPaneConfigurable;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.roots.ui.configuration.SidePanelSeparator;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidePanel
extends JPanel {
    private final JList myList;
    private final DefaultListModel myModel;
    private final Place.Navigator myNavigator;
    private final ArrayList<Place> myPlaces = new ArrayList();
    private final Map<Integer, String> myIndex2Separator = new HashMap<Integer, String>();
    private final Map<Place, Presentation> myPlace2Presentation = new HashMap<Place, Presentation>();
    private final History myHistory;

    public SidePanel(Place.Navigator navigator, History history) {
        this.myHistory = history;
        this.myNavigator = navigator;
        this.setLayout(new BorderLayout());
        this.myModel = new DefaultListModel();
        this.myList = new JBList((ListModel)this.myModel);
        if (Registry.is((String)"ide.new.project.settings")) {
            this.myList.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
            this.myList.setBorder(new EmptyBorder(5, 0, 0, 0));
        }
        final ListItemDescriptor descriptor = new ListItemDescriptor(){

            public String getTextFor(Object value) {
                return ((Presentation)SidePanel.this.myPlace2Presentation.get(value)).getText();
            }

            public String getTooltipFor(Object value) {
                return this.getTextFor(value);
            }

            public Icon getIconFor(Object value) {
                return Registry.is((String)"ide.new.project.settings") ? EmptyIcon.create((int)16, (int)20) : null;
            }

            public boolean hasSeparatorAboveOf(Object value) {
                return SidePanel.this.getSeparatorAbove((Place)value) != null;
            }

            public String getCaptionAboveOf(Object value) {
                return SidePanel.this.getSeparatorAbove((Place)value);
            }
        };
        this.myList.setCellRenderer(new GroupedItemsListRenderer(descriptor){
            JPanel myExtraPanel;
            SidePanelCountLabel myCountLabel;
            CellRendererPane myValidationParent;
            {
                super(x0);
                this.myValidationParent = new CellRendererPane();
                this.mySeparatorComponent.setCaptionCentered(false);
                SidePanel.this.myList.add(this.myValidationParent);
            }

            protected Color getForeground() {
                return Registry.is((String)"ide.new.project.settings") ? new JBColor((Color)Gray._60, (Color)Gray._140) : super.getForeground();
            }

            protected SeparatorWithText createSeparator() {
                return new SidePanelSeparator();
            }

            protected void layout() {
                if (Registry.is((String)"ide.new.project.settings")) {
                    this.myRendererComponent.add((Component)this.mySeparatorComponent, (Object)"North");
                    this.myExtraPanel.add((Component)this.myComponent, "Center");
                    this.myExtraPanel.add((Component)this.myCountLabel, "East");
                    this.myRendererComponent.add((Component)this.myExtraPanel, (Object)"Center");
                } else {
                    super.layout();
                }
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ErrorPaneConfigurable errorPane;
                this.layout();
                this.myCountLabel.setText("");
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if ("Problems".equals(descriptor.getTextFor(value)) && (errorPane = (ErrorPaneConfigurable)((Place)value).getPath("category")) != null && errorPane.getErrorsCount() > 0) {
                    this.myCountLabel.setSelected(isSelected);
                    this.myCountLabel.setText(String.valueOf(errorPane.getErrorsCount()));
                }
                if (UIUtil.getClientProperty((JComponent)list, (Key)ExpandableItemsHandler.EXPANDED_RENDERER) == Boolean.TRUE) {
                    Rectangle bounds = list.getCellBounds(index, index);
                    bounds.setSize((int)component.getPreferredSize().getWidth(), (int)bounds.getHeight());
                    AbstractExpandableItemsHandler.setRelativeBounds(component, bounds, this.myExtraPanel, this.myValidationParent);
                    this.myExtraPanel.setSize((int)this.myExtraPanel.getPreferredSize().getWidth(), this.myExtraPanel.getHeight());
                    UIUtil.putClientProperty((JComponent)this.myExtraPanel, (Key)ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)true);
                    return this.myExtraPanel;
                }
                return component;
            }

            @Override
            protected JComponent createItemComponent() {
                this.myExtraPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                this.myCountLabel = new SidePanelCountLabel();
                JComponent component = super.createItemComponent();
                if (Registry.is((String)"ide.new.project.settings")) {
                    this.myTextLabel.setForeground((Color)Gray._240);
                    this.myTextLabel.setOpaque(true);
                }
                return component;
            }

            protected Color getBackground() {
                return Registry.is((String)"ide.new.project.settings") ? UIUtil.SIDE_PANEL_BACKGROUND : super.getBackground();
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList, (boolean)Registry.is((String)"ide.new.project.settings")), "Center");
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Object value = SidePanel.this.myList.getSelectedValue();
                if (value != null) {
                    SidePanel.this.myNavigator.navigateTo((Place)value, false);
                }
            }
        });
    }

    public JList getList() {
        return this.myList;
    }

    public void addPlace(Place place, @NotNull Presentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/roots/ui/configuration/SidePanel", "addPlace"));
        }
        this.myModel.addElement(place);
        this.myPlaces.add(place);
        this.myPlace2Presentation.put(place, presentation);
        this.revalidate();
        this.repaint();
    }

    public void clear() {
        this.myModel.clear();
        this.myPlaces.clear();
        this.myPlace2Presentation.clear();
        this.myIndex2Separator.clear();
    }

    public void updatePlace(Place place) {
        int index = this.myPlaces.indexOf(place);
        this.myModel.set(index, place);
    }

    public void addSeparator(String text) {
        this.myIndex2Separator.put(this.myPlaces.size(), text);
    }

    @Nullable
    public String getSeparatorAbove(Place place) {
        return this.myIndex2Separator.get(this.myPlaces.indexOf(place));
    }

    public Collection<Place> getPlaces() {
        return this.myPlaces;
    }

    public void select(Place place) {
        this.myList.setSelectedValue(place, true);
    }
}

