/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.FilePathUnderVcs;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    private final Project myProject;
    private final VirtualFile myBaseDir;
    private final ModuleManager myModuleManager;

    public ModuleDefaultVcsRootPolicy(Project project) {
        this.myProject = project;
        this.myBaseDir = project.getBaseDir();
        this.myModuleManager = ModuleManager.getInstance((Project)this.myProject);
    }

    @Override
    public void addDefaultVcsRoots(NewMappings mappingList, @NotNull String vcsName, List<VirtualFile> result) {
        Module[] modules;
        AbstractVcs vcsFor;
        VirtualFile ideaDir;
        StorageScheme storageScheme;
        AbstractVcs vcsFor2;
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "com/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy", "addDefaultVcsRoots"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.myBaseDir != null && vcsName.equals(mappingList.getVcsFor(this.myBaseDir)) && (vcsFor2 = vcsManager.getVcsFor(this.myBaseDir)) != null && vcsName.equals(vcsFor2.getName())) {
            result.add(this.myBaseDir);
        }
        if (StorageScheme.DIRECTORY_BASED.equals((Object)(storageScheme = ((ProjectEx)this.myProject).getStateStore().getStorageScheme())) && this.myBaseDir != null && (ideaDir = this.myBaseDir.findChild(".idea")) != null && ideaDir.isValid() && ideaDir.isDirectory() && (vcsFor = vcsManager.getVcsFor(ideaDir)) != null && vcsName.equals(vcsFor.getName())) {
            result.add(ideaDir);
        }
        for (Module module : modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return ModuleDefaultVcsRootPolicy.this.myModuleManager.getModules();
            }
        })) {
            VirtualFile[] files;
            for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                String mappingVcs;
                VcsDirectoryMapping mapping = mappingList.getMappingFor(file, module);
                String string = mappingVcs = mapping != null ? mapping.getVcs() : null;
                if (!vcsName.equals(mappingVcs) || result.contains(file)) continue;
                result.add(file);
            }
        }
    }

    @Override
    public boolean matchesDefaultMapping(VirtualFile file, Object matchContext) {
        if (matchContext != null) {
            return true;
        }
        return this.myBaseDir != null && VfsUtilCore.isAncestor((VirtualFile)this.myBaseDir, (VirtualFile)file, (boolean)false);
    }

    @Override
    @Nullable
    public Object getMatchContext(VirtualFile file) {
        return ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
    }

    @Override
    @Nullable
    public VirtualFile getVcsRootFor(VirtualFile file) {
        VirtualFile ideaDir;
        if (this.myBaseDir != null && ((FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(this.myProject, FileIndexFacade.class)).isValidAncestor(this.myBaseDir, file)) {
            return this.myBaseDir;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(file, Registry.is((String)"ide.hide.excluded.files"));
        if (contentRoot != null) {
            return contentRoot;
        }
        StorageScheme storageScheme = ((ProjectEx)this.myProject).getStateStore().getStorageScheme();
        if (StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme) && this.myBaseDir != null && (ideaDir = this.myBaseDir.findChild(".idea")) != null && ideaDir.isValid() && ideaDir.isDirectory() && VfsUtilCore.isAncestor((VirtualFile)ideaDir, (VirtualFile)file, (boolean)false)) {
            return ideaDir;
        }
        return null;
    }

    @Override
    public void markDefaultRootsDirty(final DirtBuilder builder, final VcsGuess vcsGuess) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                AbstractVcs vcs;
                boolean haveDefaultMapping;
                FilePath fp;
                AbstractVcs vcs2;
                FilePath modules = ModuleDefaultVcsRootPolicy.this.myModuleManager.getModules();
                StorageScheme storageScheme = ((ProjectEx)ModuleDefaultVcsRootPolicy.this.myProject).getStateStore().getStorageScheme();
                if (StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme) && (vcs2 = vcsGuess.getVcsForDirty(fp = VcsUtil.getFilePath((VirtualFile)ModuleDefaultVcsRootPolicy.this.myBaseDir, (String)".idea", (boolean)true))) != null) {
                    builder.addDirtyDirRecursively(new FilePathUnderVcs(fp, vcs2));
                }
                for (FilePath module : modules) {
                    VirtualFile[] files;
                    for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                        AbstractVcs vcs3 = vcsGuess.getVcsForDirty(file);
                        if (vcs3 == null) continue;
                        builder.addDirtyDirRecursively(new VcsRoot(vcs3, file));
                    }
                }
                ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)ModuleDefaultVcsRootPolicy.this.myProject);
                String defaultMapping = ((ProjectLevelVcsManagerEx)plVcsManager).haveDefaultMapping();
                boolean bl = haveDefaultMapping = defaultMapping != null && !defaultMapping.isEmpty();
                if (haveDefaultMapping && ModuleDefaultVcsRootPolicy.this.myBaseDir != null && (vcs = vcsGuess.getVcsForDirty(ModuleDefaultVcsRootPolicy.this.myBaseDir)) != null) {
                    builder.addDirtyFile(new VcsRoot(vcs, ModuleDefaultVcsRootPolicy.this.myBaseDir));
                }
            }
        });
    }
}

