/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipHandler
extends ArchiveHandler {
    private volatile String myCanonicalPathToZip;
    private static final AtomicInteger myOpenRequests = new AtomicInteger();
    private static final AtomicLong myOpenTime = new AtomicLong();
    private static final AtomicLong myCloseTime = new AtomicLong();
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(10, 20){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ZipFile createAccessor(ZipHandler key) throws IOException {
            int requests = myOpenRequests.incrementAndGet();
            long started = System.nanoTime();
            try {
                ZipFile zipFile = new ZipFile(key.getCanonicalPathToZip());
                return zipFile;
            }
            finally {
                myOpenTime.addAndGet(System.nanoTime() - started);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void disposeAccessor(final ZipFile fileAccessor) {
            long started = System.nanoTime();
            try {
                this.disposeCloseable(new Closeable(){

                    @Override
                    public void close() throws IOException {
                        fileAccessor.close();
                    }
                });
            }
            finally {
                myCloseTime.addAndGet(System.nanoTime() - started);
            }
        }

        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/ZipHandler", "<init>"));
        }
        super(path);
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value = this.myCanonicalPathToZip;
        if (value == null) {
            this.myCanonicalPathToZip = value = this.getFileToUse().getCanonicalPath();
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getCanonicalPathToZip"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        ZipEntryMap map = new ZipEntryMap();
        map.put("", this.createRootEntry());
        FileAccessorCache.Handle zipRef = ourZipFileFileAccessorCache.get((Object)this);
        ZipFile zip = (ZipFile)zipRef.get();
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map, zip);
            }
        }
        finally {
            zipRef.release();
        }
        ZipEntryMap zipEntryMap = map;
        if (zipEntryMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "createEntriesMap"));
        }
        return zipEntryMap;
    }

    @NotNull
    protected File getFileToUse() {
        File file = this.getFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getFileToUse"));
        }
        return file;
    }

    public void dispose() {
        super.dispose();
        ourZipFileFileAccessorCache.remove((Object)this);
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (zip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar((CharSequence)entryName, (char)'/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        Pair path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
        if (".".equals(path.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandler.store(map, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), entry.getTime(), entryName);
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string) {
        void entryName;
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        CharSequence sequence = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfAsciiString((CharSequence)shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(parentInfo, sequence, isDirectory, size, time);
        map.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (zip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        ArchiveHandler.EntryInfo info = map.get(entryName);
        if (info == null) {
            ZipEntry entry = zip.getEntry(entryName + "/");
            if (entry != null) {
                ArchiveHandler.EntryInfo entryInfo = this.getOrCreate(entry, map, zip);
                if (entryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
                }
                return entryInfo;
            }
            Pair path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
            info = ZipHandler.store(map, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(((Object)((Object)this)).getClass()).info(zip.getName() + ": " + entryName + " should be a directory");
            info = ZipHandler.store(map, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block8: {
            byte[] byArray;
            InputStream stream;
            FileAccessorCache.Handle zipRef;
            block9: {
                if (relativePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
                }
                zipRef = ourZipFileFileAccessorCache.get((Object)this);
                ZipFile zip = (ZipFile)zipRef.get();
                ZipEntry entry = zip.getEntry(relativePath);
                if (entry == null || (stream = zip.getInputStream(entry)) == null) break block8;
                byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)entry.getSize()));
                stream.close();
                if (byArray != null) break block9;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
            }
            finally {
                zipRef.release();
            }
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }
}

