/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.lang.LangBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandlerStub;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class JrtFileSystem
extends ArchiveFileSystem {
    public static final String PROTOCOL = "jrt";
    public static final String SEPARATOR = "!/";
    private final Map<String, ArchiveHandler> myHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private final AtomicBoolean mySubscribed = new AtomicBoolean(false);

    public JrtFileSystem() {
        JrtFileSystem.scheduleConfiguredSdkCheck();
    }

    private static void scheduleConfiguredSdkCheck() {
        if (JrtFileSystem.isSupported()) {
            return;
        }
        final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appStarting(Project project) {
                for (Sdk sdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    String homePath = sdk.getHomePath();
                    if (homePath == null || !JrtFileSystem.isModularJdk(homePath)) continue;
                    String title = LangBundle.message("jrt.not.available.title", sdk.getName());
                    String message = LangBundle.message("jrt.not.available.message", new Object[0]);
                    Notifications.Bus.notify((Notification)new Notification("System Messages", title, message, NotificationType.WARNING));
                }
                connection.disconnect();
            }
        });
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "extractLocalPath"));
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)SEPARATOR);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "extractLocalPath"));
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "composeRootPath"));
        }
        String string = localPath + SEPARATOR;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "composeRootPath"));
        }
        return string;
    }

    @NotNull
    protected String extractRootPath(@NotNull String entryPath) {
        if (entryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryPath", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "extractRootPath"));
        }
        int separatorIndex = entryPath.indexOf(SEPARATOR);
        assert (separatorIndex >= 0) : "Path passed to JrtFileSystem must have a separator '!/': " + entryPath;
        String string = entryPath.substring(0, separatorIndex + SEPARATOR.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "extractRootPath"));
        }
        return string;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryFile", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "getHandler"));
        }
        this.checkSubscription();
        final String homePath = this.extractLocalPath(this.extractRootPath(entryFile.getPath()));
        ArchiveHandler handler = this.myHandlers.get(homePath);
        if (handler == null) {
            handler = JrtFileSystem.isSupported() ? new JrtHandler(homePath) : new JrtHandlerStub(homePath);
            this.myHandlers.put(homePath, handler);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(homePath + "/lib/modules");
                    if (dir != null) {
                        dir.getChildren();
                    }
                }
            }, ModalityState.defaultModalityState());
        }
        ArchiveHandler archiveHandler = handler;
        if (archiveHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "getHandler"));
        }
        return archiveHandler;
    }

    private void checkSubscription() {
        if (this.mySubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem$3", "after"));
                }
                HashSet toRefresh = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile root;
                    VirtualFile file;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !(vFileEvent instanceof VFileContentChangeEvent) || (file = vFileEvent.getFile()) == null || !"jimage".equals(file.getExtension())) continue;
                    String homePath = file.getParent().getParent().getParent().getPath();
                    if (JrtFileSystem.this.myHandlers.remove(homePath) == null || (root = JrtFileSystem.this.findFileByPath(JrtFileSystem.this.composeRootPath(homePath))) == null) continue;
                    ((NewVirtualFile)root).markDirtyRecursively();
                    if (toRefresh == null) {
                        toRefresh = ContainerUtil.newHashSet();
                    }
                    toRefresh.add(root);
                }
                if (toRefresh != null) {
                    boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                    RefreshQueue.getInstance().refresh(async, true, null, toRefresh);
                }
            }
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "findFileByPath"));
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "findFileByPathIfCached"));
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "refreshAndFindFileByPath"));
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }

    public static boolean isSupported() {
        return SystemInfo.isJavaVersionAtLeast((String)"1.8") && !SystemInfo.isJavaVersionAtLeast((String)"1.9");
    }

    public static boolean isModularJdk(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "isModularJdk"));
        }
        return new File(homePath, "lib/modules").isDirectory();
    }

    public static boolean isRoot(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystem", "isRoot"));
        }
        return file.getParent() == null && file.getFileSystem() instanceof JrtFileSystem;
    }
}

