/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import java.awt.Rectangle;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class WindowInfoImpl
implements Cloneable,
JDOMExternalizable,
WindowInfo {
    @NonNls
    static final String TAG = "window_info";
    static final float DEFAULT_WEIGHT = 0.33f;
    static final float DEFAULT_SIDE_WEIGHT = 0.5f;
    private boolean myActive;
    @NotNull
    private ToolWindowAnchor myAnchor;
    private boolean myAutoHide;
    private Rectangle myFloatingBounds;
    private String myId;
    private ToolWindowType myInternalType;
    private ToolWindowType myType;
    private boolean myVisible;
    private float myWeight;
    private float mySideWeight;
    private boolean mySplitMode;
    private ToolWindowContentUiType myContentUiType;
    private int myOrder;
    @NonNls
    static final String ID_ATTR = "id";
    @NonNls
    static final String ACTIVE_ATTR = "active";
    @NonNls
    static final String ANCHOR_ATTR = "anchor";
    @NonNls
    static final String AUTOHIDE_ATTR = "auto_hide";
    @NonNls
    static final String INTERNAL_TYPE_ATTR = "internal_type";
    @NonNls
    static final String TYPE_ATTR = "type";
    @NonNls
    static final String VISIBLE_ATTR = "visible";
    @NonNls
    static final String WEIGHT_ATTR = "weight";
    @NonNls
    static final String SIDE_WEIGHT_ATTR = "sideWeight";
    @NonNls
    static final String ORDER_ATTR = "order";
    @NonNls
    static final String X_ATTR = "x";
    @NonNls
    static final String Y_ATTR = "y";
    @NonNls
    static final String WIDTH_ATTR = "width";
    @NonNls
    static final String HEIGHT_ATTR = "height";
    @NonNls
    static final String SIDE_TOOL_ATTR = "side_tool";
    @NonNls
    static final String CONTENT_UI_ATTR = "content_ui";
    private boolean myWasRead;

    WindowInfoImpl(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR, "com/intellij/openapi/wm/impl/WindowInfoImpl", "<init>"));
        }
        this.myContentUiType = ToolWindowContentUiType.TABBED;
        this.myActive = false;
        this.myAnchor = ToolWindowAnchor.LEFT;
        this.myAutoHide = false;
        this.myFloatingBounds = null;
        this.myId = id;
        this.setType(ToolWindowType.DOCKED);
        this.myVisible = false;
        this.myWeight = 0.33f;
        this.mySideWeight = 0.5f;
        this.myOrder = -1;
        this.mySplitMode = false;
    }

    @NotNull
    public WindowInfoImpl copy() {
        WindowInfoImpl windowInfoImpl;
        try {
            WindowInfoImpl info = (WindowInfoImpl)this.clone();
            if (this.myFloatingBounds != null) {
                info.myFloatingBounds = (Rectangle)this.myFloatingBounds.clone();
            }
            windowInfoImpl = info;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (windowInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "copy"));
        }
        return windowInfoImpl;
    }

    void copyFrom(WindowInfoImpl info) {
        this.myActive = info.myActive;
        this.myAnchor = info.myAnchor;
        this.myAutoHide = info.myAutoHide;
        this.myFloatingBounds = info.myFloatingBounds == null ? null : (Rectangle)info.myFloatingBounds.clone();
        this.myId = info.myId;
        this.setTypeAndCheck(info.myType);
        this.myInternalType = info.myInternalType;
        this.myVisible = info.myVisible;
        this.myWeight = info.myWeight;
        this.mySideWeight = info.mySideWeight;
        this.myOrder = info.myOrder;
        this.mySplitMode = info.mySplitMode;
    }

    @NotNull
    public ToolWindowAnchor getAnchor() {
        ToolWindowAnchor toolWindowAnchor = this.myAnchor;
        if (toolWindowAnchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "getAnchor"));
        }
        return toolWindowAnchor;
    }

    public ToolWindowContentUiType getContentUiType() {
        return this.myContentUiType;
    }

    void setContentUiType(ToolWindowContentUiType type) {
        this.myContentUiType = type;
    }

    public Rectangle getFloatingBounds() {
        return this.myFloatingBounds != null ? new Rectangle(this.myFloatingBounds) : null;
    }

    @NotNull
    String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "getId"));
        }
        return string;
    }

    ToolWindowType getInternalType() {
        return this.myInternalType;
    }

    public ToolWindowType getType() {
        return this.myType;
    }

    float getWeight() {
        return this.myWeight;
    }

    float getSideWeight() {
        return this.mySideWeight;
    }

    public int getOrder() {
        return this.myOrder;
    }

    public void setOrder(int order) {
        this.myOrder = order;
    }

    public boolean isActive() {
        return this.myActive;
    }

    public boolean isAutoHide() {
        return this.myAutoHide;
    }

    public boolean isDocked() {
        return ToolWindowType.DOCKED == this.myType;
    }

    public boolean isFloating() {
        return ToolWindowType.FLOATING == this.myType;
    }

    public boolean isWindowed() {
        return ToolWindowType.WINDOWED == this.myType;
    }

    public boolean isSliding() {
        return ToolWindowType.SLIDING == this.myType;
    }

    boolean isVisible() {
        return this.myVisible;
    }

    public boolean isSplit() {
        return this.mySplitMode;
    }

    public void setSplit(boolean sideTool) {
        this.mySplitMode = sideTool;
    }

    private static ToolWindowType parseToolWindowType(String text) {
        if (ToolWindowType.DOCKED.toString().equalsIgnoreCase(text)) {
            return ToolWindowType.DOCKED;
        }
        if (ToolWindowType.WINDOWED.toString().equalsIgnoreCase(text)) {
            return ToolWindowType.WINDOWED;
        }
        if (ToolWindowType.FLOATING.toString().equalsIgnoreCase(text)) {
            return ToolWindowType.FLOATING;
        }
        if (ToolWindowType.SLIDING.toString().equalsIgnoreCase(text)) {
            return ToolWindowType.SLIDING;
        }
        throw new IllegalArgumentException(text);
    }

    @NotNull
    private static ToolWindowAnchor parseToolWindowAnchor(String text) {
        if (ToolWindowAnchor.TOP.toString().equalsIgnoreCase(text)) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.TOP;
            if (toolWindowAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "parseToolWindowAnchor"));
            }
            return toolWindowAnchor;
        }
        if (ToolWindowAnchor.LEFT.toString().equalsIgnoreCase(text)) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
            if (toolWindowAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "parseToolWindowAnchor"));
            }
            return toolWindowAnchor;
        }
        if (ToolWindowAnchor.BOTTOM.toString().equalsIgnoreCase(text)) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            if (toolWindowAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "parseToolWindowAnchor"));
            }
            return toolWindowAnchor;
        }
        if (ToolWindowAnchor.RIGHT.toString().equalsIgnoreCase(text)) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.RIGHT;
            if (toolWindowAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "parseToolWindowAnchor"));
            }
            return toolWindowAnchor;
        }
        throw new IllegalArgumentException(text);
    }

    public void readExternal(Element element) {
        this.myId = element.getAttributeValue(ID_ATTR);
        this.myWasRead = true;
        try {
            this.myActive = Boolean.valueOf(element.getAttributeValue(ACTIVE_ATTR));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.myAnchor = WindowInfoImpl.parseToolWindowAnchor(element.getAttributeValue(ANCHOR_ATTR));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.myAutoHide = Boolean.valueOf(element.getAttributeValue(AUTOHIDE_ATTR));
        try {
            this.myInternalType = WindowInfoImpl.parseToolWindowType(element.getAttributeValue(INTERNAL_TYPE_ATTR));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.setTypeAndCheck(WindowInfoImpl.parseToolWindowType(element.getAttributeValue(TYPE_ATTR)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.myVisible = Boolean.valueOf(element.getAttributeValue(VISIBLE_ATTR));
        try {
            this.myWeight = Float.parseFloat(element.getAttributeValue(WEIGHT_ATTR));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            String value = element.getAttributeValue(SIDE_WEIGHT_ATTR);
            if (value != null) {
                this.mySideWeight = Float.parseFloat(value);
            }
        }
        catch (NumberFormatException value) {
            // empty catch block
        }
        try {
            this.myOrder = Integer.valueOf(element.getAttributeValue(ORDER_ATTR));
        }
        catch (NumberFormatException value) {
            // empty catch block
        }
        try {
            int x = Integer.parseInt(element.getAttributeValue(X_ATTR));
            int y = Integer.parseInt(element.getAttributeValue(Y_ATTR));
            int width = Integer.parseInt(element.getAttributeValue(WIDTH_ATTR));
            int height = Integer.parseInt(element.getAttributeValue(HEIGHT_ATTR));
            this.myFloatingBounds = new Rectangle(x, y, width, height);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mySplitMode = Boolean.parseBoolean(element.getAttributeValue(SIDE_TOOL_ATTR));
        this.myContentUiType = ToolWindowContentUiType.getInstance((String)element.getAttributeValue(CONTENT_UI_ATTR));
    }

    void setAnchor(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ANCHOR_ATTR, "com/intellij/openapi/wm/impl/WindowInfoImpl", "setAnchor"));
        }
        this.myAnchor = anchor;
    }

    void setActive(boolean active) {
        this.myActive = active;
    }

    void setAutoHide(boolean autoHide) {
        this.myAutoHide = autoHide;
    }

    void setFloatingBounds(Rectangle floatingBounds) {
        this.myFloatingBounds = floatingBounds;
    }

    void setType(@NotNull ToolWindowType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TYPE_ATTR, "com/intellij/openapi/wm/impl/WindowInfoImpl", "setType"));
        }
        if (ToolWindowType.DOCKED == type || ToolWindowType.SLIDING == type) {
            this.myInternalType = type;
        }
        this.setTypeAndCheck(type);
    }

    private void setTypeAndCheck(ToolWindowType type) {
        this.myType = ToolWindowId.PREVIEW == this.myId && type == ToolWindowType.DOCKED ? ToolWindowType.SLIDING : type;
    }

    void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    void setWeight(float weight) {
        this.myWeight = Math.max(0.0f, Math.min(1.0f, weight));
    }

    void setSideWeight(float weight) {
        this.mySideWeight = Math.max(0.0f, Math.min(1.0f, weight));
    }

    public void writeExternal(Element element) {
        element.setAttribute(ID_ATTR, this.myId);
        element.setAttribute(ACTIVE_ATTR, Boolean.toString(this.myActive));
        element.setAttribute(ANCHOR_ATTR, this.myAnchor.toString());
        element.setAttribute(AUTOHIDE_ATTR, Boolean.toString(this.myAutoHide));
        element.setAttribute(INTERNAL_TYPE_ATTR, this.myInternalType.toString());
        element.setAttribute(TYPE_ATTR, this.myType.toString());
        element.setAttribute(VISIBLE_ATTR, Boolean.toString(this.myVisible));
        element.setAttribute(WEIGHT_ATTR, Float.toString(this.myWeight));
        element.setAttribute(SIDE_WEIGHT_ATTR, Float.toString(this.mySideWeight));
        element.setAttribute(ORDER_ATTR, Integer.toString(this.myOrder));
        element.setAttribute(SIDE_TOOL_ATTR, Boolean.toString(this.mySplitMode));
        element.setAttribute(CONTENT_UI_ATTR, this.myContentUiType.getName());
        if (this.myFloatingBounds != null) {
            element.setAttribute(X_ATTR, Integer.toString(this.myFloatingBounds.x));
            element.setAttribute(Y_ATTR, Integer.toString(this.myFloatingBounds.y));
            element.setAttribute(WIDTH_ATTR, Integer.toString(this.myFloatingBounds.width));
            element.setAttribute(HEIGHT_ATTR, Integer.toString(this.myFloatingBounds.height));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WindowInfoImpl)) {
            return false;
        }
        WindowInfoImpl info = (WindowInfoImpl)obj;
        return this.myActive == info.myActive && this.myAnchor == info.myAnchor && this.myId.equals(info.myId) && this.myAutoHide == info.myAutoHide && Comparing.equal((Object)this.myFloatingBounds, (Object)info.myFloatingBounds) && this.myInternalType == info.myInternalType && this.myType == info.myType && this.myVisible == info.myVisible && this.myWeight == info.myWeight && this.mySideWeight == info.mySideWeight && this.myOrder == info.myOrder && this.mySplitMode == info.mySplitMode && this.myContentUiType == info.myContentUiType;
    }

    public int hashCode() {
        return this.myAnchor.hashCode() + this.myId.hashCode() + this.myType.hashCode() + this.myOrder;
    }

    public String toString() {
        return this.getClass().getName() + "[myId=" + this.myId + "; myVisible=" + this.myVisible + "; myActive=" + this.myActive + "; myAnchor=" + this.myAnchor + "; myOrder=" + this.myOrder + "; myAutoHide=" + this.myAutoHide + "; myWeight=" + this.myWeight + "; mySideWeight=" + this.mySideWeight + "; myType=" + this.myType + "; myInternalType=" + this.myInternalType + "; myFloatingBounds=" + this.myFloatingBounds + "; mySplitMode=" + this.mySplitMode + ']';
    }

    public boolean wasRead() {
        return this.myWasRead;
    }
}

