/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntryDependencyInfo;
import com.intellij.psi.codeStyle.arrangement.FieldDependenciesManager;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementOverriddenMethodsInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementPropertyInfo;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaArrangementParseInfo {
    private final List<JavaElementArrangementEntry> myEntries = new ArrayList<JavaElementArrangementEntry>();
    private final Map<Pair<String, String>, JavaArrangementPropertyInfo> myProperties = new HashMap<Pair<String, String>, JavaArrangementPropertyInfo>();
    private final List<ArrangementEntryDependencyInfo> myMethodDependencyRoots = new ArrayList<ArrangementEntryDependencyInfo>();
    private final Map<PsiMethod, Set<PsiMethod>> myMethodDependencies = new HashMap<PsiMethod, Set<PsiMethod>>();
    private final Map<PsiMethod, JavaElementArrangementEntry> myMethodEntriesMap = new HashMap<PsiMethod, JavaElementArrangementEntry>();
    private final Map<PsiClass, List<Pair<PsiMethod, PsiMethod>>> myOverriddenMethods = new LinkedHashMap<PsiClass, List<Pair<PsiMethod, PsiMethod>>>();
    private final Set<PsiMethod> myTmpMethodDependencyRoots = new LinkedHashSet<PsiMethod>();
    private final Set<PsiMethod> myDependentMethods = new HashSet<PsiMethod>();
    private boolean myRebuildMethodDependencies;
    private final HashMap<PsiField, JavaElementArrangementEntry> myFields = ContainerUtil.newLinkedHashMap();
    private final Map<PsiField, Set<PsiField>> myFieldDependencies = ContainerUtil.newHashMap();

    @NotNull
    public List<JavaElementArrangementEntry> getEntries() {
        List<JavaElementArrangementEntry> list = this.myEntries;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getEntries"));
        }
        return list;
    }

    public void addEntry(@NotNull JavaElementArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "addEntry"));
        }
        this.myEntries.add(entry);
    }

    @NotNull
    public Collection<JavaArrangementPropertyInfo> getProperties() {
        Collection<JavaArrangementPropertyInfo> collection = this.myProperties.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getProperties"));
        }
        return collection;
    }

    @NotNull
    public List<ArrangementEntryDependencyInfo> getMethodDependencyRoots() {
        if (this.myRebuildMethodDependencies) {
            this.myMethodDependencyRoots.clear();
            HashMap<PsiMethod, ArrangementEntryDependencyInfo> cache = new HashMap<PsiMethod, ArrangementEntryDependencyInfo>();
            for (PsiMethod method : this.myTmpMethodDependencyRoots) {
                ArrangementEntryDependencyInfo info = this.buildMethodDependencyInfo(method, cache);
                if (info == null) continue;
                this.myMethodDependencyRoots.add(info);
            }
            this.myRebuildMethodDependencies = false;
        }
        List<ArrangementEntryDependencyInfo> list = this.myMethodDependencyRoots;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getMethodDependencyRoots"));
        }
        return list;
    }

    @Nullable
    private ArrangementEntryDependencyInfo buildMethodDependencyInfo(@NotNull PsiMethod method, @NotNull Map<PsiMethod, ArrangementEntryDependencyInfo> cache) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "buildMethodDependencyInfo"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "buildMethodDependencyInfo"));
        }
        JavaElementArrangementEntry entry = this.myMethodEntriesMap.get(method);
        if (entry == null) {
            return null;
        }
        ArrangementEntryDependencyInfo result = new ArrangementEntryDependencyInfo(entry);
        Stack toProcess = new Stack();
        toProcess.push((Object)Pair.create((Object)method, (Object)result));
        HashSet usedMethods = ContainerUtilRt.newHashSet();
        while (!toProcess.isEmpty()) {
            Pair pair = (Pair)toProcess.pop();
            Set<PsiMethod> dependentMethods = this.myMethodDependencies.get(pair.first);
            if (dependentMethods == null) continue;
            usedMethods.add(pair.first);
            for (PsiMethod dependentMethod : dependentMethods) {
                if (usedMethods.contains(dependentMethod)) {
                    return null;
                }
                JavaElementArrangementEntry dependentEntry = this.myMethodEntriesMap.get(dependentMethod);
                if (dependentEntry == null) continue;
                ArrangementEntryDependencyInfo dependentMethodInfo = cache.get(dependentMethod);
                if (dependentMethodInfo == null) {
                    dependentMethodInfo = new ArrangementEntryDependencyInfo(dependentEntry);
                    cache.put(dependentMethod, dependentMethodInfo);
                }
                Pair dependentPair = Pair.create((Object)dependentMethod, (Object)dependentMethodInfo);
                ((ArrangementEntryDependencyInfo)pair.second).addDependentEntryInfo((ArrangementEntryDependencyInfo)dependentPair.second);
                toProcess.push((Object)dependentPair);
            }
        }
        return result;
    }

    public void registerGetter(@NotNull String propertyName, @NotNull String className, @NotNull JavaElementArrangementEntry entry) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerGetter"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerGetter"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerGetter"));
        }
        this.getPropertyInfo(propertyName, className).setGetter(entry);
    }

    public void registerSetter(@NotNull String propertyName, @NotNull String className, @NotNull JavaElementArrangementEntry entry) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerSetter"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerSetter"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerSetter"));
        }
        this.getPropertyInfo(propertyName, className).setSetter(entry);
    }

    @NotNull
    private JavaArrangementPropertyInfo getPropertyInfo(@NotNull String propertyName, @NotNull String className) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getPropertyInfo"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getPropertyInfo"));
        }
        Pair key = Pair.create((Object)propertyName, (Object)className);
        JavaArrangementPropertyInfo propertyInfo = this.myProperties.get(key);
        if (propertyInfo == null) {
            propertyInfo = new JavaArrangementPropertyInfo();
            this.myProperties.put((Pair<String, String>)key, propertyInfo);
        }
        JavaArrangementPropertyInfo javaArrangementPropertyInfo = propertyInfo;
        if (javaArrangementPropertyInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getPropertyInfo"));
        }
        return javaArrangementPropertyInfo;
    }

    public void onMethodEntryCreated(@NotNull PsiMethod method, @NotNull JavaElementArrangementEntry entry) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "onMethodEntryCreated"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "onMethodEntryCreated"));
        }
        this.myMethodEntriesMap.put(method, entry);
    }

    public void onFieldEntryCreated(@NotNull PsiField field, @NotNull JavaElementArrangementEntry entry) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "onFieldEntryCreated"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "onFieldEntryCreated"));
        }
        this.myFields.put(field, entry);
    }

    public void onOverriddenMethod(@NotNull PsiMethod baseMethod, @NotNull PsiMethod overridingMethod) {
        if (baseMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "onOverriddenMethod"));
        }
        if (overridingMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridingMethod", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "onOverriddenMethod"));
        }
        PsiClass clazz = baseMethod.getContainingClass();
        if (clazz == null) {
            return;
        }
        List<Pair<PsiMethod, PsiMethod>> methods = this.myOverriddenMethods.get(clazz);
        if (methods == null) {
            methods = new ArrayList<Pair<PsiMethod, PsiMethod>>();
            this.myOverriddenMethods.put(clazz, methods);
        }
        methods.add((Pair<PsiMethod, PsiMethod>)Pair.create((Object)baseMethod, (Object)overridingMethod));
    }

    @NotNull
    public List<JavaArrangementOverriddenMethodsInfo> getOverriddenMethods() {
        ArrayList<JavaArrangementOverriddenMethodsInfo> result = new ArrayList<JavaArrangementOverriddenMethodsInfo>();
        final TObjectIntHashMap weights = new TObjectIntHashMap();
        Comparator<Pair<PsiMethod, PsiMethod>> comparator = new Comparator<Pair<PsiMethod, PsiMethod>>(){

            @Override
            public int compare(Pair<PsiMethod, PsiMethod> o1, Pair<PsiMethod, PsiMethod> o2) {
                return weights.get(o1.first) - weights.get(o2.first);
            }
        };
        for (Map.Entry<PsiClass, List<Pair<PsiMethod, PsiMethod>>> entry : this.myOverriddenMethods.entrySet()) {
            JavaArrangementOverriddenMethodsInfo info = new JavaArrangementOverriddenMethodsInfo(entry.getKey().getName());
            weights.clear();
            int i = 0;
            for (PsiMethod method : entry.getKey().getMethods()) {
                weights.put((Object)method, i++);
            }
            ContainerUtil.sort(entry.getValue(), (Comparator)comparator);
            for (Pair pair : entry.getValue()) {
                JavaElementArrangementEntry overridingMethodEntry = this.myMethodEntriesMap.get(pair.second);
                if (overridingMethodEntry == null) continue;
                info.addMethodEntry(overridingMethodEntry);
            }
            if (info.getMethodEntries().isEmpty()) continue;
            result.add(info);
        }
        ArrayList<JavaArrangementOverriddenMethodsInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getOverriddenMethods"));
        }
        return arrayList;
    }

    public void registerMethodCallDependency(@NotNull PsiMethod caller, @NotNull PsiMethod callee) {
        if (caller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caller", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerMethodCallDependency"));
        }
        if (callee == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callee", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerMethodCallDependency"));
        }
        this.myTmpMethodDependencyRoots.remove(callee);
        if (!this.myDependentMethods.contains(caller)) {
            this.myTmpMethodDependencyRoots.add(caller);
        }
        this.myDependentMethods.add(callee);
        Set<PsiMethod> methods = this.myMethodDependencies.get(caller);
        if (methods == null) {
            methods = new LinkedHashSet<PsiMethod>();
            this.myMethodDependencies.put(caller, methods);
        }
        if (!methods.contains(callee)) {
            methods.add(callee);
        }
        this.myRebuildMethodDependencies = true;
    }

    public void registerFieldInitializationDependency(@NotNull PsiField fieldToInitialize, @NotNull PsiField usedInInitialization) {
        if (fieldToInitialize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToInitialize", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerFieldInitializationDependency"));
        }
        if (usedInInitialization == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedInInitialization", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "registerFieldInitializationDependency"));
        }
        HashSet fields = this.myFieldDependencies.get(fieldToInitialize);
        if (fields == null) {
            fields = ContainerUtil.newHashSet();
            this.myFieldDependencies.put(fieldToInitialize, fields);
        }
        fields.add(usedInInitialization);
    }

    @NotNull
    public List<ArrangementEntryDependencyInfo> getFieldDependencyRoots() {
        List<ArrangementEntryDependencyInfo> list = new FieldDependenciesManager(this.myFieldDependencies, this.myFields).getRoots();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getFieldDependencyRoots"));
        }
        return list;
    }

    @NotNull
    public Collection<JavaElementArrangementEntry> getFields() {
        Collection<JavaElementArrangementEntry> collection = this.myFields.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementParseInfo", "getFields"));
        }
        return collection;
    }
}

