/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LowLevelSearchUtil {
    private static Boolean processInjectedFile(PsiElement element, TextOccurenceProcessor processor, StringSearcher searcher, ProgressIndicator progress, InjectedLanguageManager injectedLanguageManager) {
        if (!(element instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        if (injectedLanguageManager == null) {
            return null;
        }
        List list = injectedLanguageManager.getInjectedPsiFiles(element);
        if (list == null) {
            return null;
        }
        for (Pair pair : list) {
            PsiElement injected = (PsiElement)pair.getFirst();
            if (LowLevelSearchUtil.processElementsContainingWordInElement(processor, injected, searcher, false, progress)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static TreeElement processTreeUp(@NotNull Project project, @NotNull TextOccurenceProcessor processor, @NotNull PsiElement scope, @NotNull StringSearcher searcher, int offset, boolean processInjectedPsi, ProgressIndicator progress, TreeElement lastElement) {
        int start;
        boolean useTree;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        int scopeStartOffset = scope.getTextRange().getStartOffset();
        int patternLength = searcher.getPatternLength();
        ASTNode scopeNode = scope.getNode();
        boolean bl = useTree = scopeNode != null;
        assert (scope.isValid());
        TreeElement leafNode = null;
        PsiElement leafElement = null;
        if (useTree) {
            leafNode = LowLevelSearchUtil.findNextLeafElementAt(scopeNode, lastElement, offset);
            if (leafNode == null) {
                return lastElement;
            }
            start = offset - leafNode.getStartOffset() + scopeStartOffset;
        } else {
            leafElement = scope instanceof PsiFile ? ((PsiFile)scope).getViewProvider().findElementAt(offset, scope.getLanguage()) : scope.findElementAt(offset);
            if (leafElement == null) {
                return lastElement;
            }
            assert (leafElement.isValid());
            start = offset - leafElement.getTextRange().getStartOffset() + scopeStartOffset;
        }
        if (start < 0) {
            throw new AssertionError((Object)("offset=" + offset + " scopeStartOffset=" + scopeStartOffset + " leafElement=" + leafElement + "  scope=" + scope));
        }
        boolean contains = false;
        PsiElement prev = null;
        TreeElement prevNode = null;
        PsiElement run = null;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        lastElement = leafNode;
        while (run != scope) {
            if (progress != null) {
                progress.checkCanceled();
            }
            if (useTree) {
                start += prevNode == null ? 0 : prevNode.getStartOffsetInParent();
                prevNode = leafNode;
                run = leafNode.getPsi();
            } else {
                start += prev == null ? 0 : prev.getStartOffsetInParent();
                prev = run;
                run = leafElement;
            }
            if (!contains) {
                boolean bl2 = contains = run.getTextLength() - start >= patternLength;
            }
            if (contains) {
                Boolean result;
                if (processInjectedPsi && (result = LowLevelSearchUtil.processInjectedFile(run, processor, searcher, progress, injectedLanguageManager)) != null) {
                    return result != false ? lastElement : null;
                }
                if (!processor.execute(run, start)) {
                    return null;
                }
            }
            if (!(useTree ? (leafNode = leafNode.getTreeParent()) == null : (leafElement = leafElement.getParent()) == null)) continue;
        }
        assert (run == scope) : "Malbuilt PSI: scopeNode=" + scope + "; leafNode=" + run + "; isAncestor=" + PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)run, (boolean)false);
        return lastElement;
    }

    private static TreeElement findNextLeafElementAt(ASTNode scopeNode, TreeElement last, int offset) {
        int offsetR = offset;
        if (last != null) {
            offsetR -= last.getStartOffset() - scopeNode.getStartOffset() + last.getTextLength();
            while (offsetR >= 0) {
                TreeElement next = last.getTreeNext();
                if (next == null) {
                    last = last.getTreeParent();
                    continue;
                }
                int length = next.getTextLength();
                offsetR -= length;
                last = next;
            }
            scopeNode = last;
            offsetR += scopeNode.getTextLength();
        }
        LeafElement leafNode = (LeafElement)scopeNode.findLeafElementAt(offsetR);
        return leafNode;
    }

    public static boolean processElementsContainingWordInElement(@NotNull TextOccurenceProcessor processor, @NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, ProgressIndicator progress) {
        int scopeStart;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (progress != null) {
            progress.checkCanceled();
        }
        PsiFile file = scope.getContainingFile();
        CharSequence buffer = file.getViewProvider().getContents();
        TextRange range = scope.getTextRange();
        if (range == null) {
            throw new AssertionError((Object)("Element " + scope + " of class " + scope.getClass() + " has null range"));
        }
        int startOffset = scopeStart = range.getStartOffset();
        int endOffset = range.getEndOffset();
        if (endOffset > buffer.length()) {
            throw new AssertionError((Object)("Range for element: '" + scope + "' = " + range + " is out of file '" + file + "' range: " + file.getTextRange() + "; file contents length: " + buffer.length() + "; file provider: " + file.getViewProvider()));
        }
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        Project project = file.getProject();
        TreeElement lastElement = null;
        do {
            if (progress != null) {
                progress.checkCanceled();
            }
            if ((startOffset = LowLevelSearchUtil.searchWord(buffer, bufferArray, startOffset, endOffset, searcher, progress)) < 0) {
                return true;
            }
            if ((lastElement = LowLevelSearchUtil.processTreeUp(project, processor, scope, searcher, startOffset - scopeStart, processInjectedPsi, progress, lastElement)) != null) continue;
            return false;
        } while (++startOffset < endOffset);
        return true;
    }

    public static int searchWord(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @Nullable ProgressIndicator progress) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/LowLevelSearchUtil", "searchWord"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "searchWord"));
        }
        return LowLevelSearchUtil.searchWord(text, null, startOffset, endOffset, searcher, progress);
    }

    public static int searchWord(@NotNull CharSequence text, @Nullable char[] textArray, int startOffset, int endOffset, @NotNull StringSearcher searcher, @Nullable ProgressIndicator progress) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/LowLevelSearchUtil", "searchWord"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "searchWord"));
        }
        if (endOffset > text.length()) {
            throw new AssertionError((Object)"end>length");
        }
        for (int index = startOffset; index < endOffset; ++index) {
            int patternLength;
            if (progress != null) {
                progress.checkCanceled();
            }
            if ((index = searcher.scan(text, textArray, index, endOffset)) < 0) {
                return -1;
            }
            if (!searcher.isJavaIdentifier()) {
                return index;
            }
            if (index > startOffset) {
                char c;
                char c2 = c = textArray != null ? textArray[index - 1] : text.charAt(index - 1);
                if (!Character.isJavaIdentifierPart(c) || c == '$' ? index > 0 && searcher.isHandleEscapeSequences() && LowLevelSearchUtil.isNotEscapedBackslash(text, textArray, startOffset, index - 1) : !searcher.isHandleEscapeSequences() || index < 2 || !LowLevelSearchUtil.isNotEscapedBackslash(text, textArray, startOffset, index - 2)) continue;
            }
            if (index + (patternLength = searcher.getPattern().length()) < endOffset) {
                char c;
                char c3 = c = textArray != null ? textArray[index + patternLength] : text.charAt(index + patternLength);
                if (Character.isJavaIdentifierPart(c) && c != '$') continue;
            }
            return index;
        }
        return -1;
    }

    private static boolean isNotEscapedBackslash(CharSequence text, char[] textArray, int startOffset, int index) {
        return textArray != null ? StringUtil.isNotEscapedBackslash((char[])textArray, (int)startOffset, (int)index) : StringUtil.isNotEscapedBackslash((CharSequence)text, (int)startOffset, (int)index);
    }
}

