/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.AnchorElementInfoFactory;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorElementInfo
extends SelfElementInfo {
    private volatile long myStubElementTypeAndId;

    AnchorElementInfo(@NotNull PsiElement anchor, @NotNull PsiFile containingFile) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), ProperTextRange.create((Segment)anchor.getTextRange()), anchor.getClass(), containingFile, LanguageUtil.getRootLanguage((PsiElement)anchor));
        assert (!(anchor instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor;
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    AnchorElementInfo(@NotNull PsiElement anchor, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType stubElementType) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (stubElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElementType", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), new ProperTextRange(0, 0), anchor.getClass(), containingFile, containingFile.getLanguage());
        this.myStubElementTypeAndId = AnchorElementInfo.pack(stubId, stubElementType);
        assert (!(anchor instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor;
    }

    private static long pack(int stubId, IStubElementType stubElementType) {
        short index;
        short s = index = stubElementType == null ? (short)0 : stubElementType.getIndex();
        assert (index >= 0) : "Unregistered token types not allowed here: " + stubElementType;
        return (long)stubId | (long)index << 32;
    }

    private int getStubId() {
        return (int)this.myStubElementTypeAndId;
    }

    @Override
    @Nullable
    public PsiElement restoreElement() {
        long typeAndId = this.myStubElementTypeAndId;
        int stubId = (int)typeAndId;
        if (stubId != -1) {
            PsiFile file = this.restoreFile();
            if (!(file instanceof PsiFileWithStubSupport)) {
                return null;
            }
            short index = (short)(typeAndId >> 32);
            IStubElementType stubElementType = (IStubElementType)IElementType.find((short)index);
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file, stubId, stubElementType, false);
        }
        if (!this.mySyncMarkerIsValid) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null) {
            return null;
        }
        PsiElement anchor = file.findElementAt(this.getSyncStartOffset());
        if (anchor == null) {
            return null;
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != this.getSyncStartOffset() || range.getEndOffset() != this.getSyncEndOffset()) {
            return null;
        }
        for (SmartPointerAnchorProvider provider : (SmartPointerAnchorProvider[])SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
            PsiElement element = provider.restoreElement(anchor);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public boolean pointsToTheSameElementAs(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof AnchorElementInfo) {
            AnchorElementInfo otherAnchor = (AnchorElementInfo)other;
            if (this.getStubId() == -1 != (otherAnchor.getStubId() == -1)) {
                return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return Comparing.equal((Object)AnchorElementInfo.this.restoreElement(), (Object)other.restoreElement());
                    }
                });
            }
            if (this.myStubElementTypeAndId != otherAnchor.myStubElementTypeAndId) {
                return false;
            }
        }
        return super.pointsToTheSameElementAs(other);
    }

    @Override
    public void fastenBelt(int offset, RangeMarker[] cachedRangeMarker) {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        super.fastenBelt(offset, cachedRangeMarker);
    }

    private void switchToTree() {
        PsiElement element = this.restoreElement();
        if (element != null) {
            this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
            PsiElement anchor = AnchorElementInfoFactory.getAnchor(element);
            this.setRange((Segment)(anchor == null ? element : anchor).getTextRange());
        }
    }

    @Override
    public Segment getRange() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        return super.getRange();
    }
}

