/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.regex.Pattern;

public class AutomaticTestRenamerFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(PsiElement element) {
        String qualifiedName;
        if (element instanceof PsiClass && (qualifiedName = ((PsiClass)element).getQualifiedName()) != null) {
            return !qualifiedName.endsWith("Test") && !qualifiedName.endsWith("TestCase");
        }
        return false;
    }

    @Override
    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.tests");
    }

    @Override
    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isToRenameTests();
    }

    @Override
    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameTests(enabled);
    }

    @Override
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new TestsRenamer((PsiClass)element, newName);
    }

    private static class TestsRenamer
    extends AutomaticRenamer {
        public TestsRenamer(PsiClass aClass, String newClassName) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (module != null) {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
                this.appendTestClass(aClass, "Test", moduleScope);
                this.appendTestClass(aClass, "TestCase", moduleScope);
                this.suggestAllNames(aClass.getName(), newClassName);
            }
        }

        private void appendTestClass(PsiClass aClass, String testSuffix, GlobalSearchScope moduleScope) {
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)aClass.getProject());
            String klassName = aClass.getName();
            Pattern pattern = Pattern.compile(".*" + klassName + ".*" + testSuffix);
            HashSet names = new HashSet();
            cache.getAllClassNames(names);
            for (String eachName : names) {
                if (!pattern.matcher(eachName).matches()) continue;
                for (PsiClass eachClass : cache.getClassesByName(eachName, moduleScope)) {
                    if (!TestFrameworks.getInstance().isTestClass(eachClass)) continue;
                    this.myElements.add(eachClass);
                }
            }
        }

        @Override
        public String getDialogTitle() {
            return RefactoringBundle.message((String)"rename.tests.title");
        }

        @Override
        public String getDialogDescription() {
            return RefactoringBundle.message((String)"rename.tests.with.the.following.names.to");
        }

        @Override
        public String entityName() {
            return RefactoringBundle.message((String)"entity.name.test");
        }
    }
}

