/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.slicer.SliceForwardUtil;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SliceUtil {
    SliceUtil() {
    }

    static boolean processUsagesFlownDownTo(@NotNull PsiElement expression, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField) {
        int parametersCount;
        PsiMethod method;
        PsiElement par;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/slicer/SliceUtil", "processUsagesFlownDownTo"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUtil", "processUsagesFlownDownTo"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "processUsagesFlownDownTo"));
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSubstitutor", "com/intellij/slicer/SliceUtil", "processUsagesFlownDownTo"));
        }
        if (syntheticField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticField", "com/intellij/slicer/SliceUtil", "processUsagesFlownDownTo"));
        }
        assert (indexNesting >= 0) : indexNesting;
        PsiElement original = expression = SliceUtil.simplify(expression);
        if (expression instanceof PsiArrayAccessExpression) {
            expression = ((PsiArrayAccessExpression)expression).getArrayExpression();
            ++indexNesting;
        }
        PsiElement psiElement = par = expression == null ? null : expression.getParent();
        if (expression instanceof PsiExpressionList && par instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)par).resolveMethod()) != null && (parametersCount = method.getParameterList().getParametersCount()) != 0) {
            PsiExpression[] expressions = ((PsiExpressionList)expression).getExpressions();
            if (indexNesting != 0) {
                for (int i = parametersCount - 1; i < expressions.length; ++i) {
                    PsiExpression arg = expressions[i];
                    if (SliceUtil.handToProcessor((PsiElement)arg, processor, parent, parentSubstitutor, indexNesting - 1, syntheticField)) continue;
                    return false;
                }
            }
            return true;
        }
        boolean needToReportDeclaration = false;
        if (expression instanceof PsiReferenceExpression) {
            PsiElement element = SliceForwardUtil.complexify(expression);
            if (element instanceof PsiExpression && PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element))) {
                PsiExpression rightSide = ((PsiAssignmentExpression)element.getParent()).getRExpression();
                return rightSide == null || SliceUtil.handToProcessor((PsiElement)rightSide, processor, parent, parentSubstitutor, indexNesting, syntheticField);
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            JavaResolveResult result = ref.advancedResolve(false);
            parentSubstitutor = result.getSubstitutor().putAll(parentSubstitutor);
            PsiElement resolved = result.getElement();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            if (resolved instanceof PsiMethod && expression.getParent() instanceof PsiMethodCallExpression) {
                return SliceUtil.processUsagesFlownDownTo(expression.getParent(), processor, parent, parentSubstitutor, indexNesting, syntheticField);
            }
            if (!(resolved instanceof PsiVariable)) {
                return true;
            }
            SliceUtil.addContainerReferences((PsiVariable)resolved, processor, parent, parentSubstitutor, indexNesting, syntheticField);
            needToReportDeclaration = true;
            expression = resolved;
        }
        if (expression instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)expression;
            Collection<PsiExpression> values = DfaUtil.getCachedVariableValues(variable, original);
            if (values == null) {
                SliceUsage stopUsage = SliceUtil.createTooComplexDFAUsage(expression, parent, parentSubstitutor);
                return processor.process((Object)stopUsage);
            }
            THashSet expressions = new THashSet(values);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && expressions.isEmpty()) {
                expressions.add(initializer);
            }
            boolean initializerReported = false;
            for (PsiExpression exp : expressions) {
                if (!SliceUtil.handToProcessor((PsiElement)exp, processor, parent, parentSubstitutor, indexNesting, syntheticField)) {
                    return false;
                }
                if (exp != initializer) continue;
                initializerReported = true;
            }
            if (!initializerReported && needToReportDeclaration) {
                return SliceUtil.handToProcessor((PsiElement)variable, processor, parent, parentSubstitutor, indexNesting, syntheticField);
            }
            if (variable instanceof PsiField) {
                return SliceUtil.processFieldUsages((PsiField)variable, parent, parentSubstitutor, processor);
            }
            if (variable instanceof PsiParameter) {
                return SliceUtil.processParameterUsages((PsiParameter)variable, parent, parentSubstitutor, indexNesting, syntheticField, processor);
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethod method2 = ((PsiMethodCallExpression)expression).resolveMethod();
            Flow anno = SliceUtil.isMethodFlowAnnotated(method2);
            if (anno != null) {
                PsiExpression qualifier;
                String target = anno.target();
                if (target.equals("This container (if the parameter was annotated) or the return value (if instance method was annotated)")) {
                    target = "The return value of this method";
                }
                if (target.equals("The return value of this method") && (qualifier = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression()) != null) {
                    int nesting = SliceUtil.calcNewIndexNesting(indexNesting, anno);
                    String source = anno.source();
                    if (source.equals("The method argument (if parameter was annotated) or this container (if instance method was annotated)")) {
                        source = "this";
                    }
                    String synthetic = StringUtil.trimStart((String)StringUtil.trimStart((String)source, (String)"this"), (String)".");
                    return SliceUtil.processUsagesFlownDownTo((PsiElement)qualifier, processor, parent, parentSubstitutor, nesting, synthetic);
                }
            }
            return SliceUtil.processMethodReturnValue((PsiMethodCallExpression)expression, processor, parent, parentSubstitutor);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            PsiExpression thenE = conditional.getThenExpression();
            PsiExpression elseE = conditional.getElseExpression();
            if (thenE != null && !SliceUtil.handToProcessor((PsiElement)thenE, processor, parent, parentSubstitutor, indexNesting, syntheticField)) {
                return false;
            }
            if (elseE != null && !SliceUtil.handToProcessor((PsiElement)elseE, processor, parent, parentSubstitutor, indexNesting, syntheticField)) {
                return false;
            }
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignment.getOperationTokenType();
            PsiExpression rExpression = assignment.getRExpression();
            if (tokenType == JavaTokenType.EQ && rExpression != null) {
                return SliceUtil.processUsagesFlownDownTo((PsiElement)rExpression, processor, parent, parentSubstitutor, indexNesting, syntheticField);
            }
        }
        if (indexNesting != 0) {
            PsiElement initializer;
            Object object = initializer = expression instanceof PsiNewExpression ? ((PsiNewExpression)expression).getArrayInitializer() : expression;
            if (initializer instanceof PsiArrayInitializerExpression) {
                for (PsiExpression init : ((PsiArrayInitializerExpression)initializer).getInitializers()) {
                    if (SliceUtil.handToProcessor((PsiElement)init, processor, parent, parentSubstitutor, indexNesting - 1, syntheticField)) continue;
                    return false;
                }
            }
            if (expression instanceof PsiNewExpression && !SliceUtil.processContainerPutArguments((PsiCallExpression)((PsiNewExpression)expression), processor, parent, parentSubstitutor, indexNesting, syntheticField)) {
                return false;
            }
        }
        return true;
    }

    private static Flow isMethodFlowAnnotated(PsiMethod method) {
        if (method == null) {
            return null;
        }
        return (Flow)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Flow.class);
    }

    private static Flow isParamFlowAnnotated(PsiMethod method, int paramIndex) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length <= paramIndex) {
            if (parameters.length != 0 && parameters[parameters.length - 1].isVarArgs()) {
                paramIndex = parameters.length - 1;
            } else {
                return null;
            }
        }
        return (Flow)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)parameters[paramIndex], Flow.class);
    }

    private static PsiElement simplify(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/slicer/SliceUtil", "simplify"));
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return SliceUtil.simplify((PsiElement)((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiTypeCastExpression) {
            return SliceUtil.simplify((PsiElement)((PsiTypeCastExpression)expression).getOperand());
        }
        return expression;
    }

    private static boolean handToProcessor(@NotNull PsiElement expression, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor, int indexNesting, @NotNull String syntheticField) {
        SliceUsage usage;
        PsiElement realExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/slicer/SliceUtil", "handToProcessor"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUtil", "handToProcessor"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "handToProcessor"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/slicer/SliceUtil", "handToProcessor"));
        }
        if (syntheticField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticField", "com/intellij/slicer/SliceUtil", "handToProcessor"));
        }
        PsiElement psiElement = realExpression = expression.getParent() instanceof DummyHolder ? expression.getParent().getContext() : expression;
        assert (realExpression != null);
        return realExpression instanceof PsiCompiledElement || processor.process((Object)(usage = SliceUtil.createSliceUsage(realExpression, parent, substitutor, indexNesting, syntheticField)));
    }

    private static boolean processMethodReturnValue(@NotNull PsiMethodCallExpression methodCallExpr, final @NotNull Processor<SliceUsage> processor, final @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor) {
        if (methodCallExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpr", "com/intellij/slicer/SliceUtil", "processMethodReturnValue"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUtil", "processMethodReturnValue"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "processMethodReturnValue"));
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSubstitutor", "com/intellij/slicer/SliceUtil", "processMethodReturnValue"));
        }
        JavaResolveResult resolved = methodCallExpr.resolveMethodGenerics();
        PsiElement r = resolved.getElement();
        if (r instanceof PsiCompiledElement) {
            r = r.getNavigationElement();
        }
        if (!(r instanceof PsiMethod)) {
            return true;
        }
        PsiMethod methodCalled = (PsiMethod)r;
        PsiType returnType = methodCalled.getReturnType();
        if (returnType == null) {
            return true;
        }
        final PsiType parentType = parentSubstitutor.substitute(methodCallExpr.getType());
        final PsiSubstitutor substitutor = resolved.getSubstitutor().putAll(parentSubstitutor);
        THashSet overrides = new THashSet(OverridingMethodsSearch.search((PsiMethod)methodCalled, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).findAll());
        overrides.add(methodCalled);
        final boolean[] result = new boolean[]{true};
        for (PsiMethod override : overrides) {
            PsiCodeBlock body;
            if (!result[0]) break;
            if (override instanceof PsiCompiledElement) {
                override = (PsiMethod)override.getNavigationElement();
            }
            if (!parent.getScope().contains((PsiElement)override) || (body = override.getBody()) == null) continue;
            PsiSubstitutor s = methodCalled == override ? substitutor : MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodCalled.getSignature(substitutor), (MethodSignature)override.getSignature(substitutor));
            final PsiSubstitutor superSubstitutor = s == null ? parentSubstitutor : s;
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitClass(PsiClass aClass) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                }

                public void visitReturnStatement(PsiReturnStatement statement) {
                    PsiExpression returnValue = statement.getReturnValue();
                    if (returnValue == null) {
                        return;
                    }
                    PsiType right = superSubstitutor.substitute(superSubstitutor.substitute(returnValue.getType()));
                    if (right == null || !TypeConversionUtil.isAssignable((PsiType)parentType, (PsiType)right)) {
                        return;
                    }
                    if (!SliceUtil.handToProcessor((PsiElement)returnValue, (Processor<SliceUsage>)processor, parent, substitutor, parent.indexNesting, "")) {
                        this.stopWalking();
                        result[0] = false;
                    }
                }
            });
        }
        return result[0];
    }

    private static boolean processFieldUsages(final @NotNull PsiField field, final @NotNull SliceUsage parent, final @NotNull PsiSubstitutor parentSubstitutor, final @NotNull Processor<SliceUsage> processor) {
        PsiExpression initializer;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/slicer/SliceUtil", "processFieldUsages"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "processFieldUsages"));
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSubstitutor", "com/intellij/slicer/SliceUtil", "processFieldUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUtil", "processFieldUsages"));
        }
        if (field.hasInitializer() && (initializer = field.getInitializer()) != null && !(field instanceof PsiCompiledElement) && !SliceUtil.handToProcessor((PsiElement)initializer, processor, parent, parentSubstitutor, parent.indexNesting, "")) {
            return false;
        }
        SearchScope searchScope = parent.getScope().toSearchScope();
        return ReferencesSearch.search((PsiElement)field, (SearchScope)searchScope).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                ProgressManager.checkCanceled();
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiReferenceExpression)) {
                    return true;
                }
                if (element instanceof PsiCompiledElement) {
                    element = element.getNavigationElement();
                    if (!parent.getScope().contains(element)) {
                        return true;
                    }
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement parentExpr = referenceExpression.getParent();
                if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)referenceExpression)) {
                    PsiExpression rExpression = ((PsiAssignmentExpression)parentExpr).getRExpression();
                    PsiType rtype = rExpression.getType();
                    PsiType ftype = field.getType();
                    if (TypeConversionUtil.isAssignable((PsiType)parentSubstitutor.substitute(ftype), (PsiType)parentSubstitutor.substitute(rtype))) {
                        return SliceUtil.handToProcessor((PsiElement)rExpression, (Processor<SliceUsage>)processor, parent, parentSubstitutor, parent.indexNesting, "");
                    }
                }
                if (parentExpr instanceof PsiPrefixExpression && ((PsiPrefixExpression)parentExpr).getOperand() == referenceExpression && (((PsiPrefixExpression)parentExpr).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiPrefixExpression)parentExpr).getOperationTokenType() == JavaTokenType.MINUSMINUS)) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parentExpr;
                    return SliceUtil.handToProcessor((PsiElement)prefixExpression, (Processor<SliceUsage>)processor, parent, parentSubstitutor, parent.indexNesting, "");
                }
                if (parentExpr instanceof PsiPostfixExpression && ((PsiPostfixExpression)parentExpr).getOperand() == referenceExpression && (((PsiPostfixExpression)parentExpr).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiPostfixExpression)parentExpr).getOperationTokenType() == JavaTokenType.MINUSMINUS)) {
                    PsiPostfixExpression postfixExpression = (PsiPostfixExpression)parentExpr;
                    return SliceUtil.handToProcessor((PsiElement)postfixExpression, (Processor<SliceUsage>)processor, parent, parentSubstitutor, parent.indexNesting, "");
                }
                return true;
            }
        });
    }

    @NotNull
    static SliceUsage createSliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor, int indexNesting, @NotNull String syntheticField) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceUtil", "createSliceUsage"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "createSliceUsage"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/slicer/SliceUtil", "createSliceUsage"));
        }
        if (syntheticField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticField", "com/intellij/slicer/SliceUtil", "createSliceUsage"));
        }
        SliceUsage sliceUsage = new SliceUsage(SliceUtil.simplify(element), parent, substitutor, indexNesting, syntheticField);
        if (sliceUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUtil", "createSliceUsage"));
        }
        return sliceUsage;
    }

    @NotNull
    private static SliceUsage createTooComplexDFAUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceUtil", "createTooComplexDFAUsage"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "createTooComplexDFAUsage"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/slicer/SliceUtil", "createTooComplexDFAUsage"));
        }
        SliceTooComplexDFAUsage sliceTooComplexDFAUsage = new SliceTooComplexDFAUsage(SliceUtil.simplify(element), parent, substitutor);
        if (sliceTooComplexDFAUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUtil", "createTooComplexDFAUsage"));
        }
        return sliceTooComplexDFAUsage;
    }

    private static boolean processParameterUsages(@NotNull PsiParameter parameter, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField, @NotNull Processor<SliceUsage> processor) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/slicer/SliceUtil", "processParameterUsages"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "processParameterUsages"));
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSubstitutor", "com/intellij/slicer/SliceUtil", "processParameterUsages"));
        }
        if (syntheticField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticField", "com/intellij/slicer/SliceUtil", "processParameterUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUtil", "processParameterUsages"));
        }
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (declarationScope instanceof PsiForeachStatement) {
            PsiForeachStatement statement = (PsiForeachStatement)declarationScope;
            PsiExpression iterated = statement.getIteratedValue();
            return statement.getIterationParameter() != parameter || iterated == null || SliceUtil.handToProcessor((PsiElement)iterated, processor, parent, parentSubstitutor, indexNesting + 1, syntheticField);
        }
        if (!(declarationScope instanceof PsiMethod)) {
            return true;
        }
        PsiMethod method = (PsiMethod)declarationScope;
        PsiType actualParameterType = parameter.getType();
        Object[] actualParameters = method.getParameterList().getParameters();
        int paramSeqNo = ArrayUtilRt.find((Object[])actualParameters, (Object)parameter);
        assert (paramSeqNo != -1);
        THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
        superMethods.add(method);
        THashSet processed = new THashSet();
        for (PsiMethod superMethod : superMethods) {
            if (MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach((Processor)new Processor<PsiReference>((Set)processed, paramSeqNo, actualParameterType, (PsiParameter[])actualParameters, parentSubstitutor, processor, parent, indexNesting, syntheticField){
                final /* synthetic */ Set val$processed;
                final /* synthetic */ int val$paramSeqNo;
                final /* synthetic */ PsiType val$actualParameterType;
                final /* synthetic */ PsiParameter[] val$actualParameters;
                final /* synthetic */ PsiSubstitutor val$parentSubstitutor;
                final /* synthetic */ Processor val$processor;
                final /* synthetic */ SliceUsage val$parent;
                final /* synthetic */ int val$indexNesting;
                final /* synthetic */ String val$syntheticField;
                {
                    this.val$processed = set;
                    this.val$paramSeqNo = n;
                    this.val$actualParameterType = psiType;
                    this.val$actualParameters = psiParameterArray;
                    this.val$parentSubstitutor = psiSubstitutor;
                    this.val$processor = processor;
                    this.val$parent = sliceUsage;
                    this.val$indexNesting = n2;
                    this.val$syntheticField = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean process(PsiReference reference) {
                    PsiType typeToCheck;
                    PsiSubstitutor combined;
                    PsiType actualExpressionType;
                    PsiExpressionList passExpression;
                    JavaResolveResult result;
                    PsiExpressionList argumentList;
                    ProgressManager.checkCanceled();
                    Set set = this.val$processed;
                    synchronized (set) {
                        if (!this.val$processed.add(reference)) {
                            return true;
                        }
                    }
                    PsiElement refElement = reference.getElement();
                    if (refElement instanceof PsiCall) {
                        PsiCall call = (PsiCall)refElement;
                        argumentList = call.getArgumentList();
                        result = call.resolveMethodGenerics();
                    } else {
                        PsiElement element = refElement.getParent();
                        if (element instanceof PsiCompiledElement) {
                            return true;
                        }
                        if (element instanceof PsiAnonymousClass) {
                            PsiAnonymousClass anon = (PsiAnonymousClass)element;
                            argumentList = anon.getArgumentList();
                            PsiElement callExp = element.getParent();
                            if (!(callExp instanceof PsiCallExpression)) {
                                return true;
                            }
                            result = ((PsiCall)callExp).resolveMethodGenerics();
                        } else {
                            if (!(element instanceof PsiCall)) {
                                return true;
                            }
                            PsiCall call = (PsiCall)element;
                            argumentList = call.getArgumentList();
                            result = call.resolveMethodGenerics();
                        }
                    }
                    PsiSubstitutor substitutor = result.getSubstitutor();
                    PsiExpression[] expressions = argumentList.getExpressions();
                    if (this.val$paramSeqNo >= expressions.length) {
                        return true;
                    }
                    if (this.val$actualParameterType instanceof PsiEllipsisType) {
                        passExpression = argumentList;
                        actualExpressionType = expressions[this.val$paramSeqNo].getType();
                    } else {
                        passExpression = expressions[this.val$paramSeqNo];
                        actualExpressionType = ((PsiExpression)passExpression).getType();
                    }
                    Project project = argumentList.getProject();
                    PsiElement element = result.getElement();
                    if (element instanceof PsiCompiledElement) {
                        element = element.getNavigationElement();
                    }
                    if (element instanceof PsiTypeParameterListOwner && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)element), (PsiSubstitutor)substitutor)) {
                        PsiTypeParameter[] typeParameters = substitutor.getSubstitutionMap().keySet().toArray(new PsiTypeParameter[0]);
                        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
                        substitutor = resolveHelper.inferTypeArguments(typeParameters, this.val$actualParameters, expressions, this.val$parentSubstitutor, (PsiElement)argumentList, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                    }
                    if ((combined = SliceUtil.unify(substitutor = SliceUtil.removeRawMappingsLeftFromResolve(substitutor), this.val$parentSubstitutor, project)) == null) {
                        return true;
                    }
                    PsiType substituted = combined.substitute(actualExpressionType);
                    if (substituted instanceof PsiPrimitiveType) {
                        PsiClassType boxedType = ((PsiPrimitiveType)substituted).getBoxedType((PsiElement)argumentList);
                        Object object = substituted = boxedType != null ? boxedType : substituted;
                    }
                    if (substituted == null) {
                        return true;
                    }
                    if (this.val$actualParameterType instanceof PsiEllipsisType) {
                        if (TypeConversionUtil.areTypesConvertible((PsiType)substituted, (PsiType)this.val$actualParameterType)) {
                            return SliceUtil.handToProcessor((PsiElement)expressions[this.val$paramSeqNo], (Processor<SliceUsage>)this.val$processor, this.val$parent, combined, this.val$indexNesting, this.val$syntheticField);
                        }
                        typeToCheck = ((PsiEllipsisType)this.val$actualParameterType).getComponentType();
                    } else {
                        typeToCheck = this.val$actualParameterType;
                    }
                    if (!TypeConversionUtil.areTypesConvertible((PsiType)substituted, (PsiType)typeToCheck)) {
                        return true;
                    }
                    return SliceUtil.handToProcessor((PsiElement)passExpression, (Processor<SliceUsage>)this.val$processor, this.val$parent, combined, this.val$indexNesting, this.val$syntheticField);
                }
            })) continue;
            return false;
        }
        return true;
    }

    private static void addContainerReferences(@NotNull PsiVariable variable, final @NotNull Processor<SliceUsage> processor, final @NotNull SliceUsage parent, final @NotNull PsiSubstitutor parentSubstitutor, final int indexNesting, final @NotNull String syntheticField) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/slicer/SliceUtil", "addContainerReferences"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUtil", "addContainerReferences"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "addContainerReferences"));
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSubstitutor", "com/intellij/slicer/SliceUtil", "addContainerReferences"));
        }
        if (syntheticField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticField", "com/intellij/slicer/SliceUtil", "addContainerReferences"));
        }
        if (indexNesting != 0) {
            ReferencesSearch.search((PsiElement)variable).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiExpression expression;
                    PsiElement element = reference.getElement();
                    return !(element instanceof PsiExpression) || element.getManager().areElementsEquivalent(element, parent.getElement()) || SliceUtil.addContainerItemModification(expression = (PsiExpression)element, (Processor<SliceUsage>)processor, parent, parentSubstitutor, indexNesting, syntheticField);
                }
            });
        }
    }

    private static boolean addContainerItemModification(@NotNull PsiExpression expression, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField) {
        PsiElement grand;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/slicer/SliceUtil", "addContainerItemModification"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUtil", "addContainerItemModification"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUtil", "addContainerItemModification"));
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSubstitutor", "com/intellij/slicer/SliceUtil", "addContainerItemModification"));
        }
        if (syntheticField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticField", "com/intellij/slicer/SliceUtil", "addContainerItemModification"));
        }
        PsiElement parentElement = expression.getParent();
        if (parentElement instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)parentElement).getArrayExpression() == expression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)parentElement)) && PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)parentElement))) {
            PsiExpression rightSide = ((PsiAssignmentExpression)parentElement.getParent()).getRExpression();
            return rightSide == null || SliceUtil.handToProcessor((PsiElement)rightSide, processor, parent, parentSubstitutor, indexNesting - 1, syntheticField);
        }
        PsiElement psiElement = grand = parentElement == null ? null : parentElement.getParent();
        return !(grand instanceof PsiCallExpression) || SliceUtil.processContainerPutArguments((PsiCallExpression)grand, processor, parent, parentSubstitutor, indexNesting, syntheticField);
    }

    private static boolean processContainerPutArguments(PsiCallExpression call, Processor<SliceUsage> processor, SliceUsage parent, PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField) {
        if (syntheticField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticField", "com/intellij/slicer/SliceUtil", "processContainerPutArguments"));
        }
        assert (indexNesting != 0);
        JavaResolveResult result = call.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        if (method != null) {
            int parametersCount = method.getParameterList().getParametersCount();
            Flow[] annotations = new Flow[parametersCount];
            for (int i = 0; i < parametersCount; ++i) {
                annotations[i] = SliceUtil.isParamFlowAnnotated(method, i);
            }
            PsiExpression[] expressions = call.getArgumentList().getExpressions();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            for (int i = 0; i < expressions.length; ++i) {
                PsiParameter parameter;
                Flow anno;
                PsiExpression argument = expressions[i];
                if (i >= parameters.length) {
                    if (parameters.length == 0 || !parameters[parameters.length - 1].isVarArgs()) break;
                    anno = annotations[parameters.length - 1];
                    parameter = parameters[parameters.length - 1];
                } else {
                    anno = annotations[i];
                    parameter = parameters[i];
                }
                if (anno != null) {
                    int nesting;
                    PsiSubstitutor substitutor;
                    String paramSynthetic;
                    String target = anno.target();
                    if (target.equals("This container (if the parameter was annotated) or the return value (if instance method was annotated)")) {
                        target = "this";
                    }
                    if (target.startsWith("this") && (paramSynthetic = StringUtil.trimStart((String)StringUtil.trimStart((String)target, (String)"this"), (String)".")).equals(syntheticField) && !SliceUtil.handToProcessor((PsiElement)argument, processor, parent, substitutor = SliceUtil.unify(result.getSubstitutor(), parentSubstitutor, argument.getProject()), nesting = SliceUtil.calcNewIndexNesting(indexNesting, anno), paramSynthetic)) {
                        return false;
                    }
                }
                for (int si = 0; si < annotations.length; ++si) {
                    Flow sourceAnno;
                    if (si == i || (sourceAnno = annotations[si]) == null || !sourceAnno.target().equals(parameter.getName())) continue;
                    int newNesting = SliceUtil.calcNewIndexNesting(indexNesting, sourceAnno);
                    PsiExpression sourceArgument = expressions[si];
                    PsiSubstitutor substitutor = SliceUtil.unify(result.getSubstitutor(), parentSubstitutor, argument.getProject());
                    if (SliceUtil.handToProcessor((PsiElement)sourceArgument, processor, parent, substitutor, newNesting, syntheticField)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int calcNewIndexNesting(int indexNesting, Flow anno) {
        int nestingDelta = (anno.sourceIsContainer() ? 1 : 0) - (anno.targetIsContainer() ? 1 : 0);
        return indexNesting + nestingDelta;
    }

    @NotNull
    private static PsiSubstitutor removeRawMappingsLeftFromResolve(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/slicer/SliceUtil", "removeRawMappingsLeftFromResolve"));
        }
        Map map = null;
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            if (entry.getValue() != null) continue;
            if (map == null) {
                map = new THashMap();
            }
            map.put(entry.getKey(), entry.getValue());
        }
        if (map == null) {
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUtil", "removeRawMappingsLeftFromResolve"));
            }
            return psiSubstitutor;
        }
        THashMap newMap = new THashMap(substitutor.getSubstitutionMap());
        newMap.keySet().removeAll(map.keySet());
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)newMap);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUtil", "removeRawMappingsLeftFromResolve"));
        }
        return psiSubstitutor;
    }

    @Nullable
    private static PsiSubstitutor unify(@NotNull PsiSubstitutor substitutor, @NotNull PsiSubstitutor parentSubstitutor, @NotNull Project project) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/slicer/SliceUtil", "unify"));
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSubstitutor", "com/intellij/slicer/SliceUtil", "unify"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SliceUtil", "unify"));
        }
        THashMap newMap = new THashMap(substitutor.getSubstitutionMap());
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)entry.getKey();
            PsiType type = (PsiType)entry.getValue();
            PsiClass resolved = PsiUtil.resolveClassInType((PsiType)type);
            if (!parentSubstitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            PsiType parentType = parentSubstitutor.substitute(parentSubstitutor.substitute(typeParameter));
            if (resolved instanceof PsiTypeParameter) {
                PsiTypeParameter res = (PsiTypeParameter)resolved;
                newMap.put(res, parentType);
                continue;
            }
            if (Comparing.equal((Object)type, (Object)parentType)) continue;
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)project).createSubstitutor((Map)newMap);
    }
}

