/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import javax.swing.KeyStroke;

public class KeyStrokeAdapter
implements KeyListener {
    @Override
    public void keyTyped(KeyEvent event) {
        this.keyTyped(event, KeyStrokeAdapter.getKeyStroke(event, false));
    }

    protected boolean keyTyped(KeyStroke stroke) {
        return false;
    }

    private void keyTyped(KeyEvent event, KeyStroke stroke) {
        if (stroke != null && this.keyTyped(stroke)) {
            event.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.keyPressed(event, KeyStrokeAdapter.getKeyStroke(event, true));
        this.keyPressed(event, KeyStrokeAdapter.getKeyStroke(event, false));
    }

    protected boolean keyPressed(KeyStroke stroke) {
        return false;
    }

    private void keyPressed(KeyEvent event, KeyStroke stroke) {
        if (stroke != null && this.keyPressed(stroke)) {
            event.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.keyReleased(event, KeyStrokeAdapter.getKeyStroke(event, true));
        this.keyReleased(event, KeyStrokeAdapter.getKeyStroke(event, false));
    }

    protected boolean keyReleased(KeyStroke stroke) {
        return false;
    }

    private void keyReleased(KeyEvent event, KeyStroke stroke) {
        if (stroke != null && this.keyReleased(stroke)) {
            event.consume();
        }
    }

    public static KeyStroke getDefaultKeyStroke(KeyEvent event) {
        if (event == null || event.isConsumed()) {
            return null;
        }
        boolean extendedKeyCodeFirst = !SystemInfo.isWindows && !SystemInfo.isMac && event.getModifiers() == 0;
        KeyStroke stroke = KeyStrokeAdapter.getKeyStroke(event, extendedKeyCodeFirst);
        return stroke != null ? stroke : KeyStrokeAdapter.getKeyStroke(event, !extendedKeyCodeFirst);
    }

    public static KeyStroke getKeyStroke(KeyEvent event, boolean extended) {
        if (event != null && !event.isConsumed()) {
            boolean released;
            int id = event.getID();
            if (id == 400) {
                return extended ? null : KeyStrokeAdapter.getKeyStroke(event.getKeyChar());
            }
            boolean bl = released = id == 402;
            if (released || id == 401) {
                int code = event.getKeyCode();
                if (extended) {
                    if (Registry.is((String)"actionSystem.extendedKeyCode.disabled")) {
                        return null;
                    }
                    code = KeyStrokeAdapter.getExtendedKeyCode(event);
                    if (code == event.getKeyCode()) {
                        return null;
                    }
                }
                return KeyStrokeAdapter.getKeyStroke(code, event.getModifiers(), released);
            }
        }
        return null;
    }

    private static KeyStroke getKeyStroke(char ch) {
        return '\uffff' == ch ? null : KeyStroke.getKeyStroke(ch);
    }

    private static KeyStroke getKeyStroke(int code, int modifiers, boolean released) {
        return 0 == code ? null : KeyStroke.getKeyStroke(code, modifiers, released);
    }

    private static int getExtendedKeyCode(KeyEvent event) {
        try {
            Method method = KeyEvent.class.getMethod("getExtendedKeyCode", new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (Integer)method.invoke((Object)event, new Object[0]);
        }
        catch (Exception exception) {
            return event.getKeyCode();
        }
    }
}

