/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import com.intellij.util.io.socketConnection.AbstractResponseToRequestHandler;
import com.intellij.util.io.socketConnection.ResponseReader;
import com.intellij.util.io.socketConnection.ResponseToRequest;
import com.intellij.util.io.socketConnection.SocketConnection;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ResponseProcessor<R extends AbstractResponse> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.socketConnection.impl.ResponseProcessor");
    private final TIntObjectHashMap<AbstractResponseToRequestHandler<?>> myHandlers = new TIntObjectHashMap();
    private final MultiValuesMap<Class<? extends R>, AbstractResponseHandler<? extends R>> myClassHandlers = new MultiValuesMap();
    private final TIntObjectHashMap<TimeoutHandler> myTimeoutHandlers = new TIntObjectHashMap();
    private boolean myStopped;
    private final Object myLock = new Object();
    private Thread myThread;
    private final Alarm myTimeoutAlarm;

    public ResponseProcessor(SocketConnection<?, R> connection) {
        this.myTimeoutAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, connection);
    }

    public void startReading(final ResponseReader<R> reader) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ResponseProcessor.this.myThread = Thread.currentThread();
                try {
                    Object r2;
                    while ((r2 = reader.readResponse()) != null) {
                        if (r2 instanceof ResponseToRequest) {
                            int requestId = ((ResponseToRequest)r2).getRequestId();
                            ResponseProcessor.this.processResponse(requestId, r2);
                            continue;
                        }
                        ResponseProcessor.this.processResponse(r2);
                    }
                }
                catch (InterruptedException r2) {
                    Object r2 = ResponseProcessor.this.myLock;
                    synchronized (r2) {
                        ResponseProcessor.this.myStopped = true;
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
                finally {
                    Object object = ResponseProcessor.this.myLock;
                    synchronized (object) {
                        ResponseProcessor.this.myStopped = true;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(int requestId, R response) {
        AbstractResponseToRequestHandler handler;
        Object object = this.myLock;
        synchronized (object) {
            this.myTimeoutHandlers.remove(requestId);
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            handler = (AbstractResponseToRequestHandler)this.myHandlers.remove(requestId);
            if (handler == null) {
                return;
            }
        }
        if (!handler.processResponse(response)) {
            object2 = this.myLock;
            synchronized (object2) {
                this.myHandlers.put(requestId, (Object)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(R response) throws IOException {
        SmartList handlers;
        Class<?> responseClass = response.getClass();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            Collection responseHandlers = this.myClassHandlers.get(responseClass);
            if (responseHandlers == null) {
                return;
            }
            handlers = new SmartList(responseHandlers);
        }
        for (AbstractResponseHandler handler : handlers) {
            handler.processResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReading() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStopped) {
                return;
            }
            this.myStopped = true;
        }
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends R> void registerHandler(@NotNull Class<T> responseClass, @NotNull AbstractResponseHandler<T> handler) {
        if (responseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "responseClass", "com/intellij/util/io/socketConnection/impl/ResponseProcessor", "registerHandler"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/util/io/socketConnection/impl/ResponseProcessor", "registerHandler"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myClassHandlers.put(responseClass, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(int id, @NotNull AbstractResponseToRequestHandler<?> handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/util/io/socketConnection/impl/ResponseProcessor", "registerHandler"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myHandlers.put(id, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout() {
        LOG.debug("Checking timeout");
        final ArrayList timedOut = new ArrayList();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            final long time = System.currentTimeMillis();
            this.myTimeoutHandlers.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<TimeoutHandler>(){

                public boolean execute(int a, TimeoutHandler b) {
                    if (time > b.myLastTime) {
                        timedOut.add(b);
                        return false;
                    }
                    return true;
                }
            });
        }
        for (TimeoutHandler handler : timedOut) {
            LOG.debug("performing timeout action: " + handler.myAction);
            handler.myAction.run();
        }
        this.scheduleTimeoutCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimeoutCheck() {
        final Ref nextTime = Ref.create((Object)Long.MAX_VALUE);
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTimeoutHandlers.isEmpty()) {
                return;
            }
            this.myTimeoutHandlers.forEachValue((TObjectProcedure)new TObjectProcedure<TimeoutHandler>(){

                public boolean execute(TimeoutHandler handler) {
                    nextTime.set((Object)Math.min((Long)nextTime.get(), handler.myLastTime));
                    return true;
                }
            });
        }
        int delay = (int)((Long)nextTime.get() - System.currentTimeMillis() + 100L);
        LOG.debug("schedule timeout check in " + delay + "ms");
        if (delay > 10) {
            this.myTimeoutAlarm.cancelAllRequests();
            this.myTimeoutAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ResponseProcessor.this.checkTimeout();
                }
            }, delay);
        } else {
            this.checkTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimeoutHandler(int commandId, int timeout, Runnable onTimeout) {
        Object object = this.myLock;
        synchronized (object) {
            this.myTimeoutHandlers.put(commandId, (Object)new TimeoutHandler(onTimeout, System.currentTimeMillis() + (long)timeout));
        }
        this.scheduleTimeoutCheck();
    }

    private static class TimeoutHandler {
        private final Runnable myAction;
        private final long myLastTime;

        private TimeoutHandler(Runnable action, long lastTime) {
            this.myAction = action;
            this.myLastTime = lastTime;
        }
    }
}

