/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.NotNullFunction;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.ColorGetterByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.GraphElementComparatorByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrintElementManagerImpl
implements PrintElementManager {
    @NotNull
    private final Comparator<GraphElement> myGraphElementComparator;
    @NotNull
    private final ColorGetterByLayoutIndex myColorGetter;
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private Set<Integer> mySelectedNodeIds;
    @Nullable
    private PrintElementWithGraphElement mySelectedPrintElement;

    PrintElementManagerImpl(final @NotNull LinearGraph linearGraph, final @NotNull PermanentGraphInfo myPermanentGraph) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl", "<init>"));
        }
        if (myPermanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myPermanentGraph", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl", "<init>"));
        }
        this.mySelectedNodeIds = Collections.emptySet();
        this.mySelectedPrintElement = null;
        this.myLinearGraph = linearGraph;
        this.myColorGetter = new ColorGetterByLayoutIndex(linearGraph, myPermanentGraph);
        this.myGraphElementComparator = new GraphElementComparatorByLayoutIndex(new NotNullFunction<Integer, Integer>(){

            @NotNull
            public Integer fun(Integer nodeIndex) {
                int nodeId = linearGraph.getNodeId(nodeIndex);
                if (nodeId < 0) {
                    Integer n = nodeId;
                    if (n == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl$1", "fun"));
                    }
                    return n;
                }
                Integer n = myPermanentGraph.getPermanentGraphLayout().getLayoutIndex(nodeId);
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl$1", "fun"));
                }
                return n;
            }
        });
    }

    @Override
    public boolean isSelected(@NotNull PrintElementWithGraphElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl", "isSelected"));
        }
        if (printElement.equals(this.mySelectedPrintElement)) {
            return true;
        }
        GraphElement graphElement = printElement.getGraphElement();
        if (graphElement instanceof GraphNode) {
            int nodeId = this.myLinearGraph.getNodeId(((GraphNode)graphElement).getNodeIndex());
            return this.mySelectedNodeIds.contains(nodeId);
        }
        if (graphElement instanceof GraphEdge) {
            GraphEdge edge = (GraphEdge)graphElement;
            boolean selected = edge.getTargetId() == null || this.mySelectedNodeIds.contains(edge.getTargetId());
            selected &= edge.getUpNodeIndex() == null || this.mySelectedNodeIds.contains(this.myLinearGraph.getNodeId(edge.getUpNodeIndex()));
            return selected &= edge.getDownNodeIndex() == null || this.mySelectedNodeIds.contains(this.myLinearGraph.getNodeId(edge.getDownNodeIndex()));
        }
        return false;
    }

    void setSelectedElement(@NotNull PrintElementWithGraphElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl", "setSelectedElement"));
        }
        this.mySelectedNodeIds = Collections.emptySet();
        this.mySelectedPrintElement = printElement;
    }

    void setSelectedElements(@NotNull Set<Integer> selectedNodeId) {
        if (selectedNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNodeId", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl", "setSelectedElements"));
        }
        this.mySelectedPrintElement = null;
        this.mySelectedNodeIds = selectedNodeId;
    }

    @Override
    public int getColorId(@NotNull GraphElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl", "getColorId"));
        }
        return this.myColorGetter.getColorId(element);
    }

    @Override
    @NotNull
    public Comparator<GraphElement> getGraphElementComparator() {
        Comparator<GraphElement> comparator = this.myGraphElementComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl", "getGraphElementComparator"));
        }
        return comparator;
    }
}

