/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsUserImpl;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MyCommitsHighlighter
implements VcsLogHighlighter {
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogDataHolder myDataHolder;

    public MyCommitsHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        this.myDataHolder = logDataHolder;
        this.myUiProperties = uiProperties;
        if (!this.myUiProperties.isHighlightMyCommits()) {
            this.myUiProperties.enableHighlighter("MY_COMMITS", false);
            this.myUiProperties.setHighlightMyCommits(true);
        }
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitIndex, boolean isSelected) {
        VcsUser currentUser;
        if (!this.myUiProperties.isHighlighterEnabled("MY_COMMITS")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        Map<VirtualFile, VcsUser> users = this.myDataHolder.getCurrentUser();
        VcsShortCommitDetails details = this.myDataHolder.getMiniDetailsGetter().getCommitDataIfAvailable(commitIndex);
        if (details != null && !(details instanceof LoadingDetails) && (currentUser = users.get(details.getRoot())) != null && VcsUserImpl.isSamePerson(currentUser, details.getAuthor())) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.bold();
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "MY_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties) {
            if (logDataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            if (uiProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            MyCommitsHighlighter myCommitsHighlighter = new MyCommitsHighlighter(logDataHolder, uiProperties);
            if (myCommitsHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            return myCommitsHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "getId"));
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("My Commits" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "getTitle"));
            }
            return "My Commits";
        }
    }
}

