/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BreadcrumbsLoaderComponent
extends AbstractProjectComponent {
    public BreadcrumbsLoaderComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "<init>"));
        }
        super(project);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("HtmlBreadcrumbsComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent", "getComponentName"));
        }
        return "HtmlBreadcrumbsComponent";
    }

    public void initComponent() {
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
    }

    private static boolean isEnabled() {
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        return webEditorOptions.isBreadcrumbsEnabled() || webEditorOptions.isBreadcrumbsEnabledInXml();
    }

    private static class MyFileEditorManagerListener
    extends FileEditorManagerAdapter {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(final @NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent$MyFileEditorManagerListener", "fileOpened"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent$MyFileEditorManagerListener", "fileOpened"));
            }
            if (BreadcrumbsLoaderComponent.isEnabled() && MyFileEditorManagerListener.isSuitable(source.getProject(), file)) {
                FileEditor[] fileEditors;
                for (final FileEditor fileEditor : fileEditors = source.getAllEditors(file)) {
                    Editor editor;
                    if (!(fileEditor instanceof TextEditor) || BreadcrumbsXmlWrapper.getBreadcrumbsComponent(editor = ((TextEditor)fileEditor).getEditor()) != null) continue;
                    BreadcrumbsXmlWrapper wrapper = new BreadcrumbsXmlWrapper(editor);
                    final JComponent c = wrapper.getComponent();
                    source.addTopComponent(fileEditor, c);
                    Disposer.register((Disposable)fileEditor, (Disposable)wrapper);
                    Disposer.register((Disposable)fileEditor, (Disposable)new Disposable(){

                        public void dispose() {
                            source.removeTopComponent(fileEditor, c);
                        }
                    });
                }
            }
        }

        private static boolean isSuitable(Project project, VirtualFile file) {
            if (file instanceof HttpVirtualFile) {
                return false;
            }
            FileViewProvider provider = PsiManager.getInstance((Project)project).findViewProvider(file);
            return provider != null && BreadcrumbsXmlWrapper.findInfoProvider(provider) != null;
        }
    }
}

