/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.IncludedXmlAttribute;
import com.intellij.xml.util.IncludedXmlElement;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludedXmlTag
extends IncludedXmlElement<XmlTag>
implements XmlTag {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.IncludedXmlTag");

    public IncludedXmlTag(@NotNull XmlTag original, @Nullable PsiElement parent) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/xml/util/IncludedXmlTag", "<init>"));
        }
        super(original, parent);
    }

    @Nullable
    public XmlTag getParentTag() {
        return this.getParent() instanceof XmlTag ? (XmlTag)this.getParent() : null;
    }

    @Override
    @NotNull
    @NonNls
    public String getName() {
        String string = ((XmlTag)this.getOriginal()).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/xml/util/IncludedXmlTag", "setName"));
        }
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    @NotNull
    @NonNls
    public String getNamespace() {
        XmlTag original = (XmlTag)this.getOriginal();
        LOG.assertTrue(original.isValid());
        String string = original.getNamespace();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getNamespace"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getLocalName() {
        String string = ((XmlTag)this.getOriginal()).getLocalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getLocalName"));
        }
        return string;
    }

    @Nullable
    public XmlElementDescriptor getDescriptor() {
        return ((XmlTag)this.getOriginal()).getDescriptor();
    }

    @NotNull
    public XmlAttribute[] getAttributes() {
        XmlAttribute[] original = ((XmlTag)this.getOriginal()).getAttributes();
        XmlAttribute[] attributes = new XmlAttribute[original.length];
        for (int i = 0; i < original.length; ++i) {
            XmlAttribute attribute = original[i];
            attributes[i] = new IncludedXmlAttribute(attribute, this);
        }
        if (attributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getAttributes"));
        }
        return attributes;
    }

    @Nullable
    public XmlAttribute getAttribute(@NonNls String name, @NonNls String namespace) {
        XmlAttribute attribute = ((XmlTag)this.getOriginal()).getAttribute(name, namespace);
        return attribute == null ? null : new IncludedXmlAttribute(attribute, this);
    }

    @Nullable
    public XmlAttribute getAttribute(@NonNls String qname) {
        XmlAttribute attribute = ((XmlTag)this.getOriginal()).getAttribute(qname);
        return attribute == null ? null : new IncludedXmlAttribute(attribute, this);
    }

    @Nullable
    public String getAttributeValue(@NonNls String name, @NonNls String namespace) {
        return ((XmlTag)this.getOriginal()).getAttributeValue(name, namespace);
    }

    @Nullable
    public String getAttributeValue(@NonNls String qname) {
        return ((XmlTag)this.getOriginal()).getAttributeValue(qname);
    }

    public XmlAttribute setAttribute(@NonNls String name, @NonNls String namespace, @NonNls String value) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    public XmlAttribute setAttribute(@NonNls String qname, @NonNls String value) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    public XmlTag createChildTag(@NonNls String localName, @NonNls String namespace, @Nullable @NonNls String bodyText, boolean enforceNamespacesDeep) {
        return ((XmlTag)this.getOriginal()).createChildTag(localName, namespace, bodyText, enforceNamespacesDeep);
    }

    public XmlTag addSubTag(XmlTag subTag, boolean first) {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    @NotNull
    public XmlTag[] getSubTags() {
        XmlTag[] xmlTagArray = this.wrapTags(((XmlTag)this.getOriginal()).getSubTags());
        if (xmlTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getSubTags"));
        }
        return xmlTagArray;
    }

    private XmlTag[] wrapTags(XmlTag[] original) {
        XmlTag[] result = new XmlTag[original.length];
        for (int i = 0; i < original.length; ++i) {
            result[i] = new IncludedXmlTag(original[i], (PsiElement)this);
        }
        return result;
    }

    @NotNull
    public XmlTag[] findSubTags(@NonNls String qname) {
        XmlTag[] xmlTagArray = this.wrapTags(((XmlTag)this.getOriginal()).findSubTags(qname));
        if (xmlTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "findSubTags"));
        }
        return xmlTagArray;
    }

    @NotNull
    public XmlTag[] findSubTags(@NonNls String localName, @NonNls String namespace) {
        XmlTag[] xmlTagArray = this.wrapTags(((XmlTag)this.getOriginal()).findSubTags(localName, namespace));
        if (xmlTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "findSubTags"));
        }
        return xmlTagArray;
    }

    @Nullable
    public XmlTag findFirstSubTag(@NonNls String qname) {
        XmlTag tag = ((XmlTag)this.getOriginal()).findFirstSubTag(qname);
        return tag == null ? null : new IncludedXmlTag(tag, (PsiElement)this);
    }

    @NotNull
    @NonNls
    public String getNamespacePrefix() {
        String string = ((XmlTag)this.getOriginal()).getNamespacePrefix();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getNamespacePrefix"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getNamespaceByPrefix(@NonNls String prefix) {
        String string = ((XmlTag)this.getOriginal()).getNamespaceByPrefix(prefix);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getNamespaceByPrefix"));
        }
        return string;
    }

    @Nullable
    public String getPrefixByNamespace(@NonNls String namespace) {
        return ((XmlTag)this.getOriginal()).getPrefixByNamespace(namespace);
    }

    public String[] knownNamespaces() {
        return ((XmlTag)this.getOriginal()).knownNamespaces();
    }

    public boolean hasNamespaceDeclarations() {
        return ((XmlTag)this.getOriginal()).hasNamespaceDeclarations();
    }

    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        Map map = ((XmlTag)this.getOriginal()).getLocalNamespaceDeclarations();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getLocalNamespaceDeclarations"));
        }
        return map;
    }

    @NotNull
    public XmlTagValue getValue() {
        XmlTagValue xmlTagValue = XmlTagValueImpl.createXmlTagValue(this);
        if (xmlTagValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlTag", "getValue"));
        }
        return xmlTagValue;
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(@NonNls String namespace, boolean strict) {
        return ((XmlTag)this.getOriginal()).getNSDescriptor(namespace, strict);
    }

    public boolean isEmpty() {
        return ((XmlTag)this.getOriginal()).isEmpty();
    }

    public void collapseIfEmpty() {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    @Nullable
    @NonNls
    public String getSubTagText(@NonNls String qname) {
        return ((XmlTag)this.getOriginal()).getSubTagText(qname);
    }

    public PsiMetaData getMetaData() {
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        return null;
    }
}

