/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.MessageProcessor;
import org.jetbrains.rpc.MessageWriter;

public class StandaloneVmHelper
extends MessageWriter
implements Vm.AttachStateManager {
    private volatile Channel channel;
    private final VmEx vm;

    public StandaloneVmHelper(@NotNull VmEx vm) {
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/StandaloneVmHelper", "<init>"));
        }
        this.vm = vm;
    }

    @Override
    public boolean write(@NotNull ByteBuf content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/debugger/StandaloneVmHelper", "write"));
        }
        return this.write((Object)content);
    }

    @Nullable
    public Channel getChannelIfActive() {
        Channel currentChannel = this.channel;
        return currentChannel == null || !currentChannel.isActive() ? null : currentChannel;
    }

    public boolean write(@NotNull Object content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/debugger/StandaloneVmHelper", "write"));
        }
        Channel channel = this.getChannelIfActive();
        return channel != null && !channel.writeAndFlush(content).isCancelled();
    }

    public void setChannel(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/debugger/StandaloneVmHelper", "setChannel"));
        }
        this.channel = channel;
        channel.closeFuture().addListener((GenericFutureListener)new MyChannelFutureListener());
    }

    @Override
    public boolean isAttached() {
        return this.channel != null;
    }

    @Override
    @NotNull
    public Promise<Void> detach() {
        final Channel currentChannel = this.channel;
        if (currentChannel == null) {
            Promise promise = Promise.DONE;
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/StandaloneVmHelper", "detach"));
            }
            return promise;
        }
        this.vm.getCommandProcessor().cancelWaitingRequests();
        Request disconnectRequest = this.vm.createDisconnectRequest();
        final AsyncPromise promise = new AsyncPromise();
        if (disconnectRequest == null) {
            this.vm.getCommandProcessor().closed();
            this.channel = null;
            this.closeChannel(currentChannel, (AsyncPromise<Void>)promise);
            AsyncPromise asyncPromise = promise;
            if (asyncPromise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/StandaloneVmHelper", "detach"));
            }
            return asyncPromise;
        }
        this.vm.getCommandProcessor().closed();
        this.channel = null;
        this.vm.getCommandProcessor().send(disconnectRequest).processed((Consumer)new Consumer<Void>(){

            public void consume(Void o) {
                try {
                    StandaloneVmHelper.this.vm.getCommandProcessor().cancelWaitingRequests();
                    StandaloneVmHelper.this.closeChannel(currentChannel, (AsyncPromise<Void>)promise);
                }
                catch (Throwable e) {
                    promise.setError(e);
                }
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/StandaloneVmHelper", "detach"));
        }
        return asyncPromise;
    }

    protected void closeChannel(@NotNull Channel channel, @NotNull AsyncPromise<Void> promise) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/debugger/StandaloneVmHelper", "closeChannel"));
        }
        if (promise == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "org/jetbrains/debugger/StandaloneVmHelper", "closeChannel"));
        }
        StandaloneVmHelper.doCloseChannel(channel, promise);
    }

    public static void doCloseChannel(@NotNull Channel channel, final @NotNull AsyncPromise<Void> promise) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/debugger/StandaloneVmHelper", "doCloseChannel"));
        }
        if (promise == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "org/jetbrains/debugger/StandaloneVmHelper", "doCloseChannel"));
        }
        final EventLoop eventLoop = channel.eventLoop();
        channel.close().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                try {
                    if (eventLoop instanceof OioEventLoopGroup) {
                        eventLoop.shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
                    }
                }
                finally {
                    Throwable error = future.cause();
                    if (error == null) {
                        promise.setResult(null);
                    } else {
                        promise.setError(error);
                    }
                }
            }
        });
    }

    private class MyChannelFutureListener
    implements ChannelFutureListener {
        private MyChannelFutureListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (StandaloneVmHelper.this.channel != null) {
                StandaloneVmHelper.this.vm.getCommandProcessor().closed();
                StandaloneVmHelper.this.vm.getDebugListener().disconnected();
            }
        }
    }

    public static interface VmEx
    extends Vm {
        public MessageProcessor getCommandProcessor();

        @Nullable
        public Request createDisconnectRequest();
    }
}

