/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceResolver;

public class SourceMap {
    private final MappingList mappings;
    final MappingList[] sourceIndexToMappings;
    private final String outFile;
    private final SourceResolver sourceResolver;
    private final boolean hasNameMappings;

    public SourceMap(@Nullable String outFile, @NotNull MappingList mappings, @NotNull MappingList[] sourceIndexToMappings, @NotNull SourceResolver sourceResolver, boolean hasNameMappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/debugger/sourcemap/SourceMap", "<init>"));
        }
        if (sourceIndexToMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceIndexToMappings", "org/jetbrains/debugger/sourcemap/SourceMap", "<init>"));
        }
        if (sourceResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceResolver", "org/jetbrains/debugger/sourcemap/SourceMap", "<init>"));
        }
        this.outFile = outFile;
        this.mappings = mappings;
        this.sourceIndexToMappings = sourceIndexToMappings;
        this.sourceResolver = sourceResolver;
        this.hasNameMappings = hasNameMappings;
    }

    public boolean hasNameMappings() {
        return this.hasNameMappings;
    }

    @NotNull
    public SourceResolver getSourceResolver() {
        SourceResolver sourceResolver = this.sourceResolver;
        if (sourceResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/sourcemap/SourceMap", "getSourceResolver"));
        }
        return sourceResolver;
    }

    @Nullable
    public String getOutFile() {
        return this.outFile;
    }

    public Url[] getSources() {
        return this.sourceResolver.canonicalizedSources;
    }

    @NotNull
    public MappingList getMappings() {
        MappingList mappingList = this.mappings;
        if (mappingList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/sourcemap/SourceMap", "getMappings"));
        }
        return mappingList;
    }

    public int getSourceLineByRawLocation(int rawLine, int rawColumn) {
        MappingEntry entry = this.getMappings().get(rawLine, rawColumn);
        return entry == null ? -1 : entry.getSourceLine();
    }

    @Nullable
    public MappingList findMappingList(@NotNull List<Url> sourceUrls, @Nullable VirtualFile sourceFile, @Nullable NullableLazyValue<SourceResolver.Resolver> resolver) {
        SourceResolver.Resolver resolverValue;
        if (sourceUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrls", "org/jetbrains/debugger/sourcemap/SourceMap", "findMappingList"));
        }
        MappingList mappings = this.sourceResolver.findMappings(sourceUrls, this, sourceFile);
        if (mappings == null && resolver != null && (resolverValue = (SourceResolver.Resolver)resolver.getValue()) != null) {
            mappings = this.sourceResolver.findMappings(sourceFile, this, resolverValue);
        }
        return mappings;
    }

    public boolean processMappingsInLine(@NotNull List<Url> sourceUrls, int sourceLine, @NotNull MappingList.MappingsProcessorInLine mappingProcessor, @Nullable VirtualFile sourceFile, @Nullable NullableLazyValue<SourceResolver.Resolver> resolver) {
        if (sourceUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrls", "org/jetbrains/debugger/sourcemap/SourceMap", "processMappingsInLine"));
        }
        if (mappingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappingProcessor", "org/jetbrains/debugger/sourcemap/SourceMap", "processMappingsInLine"));
        }
        MappingList mappings = this.findMappingList(sourceUrls, sourceFile, resolver);
        return mappings != null && mappings.processMappingsInLine(sourceLine, mappingProcessor);
    }

    @NotNull
    public MappingList getMappingsOrderedBySource(int source) {
        MappingList mappingList = this.sourceIndexToMappings[source];
        if (mappingList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/sourcemap/SourceMap", "getMappingsOrderedBySource"));
        }
        return mappingList;
    }
}

