/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCoreUtil {
    public static final String DIRECTORY_BASED_PROJECT_DIR = ".idea";

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/ProjectCoreUtil", "isProjectOrWorkspaceFile"));
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file, file.getFileType());
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file, @Nullable FileType fileType) {
        VirtualFile parent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/ProjectCoreUtil", "isProjectOrWorkspaceFile"));
        }
        if (fileType instanceof InternalFileType) {
            return true;
        }
        VirtualFile virtualFile = parent = file.isDirectory() ? file : file.getParent();
        while (parent != null) {
            if (Comparing.equal((CharSequence)parent.getNameSequence(), (CharSequence)DIRECTORY_BASED_PROJECT_DIR, (boolean)SystemInfoRt.isFileSystemCaseSensitive)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

