/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.Processor;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystem
extends NewVirtualFileSystem {
    @NonNls
    public static final String PROTOCOL = "file";
    @NonNls
    public static final String PROTOCOL_PREFIX = "file://";

    public static LocalFileSystem getInstance() {
        return LocalFileSystemHolder.ourInstance;
    }

    @Nullable
    public abstract VirtualFile findFileByIoFile(@NotNull File var1);

    @Deprecated
    @Nullable
    public abstract VirtualFile findFileByIoFile(@NotNull IFile var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByIoFile(@NotNull File var1);

    @Deprecated
    @Nullable
    public abstract VirtualFile refreshAndFindFileByIoFile(@NotNull IFile var1);

    public abstract void refreshIoFiles(@NotNull Iterable<File> var1);

    public abstract void refreshIoFiles(@NotNull Iterable<File> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    public abstract void refreshFiles(@NotNull Iterable<VirtualFile> var1);

    public abstract void refreshFiles(@NotNull Iterable<VirtualFile> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    @Nullable
    public WatchRequest addRootToWatch(@NotNull String rootPath, boolean watchRecursively) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/openapi/vfs/LocalFileSystem", "addRootToWatch"));
        }
        Set<WatchRequest> result = this.addRootsToWatch(Collections.singleton(rootPath), watchRecursively);
        return result.size() == 1 ? result.iterator().next() : null;
    }

    @NotNull
    public abstract Set<WatchRequest> addRootsToWatch(@NotNull Collection<String> var1, boolean var2);

    public void removeWatchedRoot(@Nullable WatchRequest watchRequest) {
        if (watchRequest != null) {
            this.removeWatchedRoots(Collections.singleton(watchRequest));
        }
    }

    public abstract void removeWatchedRoots(@NotNull Collection<WatchRequest> var1);

    @Nullable
    public WatchRequest replaceWatchedRoot(@Nullable WatchRequest watchRequest, @NotNull String rootPath, boolean watchRecursively) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/openapi/vfs/LocalFileSystem", "replaceWatchedRoot"));
        }
        Set<WatchRequest> requests = watchRequest != null ? Collections.singleton(watchRequest) : Collections.emptySet();
        Set<WatchRequest> result = watchRecursively ? this.replaceWatchedRoots(requests, Collections.singleton(rootPath), null) : this.replaceWatchedRoots(requests, null, Collections.singleton(rootPath));
        return result.size() == 1 ? result.iterator().next() : null;
    }

    @NotNull
    public abstract Set<WatchRequest> replaceWatchedRoots(@NotNull Collection<WatchRequest> var1, @Nullable Collection<String> var2, @Nullable Collection<String> var3);

    public abstract void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract boolean processCachedFilesInSubtree(@NotNull VirtualFile var1, @NotNull Processor<VirtualFile> var2);

    public static interface WatchRequest {
        @NotNull
        public String getRootPath();

        public boolean isToWatchRecursively();
    }

    private static class LocalFileSystemHolder {
        private static final LocalFileSystem ourInstance = (LocalFileSystem)VirtualFileManager.getInstance().getFileSystem("file");

        private LocalFileSystemHolder() {
        }
    }
}

