/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.model.MavenArtifact;

public class DependencyConflictId {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;

    public DependencyConflictId(@NotNull String groupId, @NotNull String artifactId, @Nullable String type, @Nullable String classifier) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/dom/DependencyConflictId", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/dom/DependencyConflictId", "<init>"));
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = StringUtil.isEmpty((String)type) ? "jar" : type;
        this.classifier = classifier;
    }

    @Nullable
    public static DependencyConflictId create(@NotNull MavenDomDependency dep) {
        if (dep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dep", "org/jetbrains/idea/maven/dom/DependencyConflictId", "create"));
        }
        String groupId = dep.getGroupId().getStringValue();
        if (StringUtil.isEmpty((String)groupId)) {
            return null;
        }
        String artifactId = dep.getArtifactId().getStringValue();
        if (StringUtil.isEmpty((String)artifactId)) {
            return null;
        }
        return new DependencyConflictId(groupId, artifactId, dep.getType().getStringValue(), dep.getClassifier().getStringValue());
    }

    @Nullable
    public static DependencyConflictId create(@NotNull MavenArtifact dep) {
        if (dep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dep", "org/jetbrains/idea/maven/dom/DependencyConflictId", "create"));
        }
        return DependencyConflictId.create(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getClassifier());
    }

    @Nullable
    public static DependencyConflictId create(String groupId, String artifactId, String type, String classifier) {
        if (StringUtil.isEmpty((String)groupId)) {
            return null;
        }
        if (StringUtil.isEmpty((String)artifactId)) {
            return null;
        }
        return new DependencyConflictId(groupId, artifactId, type, classifier);
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/DependencyConflictId", "getGroupId"));
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/DependencyConflictId", "getArtifactId"));
        }
        return string;
    }

    @NotNull
    public String getType() {
        String string = this.type;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/DependencyConflictId", "getType"));
        }
        return string;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependencyConflictId)) {
            return false;
        }
        DependencyConflictId id = (DependencyConflictId)o;
        if (!this.artifactId.equals(id.artifactId)) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(id.classifier) : id.classifier != null) {
            return false;
        }
        if (!this.groupId.equals(id.groupId)) {
            return false;
        }
        return this.type.equals(id.type);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }
}

