/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelBinding;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBinder<T> {
    private final ModelReference<T> subjectReference;
    private final List<ModelReference<?>> inputReferences;
    private final ModelRuleDescriptor descriptor;
    private Action<? super RuleBinder<T>> onBind;
    private int inputsBound;
    private ModelBinding<T> subjectBinding;
    private List<ModelBinding<?>> inputBindings;

    public RuleBinder(@Nullable ModelReference<T> subjectReference, List<ModelReference<?>> inputReferences, ModelRuleDescriptor descriptor, Action<? super RuleBinder<T>> onBind) {
        this.subjectReference = subjectReference;
        this.inputReferences = inputReferences;
        this.descriptor = descriptor;
        this.onBind = onBind;
        this.inputBindings = inputReferences.isEmpty() ? Collections.emptyList() : Arrays.asList(new ModelBinding[inputReferences.size()]);
        this.maybeFire();
    }

    @Nullable
    public ModelReference<T> getSubjectReference() {
        return this.subjectReference;
    }

    public List<ModelReference<?>> getInputReferences() {
        return this.inputReferences;
    }

    public ModelBinding<T> getSubjectBinding() {
        return this.subjectBinding;
    }

    public List<ModelBinding<?>> getInputBindings() {
        return this.inputBindings;
    }

    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean bindSubject(ModelPath path) {
        assert (this.subjectBinding == null);
        this.subjectBinding = RuleBinder.bind(this.subjectReference, path);
        return this.maybeFire();
    }

    public boolean bindInput(int i, ModelPath path) {
        assert (this.inputBindings.get(i) == null);
        this.inputBindings.set(i, RuleBinder.bind(this.inputReferences.get(i), path));
        ++this.inputsBound;
        return this.maybeFire();
    }

    private boolean maybeFire() {
        if (this.isBound()) {
            this.fire();
            return true;
        }
        return false;
    }

    public boolean isBound() {
        return (this.subjectReference == null || this.subjectBinding != null) && this.inputsBound == this.inputReferences.size();
    }

    private void fire() {
        this.onBind.execute((Object)this);
        this.onBind = null;
    }

    private static <I> ModelBinding<I> bind(ModelReference<I> reference, ModelPath path) {
        return ModelBinding.of(reference, path);
    }

    private String pathStringOrNull(ModelReference<?> reference) {
        return reference.getPath() == null ? null : reference.getPath().toString();
    }
}

