/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.repo.GitRepository;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitCheckoutOperation
extends GitBranchOperation {
    public static final String ROLLBACK_PROPOSAL_FORMAT = "You may rollback (checkout back to previous branch) not to let branches diverge.";
    @NotNull
    private final String myStartPointReference;
    private final boolean myDetach;
    @Nullable
    private final String myNewBranch;

    GitCheckoutOperation(@NotNull Project project, GitPlatformFacade facade, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories, @NotNull String startPointReference, boolean detach, @Nullable String newBranch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitCheckoutOperation", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/branch/GitCheckoutOperation", "<init>"));
        }
        if (uiHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiHandler", "git4idea/branch/GitCheckoutOperation", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitCheckoutOperation", "<init>"));
        }
        if (startPointReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPointReference", "git4idea/branch/GitCheckoutOperation", "<init>"));
        }
        super(project, facade, git, uiHandler, repositories);
        this.myStartPointReference = startPointReference;
        this.myDetach = detach;
        this.myNewBranch = newBranch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        this.saveAllDocuments();
        boolean fatalErrorHappened = false;
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            while (this.hasMoreRepositories() && !fatalErrorHappened) {
                GitUntrackedFilesOverwrittenByOperationDetector untrackedOverwrittenByCheckout;
                GitSimpleEventDetector unmergedFiles;
                VirtualFile root;
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector;
                GitRepository repository = this.next();
                GitCommandResult result = this.myGit.checkout(repository, this.myStartPointReference, this.myNewBranch, false, this.myDetach, localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root = repository.getRoot(), GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT), unmergedFiles = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_CHECKOUT), untrackedOverwrittenByCheckout = new GitUntrackedFilesOverwrittenByOperationDetector(root));
                if (result.success()) {
                    this.refresh(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                if (unmergedFiles.hasHappened()) {
                    this.fatalUnmergedFilesError();
                    fatalErrorHappened = true;
                    continue;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    boolean smartCheckoutSucceeded = this.smartCheckoutOrNotify(repository, localChangesDetector);
                    if (smartCheckoutSucceeded) continue;
                    fatalErrorHappened = true;
                    continue;
                }
                if (untrackedOverwrittenByCheckout.wasMessageDetected()) {
                    this.fatalUntrackedFilesError(repository.getRoot(), untrackedOverwrittenByCheckout.getRelativeFilePaths());
                    fatalErrorHappened = true;
                    continue;
                }
                this.fatalError(this.getCommonErrorTitle(), result.getErrorOutputAsJoinedString());
                fatalErrorHappened = true;
            }
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
            this.updateRecentBranch();
        }
    }

    private boolean smartCheckoutOrNotify(@NotNull GitRepository repository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenByCheckout) {
        Collection<String> absolutePaths;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/branch/GitCheckoutOperation", "smartCheckoutOrNotify"));
        }
        if (localChangesOverwrittenByCheckout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangesOverwrittenByCheckout", "git4idea/branch/GitCheckoutOperation", "smartCheckoutOrNotify"));
        }
        Pair<List<GitRepository>, List<Change>> conflictingRepositoriesAndAffectedChanges = this.getConflictingRepositoriesAndAffectedChanges(repository, localChangesOverwrittenByCheckout, (String)this.myCurrentHeads.get(repository), this.myStartPointReference);
        List allConflictingRepositories = (List)conflictingRepositoriesAndAffectedChanges.getFirst();
        List affectedChanges = (List)conflictingRepositoriesAndAffectedChanges.getSecond();
        int smartCheckoutDecision = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths = GitUtil.toAbsolute(repository.getRoot(), localChangesOverwrittenByCheckout.getRelativeFilePaths()), "checkout", "&Force Checkout");
        if (smartCheckoutDecision == 0) {
            boolean smartCheckedOutSuccessfully = this.smartCheckout(allConflictingRepositories, this.myStartPointReference, this.myNewBranch, this.getIndicator());
            if (smartCheckedOutSuccessfully) {
                for (GitRepository conflictingRepository : allConflictingRepositories) {
                    this.markSuccessful(conflictingRepository);
                    this.refresh(conflictingRepository);
                }
                return true;
            }
            return false;
        }
        if (smartCheckoutDecision == 2) {
            boolean forceCheckoutSucceeded = this.checkoutOrNotify(allConflictingRepositories, this.myStartPointReference, this.myNewBranch, true);
            if (forceCheckoutSucceeded) {
                this.markSuccessful((GitRepository[])ArrayUtil.toObjectArray((Collection)allConflictingRepositories, GitRepository.class));
                this.refresh((GitRepository[])ArrayUtil.toObjectArray((Collection)allConflictingRepositories, GitRepository.class));
            }
            return forceCheckoutSucceeded;
        }
        this.fatalLocalChangesError(this.myStartPointReference);
        return false;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = "However checkout has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>" + ROLLBACK_PROPOSAL_FORMAT;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitCheckoutOperation", "getRollbackProposal"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        if ("checkout" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitCheckoutOperation", "getOperationName"));
        }
        return "checkout";
    }

    @Override
    protected void rollback() {
        GitCompoundResult checkoutResult = new GitCompoundResult(this.myProject);
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult result = this.myGit.checkout(repository, (String)this.myCurrentHeads.get(repository), null, true, false, new GitLineHandlerListener[0]);
            checkoutResult.append(repository, result);
            if (result.success() && this.myNewBranch != null) {
                deleteResult.append(repository, this.myGit.branchDelete(repository, this.myNewBranch, true, new GitLineHandlerListener[0]));
            }
            this.refresh(repository);
        }
        if (!checkoutResult.totalSuccess() || !deleteResult.totalSuccess()) {
            StringBuilder message = new StringBuilder();
            if (!checkoutResult.totalSuccess()) {
                message.append("Errors during checkout: ");
                message.append(checkoutResult.getErrorOutputWithReposIndication());
            }
            if (!deleteResult.totalSuccess()) {
                message.append("Errors during deleting ").append(GitUIUtil.code(this.myNewBranch)).append(": ");
                message.append(deleteResult.getErrorOutputWithReposIndication());
            }
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Error during rollback", message.toString());
        }
    }

    @NotNull
    private String getCommonErrorTitle() {
        String string = "Couldn't checkout " + this.myStartPointReference;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitCheckoutOperation", "getCommonErrorTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        if (this.myNewBranch == null) {
            String string = String.format("Checked out <b><code>%s</code></b>", this.myStartPointReference);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitCheckoutOperation", "getSuccessMessage"));
            }
            return string;
        }
        String string = String.format("Checked out new branch <b><code>%s</code></b> from <b><code>%s</code></b>", this.myNewBranch, this.myStartPointReference);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitCheckoutOperation", "getSuccessMessage"));
        }
        return string;
    }

    private boolean smartCheckout(final @NotNull List<GitRepository> repositories, final @NotNull String reference, final @Nullable String newBranch, @NotNull ProgressIndicator indicator) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitCheckoutOperation", "smartCheckout"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/branch/GitCheckoutOperation", "smartCheckout"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitCheckoutOperation", "smartCheckout"));
        }
        final AtomicBoolean result = new AtomicBoolean();
        GitPreservingProcess preservingProcess = new GitPreservingProcess(this.myProject, this.myFacade, this.myGit, repositories, "checkout", reference, indicator, new Runnable(){

            @Override
            public void run() {
                result.set(GitCheckoutOperation.this.checkoutOrNotify(repositories, reference, newBranch, false));
            }
        });
        preservingProcess.execute();
        return result.get();
    }

    private boolean checkoutOrNotify(@NotNull List<GitRepository> repositories, @NotNull String reference, @Nullable String newBranch, boolean force) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitCheckoutOperation", "checkoutOrNotify"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/branch/GitCheckoutOperation", "checkoutOrNotify"));
        }
        GitCompoundResult compoundResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository : repositories) {
            compoundResult.append(repository, this.myGit.checkout(repository, reference, newBranch, force, this.myDetach, new GitLineHandlerListener[0]));
        }
        if (compoundResult.totalSuccess()) {
            return true;
        }
        this.notifyError("Couldn't checkout " + reference, compoundResult.getErrorOutputWithReposIndication());
        return false;
    }

    private void refresh(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            this.refreshRoot(repository);
            repository.update();
        }
    }
}

