/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DslActivationStatus", storages={@Storage(file="$APP_CONFIG$/dslActivation.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(file="$APP_CONFIG$/dslActivationStatus.xml")})
public class DslActivationStatus
implements PersistentStateComponent<State> {
    private final Map<VirtualFile, Entry> myStatus = Collections.synchronizedMap(new FactoryMap<VirtualFile, Entry>(){

        @Nullable
        protected Entry create(VirtualFile key) {
            return new Entry(key.getUrl(), Status.ACTIVE, null);
        }
    });

    public Entry getGdslFileInfo(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/dsl/DslActivationStatus", "getGdslFileInfo"));
        }
        return this.myStatus.get(file);
    }

    @Nullable
    public State getState() {
        State state = new State();
        state.entries = this.myStatus.values();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(State state) {
        Map<VirtualFile, Entry> map = this.myStatus;
        synchronized (map) {
            this.myStatus.clear();
            if (state.entries == null) {
                return;
            }
            VirtualFileManager fileManager = VirtualFileManager.getInstance();
            for (Entry entry : state.entries) {
                VirtualFile file;
                if (entry.url == null || entry.status == null || (file = fileManager.findFileByUrl(entry.url)) == null) continue;
                this.myStatus.put(file, entry);
            }
        }
    }

    public static DslActivationStatus getInstance() {
        return (DslActivationStatus)ServiceManager.getService(DslActivationStatus.class);
    }

    public static class State {
        @AbstractCollection(surroundWithTag=false)
        public Collection<Entry> entries = ContainerUtil.newArrayList();
    }

    public static class Entry {
        @Attribute
        public String url;
        @Attribute
        public Status status;
        @Attribute
        public String error;

        public Entry() {
        }

        public Entry(String url, Status status, String error) {
            this.url = url;
            this.status = status;
            this.error = error;
        }
    }

    static enum Status {
        ACTIVE,
        MODIFIED,
        ERROR;

    }
}

