/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendContextRunnable;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SynchronizationBasedSemaphore;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTestCase;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.CompositeException;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.jdi.Method;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public abstract class ExecutionWithDebuggerToolsTestCase
extends ExecutionTestCase {
    private DebugProcessListener myPauseScriptListener = null;
    private final List<SuspendContextRunnable> myScriptRunnables = new ArrayList<SuspendContextRunnable>();
    private final SynchronizationBasedSemaphore myScriptRunnablesSema = new SynchronizationBasedSemaphore();
    protected static final int RATHER_LATER_INVOKES_N = 10;
    public DebugProcessImpl myDebugProcess = null;
    private final CompositeException myException = new CompositeException(new Throwable[0]);
    public final List<InvokeRatherLaterRequest> myRatherLaterRequests = new ArrayList<InvokeRatherLaterRequest>();

    protected DebugProcessImpl getDebugProcess() {
        return this.myDebugProcess;
    }

    protected String readValue(String comment, String valueName) {
        int valueStart = comment.indexOf(valueName);
        if (valueStart == -1) {
            return null;
        }
        int valueEnd = comment.indexOf(41, valueStart);
        return comment.substring(valueStart + valueName.length() + 1, valueEnd);
    }

    protected void resume(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createResumeCommand(context, PrioritizedTask.Priority.LOW));
    }

    protected void waitBreakpoints() {
        this.myScriptRunnablesSema.down();
        this.waitFor(new Runnable(){

            @Override
            public void run() {
                ExecutionWithDebuggerToolsTestCase.this.myScriptRunnablesSema.waitFor();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        CompositeException compositeException = this.myException;
        synchronized (compositeException) {
            if (!this.myException.isEmpty()) {
                throw this.myException;
            }
        }
    }

    protected void onBreakpoint(SuspendContextRunnable runnable) {
        if (this.myPauseScriptListener == null) {
            final DebugProcessImpl debugProcess = this.getDebugProcess();
            ExecutionWithDebuggerToolsTestCase.assertTrue((String)"Debug process was not started", (debugProcess != null ? 1 : 0) != 0);
            this.myPauseScriptListener = new DelayedEventsProcessListener(new DebugProcessAdapterImpl(){

                public void paused(SuspendContextImpl suspendContext) {
                    try {
                        if (ExecutionWithDebuggerToolsTestCase.this.myScriptRunnables.isEmpty()) {
                            ExecutionWithDebuggerToolsTestCase.this.print("resuming ", ProcessOutputTypes.SYSTEM);
                            ExecutionWithDebuggerToolsTestCase.this.printContext((StackFrameContext)suspendContext);
                            ExecutionWithDebuggerToolsTestCase.this.resume(suspendContext);
                            return;
                        }
                        SuspendContextRunnable suspendContextRunnable = (SuspendContextRunnable)ExecutionWithDebuggerToolsTestCase.this.myScriptRunnables.remove(0);
                        suspendContextRunnable.run(suspendContext);
                    }
                    catch (Exception e) {
                        ExecutionWithDebuggerToolsTestCase.this.addException(e);
                        ExecutionWithDebuggerToolsTestCase.this.error(e);
                    }
                    catch (AssertionError e) {
                        ExecutionWithDebuggerToolsTestCase.this.addException((Throwable)((Object)e));
                        this.paused(suspendContext);
                    }
                    if (ExecutionWithDebuggerToolsTestCase.this.myScriptRunnables.isEmpty()) {
                        ExecutionWithDebuggerToolsTestCase.this.myScriptRunnablesSema.up();
                    }
                }

                public void resumed(SuspendContextImpl suspendContext) {
                    final SuspendContextImpl pausedContext = debugProcess.getSuspendManager().getPausedContext();
                    if (pausedContext != null) {
                        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(pausedContext){

                            public void contextAction() throws Exception {
                                this.paused(pausedContext);
                            }
                        });
                    }
                }
            });
            debugProcess.addDebugProcessListener(this.myPauseScriptListener);
        }
        this.myScriptRunnables.add(runnable);
    }

    protected void printFrameProxy(StackFrameProxyImpl frameProxy) throws EvaluateException {
        int frameIndex = frameProxy.getFrameIndex();
        Method method = frameProxy.location().method();
        this.println("frameProxy(" + frameIndex + ") = " + method, ProcessOutputTypes.SYSTEM);
    }

    protected void printContext(final StackFrameContext context) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (context.getFrameProxy() != null) {
                    SourcePosition sourcePosition = PositionUtil.getSourcePosition((StackFrameContext)context);
                    ExecutionWithDebuggerToolsTestCase.this.println(sourcePosition.getFile().getVirtualFile().getName() + ":" + sourcePosition.getLine(), ProcessOutputTypes.SYSTEM);
                } else {
                    ExecutionWithDebuggerToolsTestCase.this.println("Context thread is null", ProcessOutputTypes.SYSTEM);
                }
            }
        });
    }

    protected void printContextWithText(final StackFrameContext context) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (context.getFrameProxy() != null) {
                    SourcePosition sourcePosition = PositionUtil.getSourcePosition((StackFrameContext)context);
                    int offset = sourcePosition.getOffset();
                    Document document = PsiDocumentManager.getInstance(ExecutionWithDebuggerToolsTestCase.this.myProject).getDocument(sourcePosition.getFile());
                    CharSequence text = document.getImmutableCharSequence();
                    String positionText = "";
                    if (offset > -1) {
                        positionText = StringUtil.escapeLineBreak((String)(" [" + text.subSequence(Math.max(0, offset - 20), offset) + "<*>" + text.subSequence(offset, Math.min(offset + 20, text.length())) + "]"));
                    }
                    ExecutionWithDebuggerToolsTestCase.this.println(sourcePosition.getFile().getVirtualFile().getName() + ":" + sourcePosition.getLine() + positionText, ProcessOutputTypes.SYSTEM);
                } else {
                    ExecutionWithDebuggerToolsTestCase.this.println("Context thread is null", ProcessOutputTypes.SYSTEM);
                }
            }
        });
    }

    protected void invokeRatherLater(SuspendContextImpl context, final Runnable runnable) {
        this.invokeRatherLater((DebuggerCommandImpl)new SuspendContextCommandImpl(context){

            public void contextAction() throws Exception {
                DebuggerInvocationUtil.invokeLater((Project)ExecutionWithDebuggerToolsTestCase.this.myProject, (Runnable)runnable);
            }
        });
    }

    protected void pumpSwingThread() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        final InvokeRatherLaterRequest request = this.myRatherLaterRequests.get(0);
        ++request.invokesN;
        if (request.invokesN == 10) {
            this.myRatherLaterRequests.remove(0);
            if (!this.myRatherLaterRequests.isEmpty()) {
                this.pumpSwingThread();
            }
        }
        if (request.myDebuggerCommand instanceof SuspendContextCommandImpl) {
            request.myDebugProcess.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(((SuspendContextCommandImpl)request.myDebuggerCommand).getSuspendContext()){

                public void contextAction() throws Exception {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                protected void commandCancelled() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }
            });
        } else {
            request.myDebugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                protected void action() throws Exception {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                protected void commandCancelled() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }
            });
        }
    }

    private void pumpDebuggerThread(InvokeRatherLaterRequest request) {
        if (request.invokesN == 10) {
            request.myDebugProcess.getManagerThread().schedule(request.myDebuggerCommand);
        } else if (!SwingUtilities.isEventDispatchThread()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpSwingThread();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpSwingThread();
                }
            });
        }
    }

    protected void invokeRatherLater(final DebuggerCommandImpl command) {
        IJSwingUtilities.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                InvokeRatherLaterRequest request = new InvokeRatherLaterRequest(command, ExecutionWithDebuggerToolsTestCase.this.getDebugProcess());
                ExecutionWithDebuggerToolsTestCase.this.myRatherLaterRequests.add(request);
                if (ExecutionWithDebuggerToolsTestCase.this.myRatherLaterRequests.size() == 1) {
                    ExecutionWithDebuggerToolsTestCase.this.pumpSwingThread();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addException(Throwable e) {
        CompositeException compositeException = this.myException;
        synchronized (compositeException) {
            this.myException.add(e);
        }
    }

    protected void error(Throwable th) {
        ExecutionWithDebuggerToolsTestCase.fail((String)StringUtil.getThrowableText((Throwable)th));
    }

    public void createBreakpoints(final PsiFile file) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BreakpointManager breakpointManager = DebuggerManagerImpl.getInstanceEx((Project)ExecutionWithDebuggerToolsTestCase.this.myProject).getBreakpointManager();
                Document document = PsiDocumentManager.getInstance(ExecutionWithDebuggerToolsTestCase.this.myProject).getDocument(file);
                int offset = -1;
                while ((offset = document.getText().indexOf("Breakpoint!", offset + 1)) != -1) {
                    String classFilters;
                    String passCount;
                    String condition;
                    String suspendPolicy;
                    MethodBreakpoint breakpoint;
                    int commentLine = document.getLineNumber(offset);
                    String comment = document.getText().substring(document.getLineStartOffset(commentLine), document.getLineEndOffset(commentLine));
                    if (comment.indexOf("Method") != -1) {
                        breakpoint = breakpointManager.addMethodBreakpoint(document, commentLine + 1);
                        if (breakpoint != null) {
                            ExecutionWithDebuggerToolsTestCase.this.println("MethodBreakpoint created at " + file.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                        }
                    } else if (comment.indexOf("Field") != -1) {
                        breakpoint = breakpointManager.addFieldBreakpoint(document, commentLine + 1, ExecutionWithDebuggerToolsTestCase.this.readValue(comment, "Field"));
                        if (breakpoint != null) {
                            ExecutionWithDebuggerToolsTestCase.this.println("FieldBreakpoint created at " + file.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                        }
                    } else if (comment.indexOf("Exception") != -1) {
                        breakpoint = breakpointManager.addExceptionBreakpoint(ExecutionWithDebuggerToolsTestCase.this.readValue(comment, "Exception"), "");
                        if (breakpoint != null) {
                            ExecutionWithDebuggerToolsTestCase.this.println("ExceptionBreakpoint created at " + file.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                        }
                    } else {
                        breakpoint = breakpointManager.addLineBreakpoint(document, commentLine + 1);
                        if (breakpoint != null) {
                            ExecutionWithDebuggerToolsTestCase.this.println("LineBreakpoint created at " + file.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                        }
                    }
                    if ((suspendPolicy = ExecutionWithDebuggerToolsTestCase.this.readValue(comment, "suspendPolicy")) != null) {
                        breakpoint.setSuspendPolicy(suspendPolicy);
                        ExecutionWithDebuggerToolsTestCase.this.println("SUSPEND_POLICY = " + suspendPolicy, ProcessOutputTypes.SYSTEM);
                    }
                    if ((condition = ExecutionWithDebuggerToolsTestCase.this.readValue(comment, "Condition")) != null) {
                        breakpoint.setCondition((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, condition));
                        ExecutionWithDebuggerToolsTestCase.this.println("Condition = " + condition, ProcessOutputTypes.SYSTEM);
                    }
                    if ((passCount = ExecutionWithDebuggerToolsTestCase.this.readValue(comment, "Pass count")) != null) {
                        breakpoint.setCountFilterEnabled(true);
                        breakpoint.setCountFilter(Integer.parseInt(passCount));
                        ExecutionWithDebuggerToolsTestCase.this.println("Pass count = " + passCount, ProcessOutputTypes.SYSTEM);
                    }
                    if ((classFilters = ExecutionWithDebuggerToolsTestCase.this.readValue(comment, "Class filters")) == null) continue;
                    breakpoint.setClassFiltersEnabled(true);
                    StringTokenizer tokenizer = new StringTokenizer(classFilters, " ,");
                    ArrayList<ClassFilter> lst = new ArrayList<ClassFilter>();
                    while (tokenizer.hasMoreTokens()) {
                        ClassFilter filter = new ClassFilter();
                        filter.setEnabled(true);
                        filter.setPattern(tokenizer.nextToken());
                        lst.add(filter);
                    }
                    breakpoint.setClassFilters(lst.toArray(new ClassFilter[lst.size()]));
                    ExecutionWithDebuggerToolsTestCase.this.println("Class filters = " + classFilters, ProcessOutputTypes.SYSTEM);
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, (Runnable)runnable, (ModalityState)ModalityState.defaultModalityState());
        } else {
            runnable.run();
        }
    }

    private static class DelayedEventsProcessListener
    implements DebugProcessListener {
        private final DebugProcessAdapterImpl myTarget;

        public DelayedEventsProcessListener(DebugProcessAdapterImpl target) {
            this.myTarget = target;
        }

        @Override
        public void threadStarted(DebugProcess proc, ThreadReference thread) {
        }

        @Override
        public void threadStopped(DebugProcess proc, ThreadReference thread) {
        }

        @Override
        public void paused(SuspendContext suspendContext) {
            DelayedEventsProcessListener.pauseExecution();
            this.myTarget.paused(suspendContext);
        }

        @Override
        public void resumed(SuspendContext suspendContext) {
            DelayedEventsProcessListener.pauseExecution();
            this.myTarget.resumed(suspendContext);
        }

        @Override
        public void processDetached(DebugProcess process, boolean closedByUser) {
            this.myTarget.processDetached(process, closedByUser);
        }

        @Override
        public void processAttached(DebugProcess process) {
            this.myTarget.processAttached(process);
        }

        @Override
        public void connectorIsReady() {
            this.myTarget.connectorIsReady();
        }

        @Override
        public void attachException(RunProfileState state, ExecutionException exception, RemoteConnection remoteConnection) {
            this.myTarget.attachException(state, exception, remoteConnection);
        }

        private static void pauseExecution() {
            TimeoutUtil.sleep((long)10L);
        }
    }

    private static class InvokeRatherLaterRequest {
        private final DebuggerCommandImpl myDebuggerCommand;
        private final DebugProcessImpl myDebugProcess;
        int invokesN = 0;

        public InvokeRatherLaterRequest(DebuggerCommandImpl debuggerCommand, DebugProcessImpl debugProcess) {
            this.myDebuggerCommand = debuggerCommand;
            this.myDebugProcess = debugProcess;
        }
    }
}

