/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaUtil {
    public static ThreadLocal<Map<PsiElement, PsiType>> ourFunctionTypes = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance((String)("#" + LambdaUtil.class.getName()));

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(PsiFunctionalExpression expr) {
        return LambdaUtil.getFunctionalInterfaceReturnType(expr.getFunctionalInterfaceType());
    }

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(@Nullable PsiType functionalInterfaceType) {
        MethodSignature methodSignature;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            PsiType returnType = LambdaUtil.getReturnType(psiClass, methodSignature);
            return resolveResult.getSubstitutor().substitute(returnType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiType functionalInterfaceType) {
        return LambdaUtil.getFunctionalInterfaceMethod(PsiUtil.resolveGenericsClassInType(functionalInterfaceType));
    }

    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiElement element) {
        if (element instanceof PsiFunctionalExpression) {
            PsiType samType = ((PsiFunctionalExpression)element).getFunctionalInterfaceType();
            return LambdaUtil.getFunctionalInterfaceMethod(samType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClassType.ClassResolveResult result) {
        return LambdaUtil.getFunctionalInterfaceMethod(result.getElement());
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClass aClass) {
        MethodSignature methodSignature = LambdaUtil.getFunction(aClass);
        if (methodSignature != null) {
            return LambdaUtil.getMethod(aClass, methodSignature);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutor(@NotNull PsiMethod method, @NotNull PsiClassType.ClassResolveResult resolveResult) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        PsiClass derivedClass = resolveResult.getElement();
        LOG.assertTrue(derivedClass != null);
        PsiClass methodContainingClass = method.getContainingClass();
        LOG.assertTrue(methodContainingClass != null);
        PsiSubstitutor initialSubst = resolveResult.getSubstitutor();
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(methodContainingClass, derivedClass, PsiSubstitutor.EMPTY);
        for (PsiTypeParameter param : superClassSubstitutor.getSubstitutionMap().keySet()) {
            PsiType substitute = superClassSubstitutor.substitute(param);
            if (substitute == null) continue;
            initialSubst = initialSubst.put(param, initialSubst.substitute(substitute));
        }
        return initialSubst;
    }

    public static boolean isFunctionalType(PsiType type) {
        if (type instanceof PsiIntersectionType) {
            return LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)type) != null;
        }
        return LambdaUtil.isFunctionalClass(PsiUtil.resolveGenericsClassInType(type).getElement());
    }

    @Contract(value="null -> false")
    public static boolean isFunctionalClass(PsiClass aClass) {
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return false;
            }
            List<HierarchicalMethodSignature> signatures = LambdaUtil.findFunctionCandidates(aClass);
            return signatures != null && signatures.size() == 1;
        }
        return false;
    }

    public static boolean isValidLambdaContext(@Nullable PsiElement context) {
        return context instanceof PsiTypeCastExpression || context instanceof PsiAssignmentExpression || context instanceof PsiVariable || context instanceof PsiLambdaExpression || context instanceof PsiReturnStatement || context instanceof PsiExpressionList || context instanceof PsiParenthesizedExpression || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && PsiTreeUtil.getParentOfType(context, PsiTypeCastExpression.class) == null;
    }

    public static boolean isLambdaFullyInferred(PsiLambdaExpression expression, PsiType functionalInterfaceType) {
        boolean hasParams;
        boolean bl = hasParams = expression.getParameterList().getParametersCount() > 0;
        if (hasParams || LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType) != PsiType.VOID) {
            return !LambdaUtil.dependsOnTypeParams(functionalInterfaceType, functionalInterfaceType, expression, new PsiTypeParameter[0]);
        }
        return true;
    }

    @Nullable
    public static MethodSignature getFunction(PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        List<HierarchicalMethodSignature> functions = LambdaUtil.findFunctionCandidates(psiClass);
        if (functions != null && functions.size() == 1) {
            return functions.get(0);
        }
        return null;
    }

    private static boolean overridesPublicObjectMethod(HierarchicalMethodSignature psiMethod) {
        PsiMethod method;
        PsiClass containingClass;
        List<HierarchicalMethodSignature> signatures = psiMethod.getSuperSignatures();
        if (signatures.isEmpty() && (containingClass = (method = psiMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && method.hasModifierProperty("public")) {
            return true;
        }
        for (HierarchicalMethodSignature superMethod : signatures) {
            if (!LambdaUtil.overridesPublicObjectMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static MethodSignature getMethodSignature(PsiMethod method, PsiClass psiClass, PsiClass containingClass) {
        MethodSignature methodSignature = containingClass != null && containingClass != psiClass ? method.getSignature(TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY)) : method.getSignature(PsiSubstitutor.EMPTY);
        return methodSignature;
    }

    @Nullable
    private static List<HierarchicalMethodSignature> hasSubsignature(List<HierarchicalMethodSignature> signatures) {
        for (HierarchicalMethodSignature signature : signatures) {
            boolean subsignature = true;
            for (HierarchicalMethodSignature methodSignature : signatures) {
                if (signature.equals(methodSignature) || MethodSignatureUtil.isSubsignature(signature, methodSignature) || LambdaUtil.skipMethod(signature, methodSignature)) continue;
                subsignature = false;
                break;
            }
            if (!subsignature) continue;
            return Collections.singletonList(signature);
        }
        return signatures;
    }

    private static boolean skipMethod(HierarchicalMethodSignature signature, HierarchicalMethodSignature methodSignature) {
        if (methodSignature.getTypeParameters().length == 0) {
            return false;
        }
        return signature.getMethod().getContainingClass() != methodSignature.getMethod().getContainingClass();
    }

    @Nullable
    public static List<HierarchicalMethodSignature> findFunctionCandidates(PsiClass psiClass) {
        if (psiClass != null && psiClass.isInterface() && !psiClass.isAnnotationType()) {
            ArrayList<HierarchicalMethodSignature> methods = new ArrayList<HierarchicalMethodSignature>();
            Collection<HierarchicalMethodSignature> visibleSignatures = psiClass.getVisibleSignatures();
            for (HierarchicalMethodSignature signature : visibleSignatures) {
                PsiMethod psiMethod = signature.getMethod();
                if (!psiMethod.hasModifierProperty("abstract") || psiMethod.hasModifierProperty("static") || LambdaUtil.overridesPublicObjectMethod(signature)) continue;
                methods.add(signature);
            }
            return LambdaUtil.hasSubsignature(methods);
        }
        return null;
    }

    @Nullable
    private static PsiType getReturnType(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod method = LambdaUtil.getMethod(psiClass, methodSignature);
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY).substitute(method.getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod[] methodsByName;
        if (methodSignature instanceof MethodSignatureBackedByPsiMethod) {
            return ((MethodSignatureBackedByPsiMethod)methodSignature).getMethod();
        }
        for (PsiMethod psiMethod : methodsByName = psiClass.findMethodsByName(methodSignature.getName(), true)) {
            if (!MethodSignatureUtil.areSignaturesEqual(LambdaUtil.getMethodSignature(psiMethod, psiClass, psiMethod.getContainingClass()), methodSignature)) continue;
            return psiMethod;
        }
        return null;
    }

    public static int getLambdaIdx(PsiExpressionList expressionList, PsiElement element) {
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            if (!PsiTreeUtil.isAncestor(expression, element, false)) continue;
            return i;
        }
        return -1;
    }

    public static boolean dependsOnTypeParams(PsiType type, PsiType functionalInterfaceType, PsiElement lambdaExpression, PsiTypeParameter ... param2Check) {
        return LambdaUtil.depends(type, new TypeParamsChecker(lambdaExpression, PsiUtil.resolveClassInType(functionalInterfaceType)), param2Check);
    }

    public static boolean depends(PsiType type, TypeParamsChecker visitor, PsiTypeParameter ... param2Check) {
        if (!visitor.startedInference()) {
            return false;
        }
        Boolean accept = type.accept(visitor);
        if (param2Check.length > 0) {
            return visitor.used(param2Check);
        }
        return accept != null && accept != false;
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression, boolean tryToSubstitute) {
        PsiType type;
        PsiElement parent = expression.getParent();
        PsiElement element = expression;
        while (!(!(parent instanceof PsiParenthesizedExpression) && !(parent instanceof PsiConditionalExpression) || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getThenExpression() != element && ((PsiConditionalExpression)parent).getElseExpression() != element)) {
            element = parent;
            parent = parent.getParent();
        }
        Map<PsiElement, PsiType> map = ourFunctionTypes.get();
        if (map != null && (type = map.get(expression)) != null) {
            return type;
        }
        if (parent instanceof PsiArrayInitializerExpression) {
            PsiType psiType = ((PsiArrayInitializerExpression)parent).getType();
            if (psiType instanceof PsiArrayType) {
                return ((PsiArrayType)psiType).getComponentType();
            }
        } else {
            if (parent instanceof PsiTypeCastExpression) {
                PsiType conjunct;
                PsiType castType;
                PsiTypeElement castTypeElement = ((PsiTypeCastExpression)parent).getCastType();
                PsiType psiType = castType = castTypeElement != null ? castTypeElement.getType() : null;
                if (castType instanceof PsiIntersectionType && (conjunct = LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)castType)) != null) {
                    return conjunct;
                }
                return castType;
            }
            if (parent instanceof PsiVariable) {
                return ((PsiVariable)parent).getType();
            }
            if (parent instanceof PsiAssignmentExpression && expression instanceof PsiExpression && !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression)) {
                PsiExpression lExpression = ((PsiAssignmentExpression)parent).getLExpression();
                return lExpression.getType();
            }
            if (parent instanceof PsiExpressionList) {
                PsiExpressionList expressionList = (PsiExpressionList)parent;
                int lambdaIdx = LambdaUtil.getLambdaIdx(expressionList, expression);
                if (lambdaIdx > -1) {
                    PsiElement gParent = expressionList.getParent();
                    if (gParent instanceof PsiAnonymousClass) {
                        gParent = gParent.getParent();
                    }
                    if (gParent instanceof PsiCall) {
                        PsiParameter[] parameters;
                        int finalLambdaIdx;
                        JavaResolveResult resolveResult;
                        PsiElement resolve;
                        PsiCall contextCall = (PsiCall)gParent;
                        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(contextCall.getArgumentList());
                        if (properties != null && properties.isApplicabilityCheck()) {
                            PsiParameter[] parameters2 = properties.getMethod().getParameterList().getParameters();
                            int finalLambdaIdx2 = LambdaUtil.adjustLambdaIdx(lambdaIdx, properties.getMethod(), parameters2);
                            if (finalLambdaIdx2 < parameters2.length) {
                                return properties.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx2]));
                            }
                        }
                        if ((resolve = (resolveResult = properties != null ? properties.getInfo() : contextCall.resolveMethodGenerics()).getElement()) instanceof PsiMethod && (finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)resolve, parameters = ((PsiMethod)resolve).getParameterList().getParameters())) < parameters.length) {
                            if (!tryToSubstitute) {
                                return LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]);
                            }
                            return (PsiType)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)expression, !MethodCandidateInfo.isOverloadCheck(), (Computable)new Computable<PsiType>(){

                                public PsiType compute() {
                                    return resolveResult.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]));
                                }
                            });
                        }
                        return null;
                    }
                }
            } else if (parent instanceof PsiReturnStatement) {
                Object gParent = PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class, PsiMethod.class);
                if (gParent instanceof PsiLambdaExpression) {
                    return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)gParent);
                }
                if (gParent instanceof PsiMethod) {
                    return ((PsiMethod)gParent).getReturnType();
                }
            } else if (parent instanceof PsiLambdaExpression) {
                return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)parent);
            }
        }
        return null;
    }

    @Nullable
    private static PsiType extractFunctionalConjunct(PsiIntersectionType type) {
        PsiType conjunct = null;
        for (PsiType conjunctType : type.getConjuncts()) {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(conjunctType);
            if (interfaceMethod == null) continue;
            if (conjunct != null && !conjunct.equals(conjunctType)) {
                return null;
            }
            conjunct = conjunctType;
        }
        return conjunct;
    }

    private static PsiType getFunctionalInterfaceTypeByContainingLambda(@NotNull PsiLambdaExpression parentLambda) {
        if (parentLambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLambda", "com/intellij/psi/LambdaUtil", "getFunctionalInterfaceTypeByContainingLambda"));
        }
        PsiType parentInterfaceType = parentLambda.getFunctionalInterfaceType();
        return parentInterfaceType != null ? LambdaUtil.getFunctionalInterfaceReturnType(parentInterfaceType) : null;
    }

    private static int adjustLambdaIdx(int lambdaIdx, PsiMethod resolve, PsiParameter[] parameters) {
        int finalLambdaIdx = resolve.isVarArgs() && lambdaIdx >= parameters.length ? parameters.length - 1 : lambdaIdx;
        return finalLambdaIdx;
    }

    private static PsiType getNormalizedType(PsiParameter parameter) {
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)type).getComponentType();
        }
        return type;
    }

    public static boolean notInferredType(PsiType typeByExpression) {
        return typeByExpression instanceof PsiMethodReferenceType || typeByExpression instanceof PsiLambdaExpressionType || typeByExpression instanceof PsiLambdaParameterType;
    }

    public static boolean isLambdaReturnExpression(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof PsiLambdaExpression || parent instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class, true, PsiMethod.class) != null;
    }

    public static PsiReturnStatement[] getReturnStatements(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        return body instanceof PsiCodeBlock ? PsiUtil.findReturnStatements((PsiCodeBlock)body) : PsiReturnStatement.EMPTY_ARRAY;
    }

    public static List<PsiExpression> getReturnExpressions(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            return Collections.singletonList((PsiExpression)body);
        }
        ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
        for (PsiReturnStatement returnStatement : LambdaUtil.getReturnStatements(lambdaExpression)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            result.add(returnValue);
        }
        return result;
    }

    public static boolean isValidQualifier4InterfaceStaticMethodCall(@NotNull PsiMethod method, @NotNull PsiReferenceExpression methodReferenceExpression, @Nullable PsiElement scope, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        return LambdaUtil.getInvalidQualifier4StaticInterfaceMethodMessage(method, methodReferenceExpression, scope, languageLevel) == null;
    }

    @Nullable
    public static String getInvalidQualifier4StaticInterfaceMethodMessage(@NotNull PsiMethod method, @NotNull PsiReferenceExpression methodReferenceExpression, @Nullable PsiElement scope, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
            if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                return "Static interface method invocations are not supported at this language level";
            }
            if (qualifierExpression == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor(containingClass, methodReferenceExpression, true)) || qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() == containingClass) {
                return null;
            }
            return "Static method may be invoked on containing interface class only";
        }
        return null;
    }

    public static boolean isExpressionStatementExpression(PsiElement body) {
        return body instanceof PsiAssignmentExpression || body instanceof PsiPrefixExpression && (((PsiPrefixExpression)body).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiPrefixExpression)body).getOperationTokenType() == JavaTokenType.MINUSMINUS) || body instanceof PsiPostfixExpression || body instanceof PsiCallExpression || body instanceof PsiReferenceExpression && !body.isPhysical();
    }

    public static PsiExpression extractSingleExpressionFromBody(PsiElement body) {
        PsiExpression expression = null;
        if (body instanceof PsiExpression) {
            expression = (PsiExpression)body;
        } else if (body instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length == 1) {
                if (statements[0] instanceof PsiReturnStatement) {
                    expression = ((PsiReturnStatement)statements[0]).getReturnValue();
                } else if (statements[0] instanceof PsiExpressionStatement) {
                    expression = ((PsiExpressionStatement)statements[0]).getExpression();
                } else if (statements[0] instanceof PsiBlockStatement) {
                    return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)statements[0]).getCodeBlock());
                }
            }
        } else {
            if (body instanceof PsiBlockStatement) {
                return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)body).getCodeBlock());
            }
            if (body instanceof PsiExpressionStatement) {
                expression = ((PsiExpressionStatement)body).getExpression();
            }
        }
        return expression;
    }

    public static boolean isPotentiallyCompatibleWithTypeParameter(PsiFunctionalExpression expression, PsiExpressionList argsList, PsiMethod method) {
        PsiParameter[] parameters;
        PsiParameter lambdaParameter;
        PsiClass paramClass;
        PsiCallExpression callExpression;
        if (!(Registry.is((String)"JDK8042508.bug.fixed", (boolean)false) || (callExpression = PsiTreeUtil.getParentOfType((PsiElement)argsList, PsiCallExpression.class)) != null && callExpression.getTypeArguments().length <= 0)) {
            return false;
        }
        int lambdaIdx = LambdaUtil.getLambdaIdx(argsList, expression);
        return lambdaIdx >= 0 && (paramClass = PsiUtil.resolveClassInType((lambdaParameter = (parameters = method.getParameterList().getParameters())[Math.min(lambdaIdx, parameters.length - 1)]).getType())) instanceof PsiTypeParameter && ((PsiTypeParameter)paramClass).getOwner() == method;
    }

    @NotNull
    public static Map<PsiElement, PsiType> getFunctionalTypeMap() {
        HashMap map = ourFunctionTypes.get();
        if (map == null) {
            map = new HashMap();
            ourFunctionTypes.set((Map<PsiElement, PsiType>)map);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LambdaUtil", "getFunctionalTypeMap"));
        }
        return hashMap;
    }

    public static String checkReturnTypeCompatible(PsiLambdaExpression lambdaExpression, PsiType functionalInterfaceReturnType) {
        if (functionalInterfaceReturnType == PsiType.VOID) {
            PsiElement body = lambdaExpression.getBody();
            if (body instanceof PsiCodeBlock) {
                if (!LambdaUtil.getReturnExpressions(lambdaExpression).isEmpty()) {
                    return "Unexpected return value";
                }
            } else if (body instanceof PsiExpression) {
                PsiType type = ((PsiExpression)body).getType();
                try {
                    if (!PsiUtil.isStatement(JavaPsiFacade.getElementFactory(body.getProject()).createStatementFromText(body.getText(), body))) {
                        return "Bad return type in lambda expression: " + (type == PsiType.NULL || type == null ? "<null>" : type.getPresentableText()) + " cannot be converted to void";
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {}
            }
        } else if (functionalInterfaceReturnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (final PsiExpression expression : returnExpressions) {
                PsiType expressionType = (PsiType)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)expression, true, (Computable)new Computable<PsiType>(){

                    public PsiType compute() {
                        return expression.getType();
                    }
                });
                if (expressionType == null || functionalInterfaceReturnType.isAssignableFrom(expressionType)) continue;
                return "Bad return type in lambda expression: " + expressionType.getPresentableText() + " cannot be converted to " + functionalInterfaceReturnType.getPresentableText();
            }
            if (LambdaUtil.getReturnStatements(lambdaExpression).length > returnExpressions.size() || returnExpressions.isEmpty() && !lambdaExpression.isVoidCompatible()) {
                return "Missing return value";
            }
        }
        return null;
    }

    public static class TypeParamsChecker
    extends PsiTypeVisitor<Boolean> {
        private PsiMethod myMethod;
        private final PsiClass myClass;
        public final Set<PsiTypeParameter> myUsedTypeParams = new HashSet<PsiTypeParameter>();

        public TypeParamsChecker(PsiElement expression, PsiClass aClass) {
            PsiElement gParent;
            PsiElement parent;
            this.myClass = aClass;
            PsiElement psiElement = parent = expression != null ? expression.getParent() : null;
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCall) {
                MethodCandidateInfo.CurrentCandidateProperties pair = MethodCandidateInfo.getCurrentMethod(parent);
                PsiMethod psiMethod = this.myMethod = pair != null ? pair.getMethod() : null;
                if (this.myMethod == null) {
                    this.myMethod = ((PsiCall)gParent).resolveMethod();
                }
                if (this.myMethod != null && PsiTreeUtil.isAncestor(this.myMethod, expression, false)) {
                    this.myMethod = null;
                }
            }
        }

        public boolean startedInference() {
            return this.myMethod != null;
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiTypeParameter typeParameter;
            boolean used = false;
            for (PsiType paramType : classType.getParameters()) {
                Boolean paramAccepted = paramType.accept(this);
                used |= paramAccepted != null && paramAccepted != false;
            }
            PsiClass resolve = classType.resolve();
            if (resolve instanceof PsiTypeParameter && this.check(typeParameter = (PsiTypeParameter)resolve)) {
                this.myUsedTypeParams.add(typeParameter);
                return true;
            }
            return used;
        }

        @Override
        @Nullable
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                return bound.accept(this);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return this.visitWildcardType(capturedWildcardType.getWildcard());
        }

        @Override
        @Nullable
        public Boolean visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitType(PsiType type) {
            return false;
        }

        private boolean check(PsiTypeParameter check) {
            PsiTypeParameterListOwner owner = check.getOwner();
            if (owner == this.myMethod) {
                return true;
            }
            return owner == this.myClass;
        }

        public boolean used(PsiTypeParameter ... parameters) {
            for (PsiTypeParameter parameter : parameters) {
                if (!this.myUsedTypeParams.contains(parameter)) continue;
                return true;
            }
            return false;
        }
    }
}

