/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class JUnitDevKitPatcher
extends JUnitPatcher {
    public static final String JAVA_SYSTEM_CLASS_LOADER_PROPERTY = "java.system.class.loader";

    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        File sandboxHome;
        String id;
        if (module != null && PsiUtil.isIdeaProject(module.getProject()) && !javaParameters.getVMParametersList().hasParameter(JAVA_SYSTEM_CLASS_LOADER_PROPERTY) && JavaPsiFacade.getInstance((Project)module.getProject()).findClass(UrlClassLoader.class.getName(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null) {
            javaParameters.getVMParametersList().add("-Djava.system.class.loader=" + UrlClassLoader.class.getName());
        }
        Sdk jdk = javaParameters.getJdk();
        if ((jdk = IdeaJdk.findIdeaJdk(jdk)) == null) {
            return;
        }
        String libPath = jdk.getHomePath() + File.separator + "lib";
        ParametersList vm = javaParameters.getVMParametersList();
        vm.add("-Xbootclasspath/a:" + libPath + File.separator + "boot.jar");
        if (!vm.hasProperty("idea.load.plugins.id") && module != null && PluginModuleType.isOfType(module) && (id = DescriptorUtil.getPluginId(module)) != null) {
            vm.defineProperty("idea.load.plugins.id", id);
        }
        if ((sandboxHome = JUnitDevKitPatcher.getSandboxPath(jdk)) != null) {
            if (!vm.hasProperty("idea.home.path")) {
                File homeDir = new File(sandboxHome, "test");
                FileUtil.createDirectory((File)homeDir);
                vm.defineProperty("idea.home.path", homeDir.getAbsolutePath());
            }
            if (!vm.hasProperty("idea.plugins.path")) {
                vm.defineProperty("idea.plugins.path", new File(sandboxHome, "plugins").getAbsolutePath());
            }
        }
        javaParameters.getClassPath().addFirst(libPath + File.separator + "idea.jar");
        javaParameters.getClassPath().addFirst(libPath + File.separator + "resources.jar");
        javaParameters.getClassPath().addFirst(((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk));
    }

    @Nullable
    private static File getSandboxPath(Sdk jdk) {
        String sandboxHome = ((Sandbox)jdk.getSdkAdditionalData()).getSandboxHome();
        if (sandboxHome != null) {
            try {
                return new File(sandboxHome).getCanonicalFile();
            }
            catch (IOException e) {
                return new File(sandboxHome).getAbsoluteFile();
            }
        }
        return null;
    }
}

