/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import org.jetbrains.plugins.groovy.console.GroovyConsole;

public class GrExecuteCommandAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (project == null || editor == null || virtualFile == null) {
            return;
        }
        Document document = editor.getDocument();
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode((Editor)editor);
        final String command = selectedRange.isEmpty() ? document.getText() : document.getText(selectedRange);
        GroovyConsole existingConsole = (GroovyConsole)virtualFile.getUserData(GroovyConsole.GROOVY_CONSOLE);
        if (existingConsole == null) {
            GroovyConsole.getOrCreateConsole(project, virtualFile, new Consumer<GroovyConsole>(){

                public void consume(GroovyConsole console) {
                    console.execute(command);
                }
            });
        } else {
            existingConsole.execute(command);
        }
    }
}

