/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.shell.GroovyShellConfig;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class DefaultGroovyShellRunner
extends GroovyShellConfig {
    @Override
    @NotNull
    public String getWorkingDirectory(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner", "getWorkingDirectory"));
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        String string = contentRoots[0].getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner", "getWorkingDirectory"));
        }
        return string;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner", "createJavaParameters"));
        }
        JavaParameters res = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(res, module, "org.codehaus.groovy.tools.shell.Main", false, true);
        res.setWorkingDirectory(this.getWorkingDirectory(module));
        JavaParameters javaParameters = res;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner", "createJavaParameters"));
        }
        return javaParameters;
    }

    @Override
    public boolean canRun(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner", "canRun"));
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return contentRoots.length > 0 && DefaultGroovyShellRunner.hasGroovyWithNeededJars(module);
    }

    @Override
    @NotNull
    public String getVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner", "getVersion"));
        }
        String homePath = LibrariesUtil.getGroovyHomePath(module);
        assert (homePath != null);
        String version = GroovyConfigUtils.getInstance().getSDKVersion(homePath);
        String string = version == "undefined" ? "" : "Groovy " + version;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/shell/DefaultGroovyShellRunner", "getVersion"));
        }
        return string;
    }

    public static boolean hasGroovyWithNeededJars(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return (facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null) && facade.findClass("groovy.ui.GroovyMain", scope) != null && facade.findClass("org.fusesource.jansi.AnsiConsole", scope) != null;
    }

    @Override
    public boolean isSuitableModule(Module module) {
        return super.isSuitableModule(module) && DefaultGroovyShellRunner.hasGroovyWithNeededJars(module);
    }

    @Override
    public String getTitle() {
        return "Groovy Shell";
    }
}

