/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.plugins.groovy.shell.GroovyShellConfig;
import org.jetbrains.plugins.groovy.shell.GroovyShellRunnerImpl;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public abstract class GroovyShellActionBase
extends AnAction {
    private final GroovyShellConfig myConfig;
    private final Condition<Module> APPLICABLE_MODULE = new Condition<Module>(){

        public boolean value(Module module) {
            return GroovyShellActionBase.this.myConfig.isSuitableModule(module);
        }
    };
    private final Function<Module, String> VERSION_PROVIDER = new Function<Module, String>(){

        public String fun(Module module) {
            return GroovyShellActionBase.this.myConfig.getVersion(module);
        }
    };
    private final Consumer<Module> RUNNER = new Consumer<Module>(){

        public void consume(Module module) {
            GroovyShellRunnerImpl.doRunShell(GroovyShellActionBase.this.myConfig, module);
        }
    };

    public GroovyShellActionBase(GroovyShellConfig runner) {
        this.myConfig = runner;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = project != null && !ModuleChooserUtil.getGroovyCompatibleModules(project, this.APPLICABLE_MODULE).isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        ModuleChooserUtil.selectModule(project, this.APPLICABLE_MODULE, this.VERSION_PROVIDER, this.RUNNER);
    }
}

