/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.Variant;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidRootUtil");
    @NonNls
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "default.properties";

    private AndroidRootUtil() {
    }

    @Deprecated
    @Nullable
    public static VirtualFile getManifestFile(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getManifestFile"));
        }
        if (facet.isGradleProject()) {
            return facet.getMainIdeaSourceProvider().getManifestFile();
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
    }

    @Nullable
    public static VirtualFile getPrimaryManifestFile(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getPrimaryManifestFile"));
        }
        return facet.getMainIdeaSourceProvider().getManifestFile();
    }

    @Nullable
    public static VirtualFile getCustomManifestFileForCompiler(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getCustomManifestFileForCompiler"));
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().CUSTOM_COMPILER_MANIFEST, false);
    }

    @Nullable
    public static VirtualFile getManifestFileForCompiler(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getManifestFileForCompiler"));
        }
        return facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST ? AndroidRootUtil.getCustomManifestFileForCompiler(facet) : AndroidRootUtil.getPrimaryManifestFile(facet);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getResourceDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getResourceDir"));
        }
        return facet.getPrimaryResourceDir();
    }

    @Nullable
    private static String suggestResourceDirPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "suggestResourceDirPath"));
        }
        Module module = facet.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length == 0) {
            return null;
        }
        VirtualFile root = contentRoots[0];
        if (contentRoots.length > 1) {
            String moduleFileParentDirPath = FileUtil.toSystemIndependentName((String)new File(module.getModuleFilePath()).getParent());
            VirtualFile moduleFileParentDir = LocalFileSystem.getInstance().findFileByPath(moduleFileParentDirPath);
            if (moduleFileParentDir != null) {
                for (VirtualFile contentRoot : contentRoots) {
                    if (!Comparing.equal((Object)contentRoot, (Object)moduleFileParentDir)) continue;
                    root = contentRoot;
                }
            }
        }
        return root.getPath() + facet.getProperties().RES_FOLDER_RELATIVE_PATH;
    }

    @Nullable
    public static String getResourceDirPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getResourceDirPath"));
        }
        VirtualFile resourceDir = AndroidRootUtil.getResourceDir(facet);
        return resourceDir != null ? resourceDir.getPath() : AndroidRootUtil.suggestResourceDirPath(facet);
    }

    @Nullable
    public static VirtualFile getFileByRelativeModulePath(Module module, String relativePath, boolean lookInContentRoot) {
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        String moduleDirPath = new File(module.getModuleFilePath()).getParent();
        if (moduleDirPath != null) {
            String absPath = FileUtil.toSystemIndependentName((String)(moduleDirPath + relativePath));
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(absPath);
            if (file != null) {
                return file;
            }
        }
        if (lookInContentRoot) {
            for (VirtualFile contentRoot : contentRoots) {
                String absPath = FileUtil.toSystemIndependentName((String)(contentRoot.getPath() + relativePath));
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(absPath);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getAssetsDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getAssetsDir"));
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().ASSETS_FOLDER_RELATIVE_PATH, false);
    }

    @Nullable
    public static VirtualFile getLibsDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getLibsDir"));
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().LIBS_FOLDER_RELATIVE_PATH, false);
    }

    @Nullable
    public static VirtualFile getAidlGenDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getAidlGenDir"));
        }
        String genPath = AndroidRootUtil.getAidlGenSourceRootPath(facet);
        return genPath != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Nullable
    public static VirtualFile getAaptGenDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getAaptGenDir"));
        }
        String genPath = AndroidRootUtil.getAptGenSourceRootPath(facet);
        return genPath != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Nullable
    public static VirtualFile getRenderscriptGenDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getRenderscriptGenDir"));
        }
        String path = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet);
        return path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    @Nullable
    public static VirtualFile getBuildconfigGenDir(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getBuildconfigGenDir"));
        }
        String path = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet);
        return path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    @Nullable
    public static VirtualFile getStandardGenDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidRootUtil", "getStandardGenDir"));
        }
        return AndroidRootUtil.getFileByRelativeModulePath(module, "/gen", false);
    }

    private static void collectClassFilesAndJars(@NotNull VirtualFile root, @NotNull Set<VirtualFile> result, @NotNull Set<VirtualFile> visited) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/android/facet/AndroidRootUtil", "collectClassFilesAndJars"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/facet/AndroidRootUtil", "collectClassFilesAndJars"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/android/facet/AndroidRootUtil", "collectClassFilesAndJars"));
        }
        if (!visited.add(root)) {
            return;
        }
        for (VirtualFile child : root.getChildren()) {
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                AndroidRootUtil.collectClassFilesAndJars(child, result, visited);
                continue;
            }
            if (!"jar".equals(child.getExtension()) && !"class".equals(child.getExtension())) continue;
            if (child.getFileSystem() instanceof JarFileSystem) {
                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(child);
                if (localFile == null) continue;
                result.add(localFile);
                continue;
            }
            result.add(child);
        }
    }

    private static void fillExternalLibrariesAndModules(final Module module, final Set<VirtualFile> outputDirs, final @Nullable Set<VirtualFile> libraries, final Set<Module> visited, final boolean exportedLibrariesOnly, final boolean recursive) {
        if (!visited.add(module)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
                for (OrderEntry entry : manager.getOrderEntries()) {
                    Module depModule;
                    if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE) continue;
                    if (libraries != null && entry instanceof LibraryOrderEntry) {
                        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                        Library library = libraryOrderEntry.getLibrary();
                        if (library == null || exportedLibrariesOnly && !libraryOrderEntry.isExported()) continue;
                        for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                            if (!file.exists()) continue;
                            if (file.getFileType() instanceof ArchiveFileType) {
                                if (file.getFileSystem() instanceof JarFileSystem) {
                                    VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
                                    if (localFile == null) continue;
                                    libraries.add(localFile);
                                    continue;
                                }
                                libraries.add(file);
                                continue;
                            }
                            if (!file.isDirectory() || file.getFileSystem() instanceof JarFileSystem) continue;
                            AndroidRootUtil.collectClassFilesAndJars(file, libraries, new HashSet());
                        }
                        continue;
                    }
                    if (!(entry instanceof ModuleOrderEntry) || (depModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                    AndroidFacet facet = AndroidFacet.getInstance(depModule);
                    boolean libraryProject = facet != null && facet.isLibraryProject();
                    CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)depModule);
                    if (extension != null) {
                        VirtualFile classDir = extension.getCompilerOutputPath();
                        if (libraryProject) {
                            VirtualFile packedClassesJar;
                            VirtualFile tmpArtifactsDir = AndroidDexCompiler.getOutputDirectoryForDex(depModule);
                            if (tmpArtifactsDir != null && (packedClassesJar = tmpArtifactsDir.findChild("classes.jar")) != null) {
                                outputDirs.add(packedClassesJar);
                            }
                        } else if (facet == null && !outputDirs.contains(classDir) && classDir != null && classDir.exists()) {
                            outputDirs.add(classDir);
                        }
                    }
                    if (!recursive) continue;
                    AndroidRootUtil.fillExternalLibrariesAndModules(depModule, outputDirs, libraries, visited, !libraryProject || exportedLibrariesOnly, recursive);
                }
            }
        });
    }

    @NotNull
    public static List<VirtualFile> getExternalLibraries(Module module) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        OrderedSet libs = new OrderedSet();
        boolean recursive = !AndroidMavenUtil.isMavenizedModule(module);
        AndroidRootUtil.fillExternalLibrariesAndModules(module, files, (Set<VirtualFile>)libs, new HashSet<Module>(), false, recursive);
        AndroidRootUtil.addAnnotationsJar(module, (OrderedSet<VirtualFile>)libs);
        OrderedSet orderedSet = libs;
        if (orderedSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidRootUtil", "getExternalLibraries"));
        }
        return orderedSet;
    }

    private static void addAnnotationsJar(Module module, OrderedSet<VirtualFile> libs) {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null || !AndroidSdkUtils.isAndroidSdk(sdk)) {
            return;
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath == null) {
            return;
        }
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
        if (data == null) {
            return;
        }
        AndroidPlatform platform = data.getAndroidPlatform();
        if (platform != null && platform.needToAddAnnotationsJarToClasspath()) {
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkHomePath) + "/tools/support/annotations.jar";
            VirtualFile annotationsJar = LocalFileSystem.getInstance().findFileByPath(annotationsJarPath);
            if (annotationsJar != null) {
                libs.add((Object)annotationsJar);
            }
        }
    }

    @NotNull
    public static Set<VirtualFile> getDependentModules(Module module, VirtualFile moduleOutputDir) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        AndroidRootUtil.fillExternalLibrariesAndModules(module, files, null, new HashSet<Module>(), false, true);
        files.remove(moduleOutputDir);
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidRootUtil", "getDependentModules"));
        }
        return hashSet;
    }

    @NotNull
    public static VirtualFile[] getResourceOverlayDirs(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getResourceOverlayDirs"));
        }
        List overlayFolders = facet.getProperties().RES_OVERLAY_FOLDERS;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String overlayFolder : overlayFolders) {
            VirtualFile overlayDir = AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), overlayFolder, true);
            if (overlayDir == null) continue;
            result.add(overlayDir);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidRootUtil", "getResourceOverlayDirs"));
        }
        return virtualFileArray;
    }

    @Nullable
    public static String getModuleDirPath(Module module) {
        String moduleFilePath = module.getModuleFilePath();
        String moduleDirPath = new File(moduleFilePath).getParent();
        if (moduleDirPath != null) {
            moduleDirPath = FileUtil.toSystemIndependentName((String)moduleDirPath);
        }
        return moduleDirPath;
    }

    @Nullable
    public static String getRenderscriptGenSourceRootPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getRenderscriptGenSourceRootPath"));
        }
        return AndroidRootUtil.getAidlGenSourceRootPath(facet);
    }

    @Nullable
    public static String getBuildconfigGenSourceRootPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getBuildconfigGenSourceRootPath"));
        }
        return AndroidRootUtil.getAptGenSourceRootPath(facet);
    }

    @Nullable
    public static VirtualFile getMainContentRoot(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getMainContentRoot"));
        }
        Module module = facet.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length == 0) {
            return null;
        }
        if (contentRoots.length == 1) {
            return contentRoots[0];
        }
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
        if (manifestFile != null) {
            for (VirtualFile root : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)manifestFile, (boolean)true)) continue;
                return root;
            }
        }
        return contentRoots[0];
    }

    @Nullable
    public static Pair<PropertiesFile, VirtualFile> findPropertyFile(@NotNull Module module, @NotNull String propertyFileName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidRootUtil", "findPropertyFile"));
        }
        if (propertyFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyFileName", "org/jetbrains/android/facet/AndroidRootUtil", "findPropertyFile"));
        }
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PsiFile psiFile;
            VirtualFile vFile = contentRoot.findChild(propertyFileName);
            if (vFile == null || !((psiFile = AndroidPsiUtils.getPsiFileSafely(module.getProject(), vFile)) instanceof PropertiesFile)) continue;
            return Pair.create((Object)((PropertiesFile)psiFile), (Object)vFile);
        }
        return null;
    }

    @Nullable
    public static Pair<Properties, VirtualFile> readPropertyFile(@NotNull Module module, @NotNull String propertyFileName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidRootUtil", "readPropertyFile"));
        }
        if (propertyFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyFileName", "org/jetbrains/android/facet/AndroidRootUtil", "readPropertyFile"));
        }
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            Pair<Properties, VirtualFile> result = AndroidRootUtil.readPropertyFile(contentRoot, propertyFileName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static Pair<Properties, VirtualFile> readProjectPropertyFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidRootUtil", "readProjectPropertyFile"));
        }
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(module, "project.properties");
        return pair != null ? pair : AndroidRootUtil.readPropertyFile(module, DEFAULT_PROPERTIES_FILE_NAME);
    }

    @Nullable
    private static Pair<Properties, VirtualFile> readPropertyFile(@NotNull VirtualFile contentRoot, @NotNull String propertyFileName) {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "org/jetbrains/android/facet/AndroidRootUtil", "readPropertyFile"));
        }
        if (propertyFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyFileName", "org/jetbrains/android/facet/AndroidRootUtil", "readPropertyFile"));
        }
        VirtualFile vFile = contentRoot.findChild(propertyFileName);
        if (vFile != null) {
            try {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
                Properties properties = PropertiesUtil.getProperties(file);
                return new Pair((Object)properties, (Object)vFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static Pair<Properties, VirtualFile> readProjectPropertyFile(@NotNull VirtualFile contentRoot) {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "org/jetbrains/android/facet/AndroidRootUtil", "readProjectPropertyFile"));
        }
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(contentRoot, "project.properties");
        return pair != null ? pair : AndroidRootUtil.readPropertyFile(contentRoot, DEFAULT_PROPERTIES_FILE_NAME);
    }

    @Nullable
    public static Pair<String, VirtualFile> getPropertyValue(@NotNull Module module, @NotNull String propertyFileName, @NotNull String propertyKey) {
        String value;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidRootUtil", "getPropertyValue"));
        }
        if (propertyFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyFileName", "org/jetbrains/android/facet/AndroidRootUtil", "getPropertyValue"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "org/jetbrains/android/facet/AndroidRootUtil", "getPropertyValue"));
        }
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(module, propertyFileName);
        if (pair != null && (value = ((Properties)pair.first).getProperty(propertyKey)) != null) {
            return Pair.create((Object)value, (Object)pair.second);
        }
        return null;
    }

    @Nullable
    public static Pair<String, VirtualFile> getProjectPropertyValue(@NotNull Module module, @NotNull String propertyName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidRootUtil", "getProjectPropertyValue"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/android/facet/AndroidRootUtil", "getProjectPropertyValue"));
        }
        Pair<String, VirtualFile> result = AndroidRootUtil.getPropertyValue(module, "project.properties", propertyName);
        return result != null ? result : AndroidRootUtil.getPropertyValue(module, DEFAULT_PROPERTIES_FILE_NAME, propertyName);
    }

    @Nullable
    public static String getAptGenSourceRootPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getAptGenSourceRootPath"));
        }
        String path = facet.getProperties().GEN_FOLDER_RELATIVE_PATH_APT;
        if (path.length() == 0) {
            return null;
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? moduleDirPath + path : null;
    }

    @Nullable
    public static String getAidlGenSourceRootPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getAidlGenSourceRootPath"));
        }
        String path = facet.getProperties().GEN_FOLDER_RELATIVE_PATH_AIDL;
        if (path.length() == 0) {
            return null;
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? moduleDirPath + path : null;
    }

    @Nullable
    public static String getApkPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidRootUtil", "getApkPath"));
        }
        IdeaAndroidProject ideaAndroidProject = facet.getIdeaAndroidProject();
        if (ideaAndroidProject != null) {
            Variant selectedVariant = ideaAndroidProject.getSelectedVariant();
            AndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
            AndroidArtifactOutput output = GradleUtil.getOutput(mainArtifact);
            File outputFile = output.getMainOutputFile().getOutputFile();
            return outputFile.getAbsolutePath();
        }
        String path = facet.getProperties().APK_PATH;
        if (path.length() == 0) {
            return AndroidCompileUtil.getOutputPackage(facet.getModule());
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? FileUtil.toSystemDependentName((String)(moduleDirPath + path)) : null;
    }

    @Nullable
    public static String getPathRelativeToModuleDir(@NotNull Module module, @NotNull String path) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidRootUtil", "getPathRelativeToModuleDir"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/android/facet/AndroidRootUtil", "getPathRelativeToModuleDir"));
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
        if (moduleDirPath == null) {
            return null;
        }
        if (moduleDirPath.equals(path)) {
            return "";
        }
        return FileUtil.getRelativePath((String)moduleDirPath, (String)path, (char)'/');
    }
}

