/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;

public class MavenRehighlighter
extends MavenSimpleProjectComponent {
    private MergingUpdateQueue myQueue;

    protected MavenRehighlighter(Project project) {
        super(project);
    }

    public void initComponent() {
        this.myQueue = new MergingUpdateQueue(((Object)((Object)this)).getClass().getSimpleName(), 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject, null, true);
        this.myQueue.setPassThrough(false);
        MavenProjectsManager m = MavenProjectsManager.getInstance(this.myProject);
        m.addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject);
            }

            @Override
            public void projectsScheduled() {
            }

            @Override
            public void importAndResolveScheduled() {
            }
        });
        m.addProjectsTreeListener(new MavenProjectsTree.ListenerAdapter(){

            @Override
            public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
                for (Pair<MavenProject, MavenProjectChanges> each : updated) {
                    MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject, (MavenProject)each.first);
                }
            }

            @Override
            public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject, (MavenProject)projectWithChanges.first);
            }

            @Override
            public void pluginsResolved(MavenProject project) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject, project);
            }

            @Override
            public void foldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject, (MavenProject)projectWithChanges.first);
            }

            @Override
            public void artifactsDownloaded(MavenProject project) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject, project);
            }
        });
    }

    public static void rehighlight(Project project) {
        MavenRehighlighter.rehighlight(project, null);
    }

    public static void rehighlight(Project project, MavenProject mavenProject) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            if (project.isDisposed()) {
                return;
            }
            ((MavenRehighlighter)((Object)ServiceManager.getService((Project)project, MavenRehighlighter.class))).myQueue.queue((Update)new MyUpdate(project, mavenProject));
        }
        finally {
            accessToken.finish();
        }
    }

    private static class MyUpdate
    extends Update {
        private final Project myProject;
        private final MavenProject myMavenProject;

        public MyUpdate(Project project, MavenProject mavenProject) {
            super((Object)project);
            this.myProject = project;
            this.myMavenProject = mavenProject;
        }

        public void run() {
            if (this.myMavenProject == null) {
                for (VirtualFile each : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    this.doRehighlightMavenFile(each);
                }
            } else {
                this.doRehighlightMavenFile(this.myMavenProject.getFile());
            }
        }

        private void doRehighlightMavenFile(VirtualFile file) {
            Document doc = FileDocumentManager.getInstance().getCachedDocument(file);
            if (doc == null) {
                return;
            }
            PsiFile psi = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(doc);
            if (psi == null) {
                return;
            }
            if (!MavenDomUtil.isMavenFile(psi)) {
                return;
            }
            DaemonCodeAnalyzer daemon = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            daemon.restart(psi);
        }

        public boolean canEat(Update update) {
            return this.myMavenProject == null || this.myMavenProject == ((MyUpdate)update).myMavenProject;
        }
    }
}

