/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import icons.MavenIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenDefaultModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenUIModifiableModelsProvider;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.FileFinder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectBuilder
extends ProjectImportBuilder<MavenProject> {
    private Parameters myParameters;

    @NotNull
    public String getName() {
        String string = ProjectBundle.message("maven.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/wizards/MavenProjectBuilder", "getName"));
        }
        return string;
    }

    public Icon getIcon() {
        return MavenIcons.MavenLogo;
    }

    public void cleanup() {
        this.myParameters = null;
        super.cleanup();
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    private Parameters getParameters() {
        if (this.myParameters == null) {
            this.myParameters = new Parameters();
        }
        return this.myParameters;
    }

    public boolean validate(Project current, Project dest) {
        return true;
    }

    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(project).getSettings();
        settings.generalSettings = this.getGeneralSettings();
        settings.importingSettings = this.getImportingSettings();
        String settingsFile = System.getProperty("idea.maven.import.settings.file");
        if (!StringUtil.isEmptyOrSpaces((String)settingsFile)) {
            settings.generalSettings.setUserSettingsFile(settingsFile.trim());
        }
        MavenExplicitProfiles selectedProfiles = this.getSelectedProfiles();
        String enabledProfilesList = System.getProperty("idea.maven.import.enabled.profiles");
        String disabledProfilesList = System.getProperty("idea.maven.import.disabled.profiles");
        if (enabledProfilesList != null || disabledProfilesList != null) {
            selectedProfiles = selectedProfiles.clone();
            this.appendProfilesFromString(selectedProfiles.getEnabledProfiles(), enabledProfilesList);
            this.appendProfilesFromString(selectedProfiles.getDisabledProfiles(), disabledProfilesList);
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        manager.setIgnoredState(this.getParameters().mySelectedProjects, false);
        manager.addManagedFilesWithProfiles(MavenUtil.collectFiles(this.getParameters().mySelectedProjects), selectedProfiles);
        manager.waitForReadingCompletion();
        boolean isFromUI = model != null;
        return manager.importProjects(isFromUI ? new MavenUIModifiableModelsProvider(project, model, (ModulesConfigurator)modulesProvider, artifactModel) : new MavenDefaultModifiableModelsProvider(project));
    }

    private void appendProfilesFromString(Collection<String> selectedProfiles, String profilesList) {
        if (profilesList == null) {
            return;
        }
        for (String profile : StringUtil.split((String)profilesList, (String)",")) {
            String trimmedProfileName = profile.trim();
            if (trimmedProfileName.isEmpty()) continue;
            selectedProfiles.add(trimmedProfileName);
        }
    }

    public boolean setRootDirectory(@Nullable Project projectToUpdate, final String root) throws ConfigurationException {
        this.getParameters().myFiles = null;
        this.getParameters().myProfiles.clear();
        this.getParameters().myActivatedProfiles.clear();
        this.getParameters().myMavenProjectTree = null;
        this.getParameters().myProjectToUpdate = projectToUpdate;
        return MavenProjectBuilder.runConfigurationProcess(ProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                indicator.setText(ProjectBundle.message("maven.locating.files", new Object[0]));
                MavenProjectBuilder.this.getParameters().myImportRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                if (MavenProjectBuilder.this.getParameters().myImportRoot == null) {
                    throw new MavenProcessCanceledException();
                }
                VirtualFile file = MavenProjectBuilder.this.getRootDirectory();
                if (file == null) {
                    throw new MavenProcessCanceledException();
                }
                MavenProjectBuilder.this.getParameters().myFiles = FileFinder.findPomFiles(file.getChildren(), MavenProjectBuilder.this.getImportingSettings().isLookForNested(), indicator, new ArrayList<VirtualFile>());
                MavenProjectBuilder.this.collectProfiles(indicator);
                if (MavenProjectBuilder.this.getParameters().myProfiles.isEmpty()) {
                    MavenProjectBuilder.this.readMavenProjectTree(indicator);
                }
                indicator.setText("");
                indicator.setText2("");
            }
        });
    }

    private void collectProfiles(MavenProgressIndicator process) {
        process.setText(ProjectBundle.message("maven.searching.profiles", new Object[0]));
        LinkedHashSet<String> availableProfiles = new LinkedHashSet<String>();
        LinkedHashSet activatedProfiles = new LinkedHashSet();
        MavenProjectReader reader = new MavenProjectReader();
        MavenGeneralSettings generalSettings = this.getGeneralSettings();
        MavenProjectReaderProjectLocator locator = new MavenProjectReaderProjectLocator(){

            @Override
            public VirtualFile findProjectFile(MavenId coordinates) {
                return null;
            }
        };
        for (VirtualFile f : this.getParameters().myFiles) {
            MavenProject project = new MavenProject(f);
            process.setText2(ProjectBundle.message("maven.reading.pom", f.getPath()));
            project.read(generalSettings, MavenExplicitProfiles.NONE, reader, locator);
            availableProfiles.addAll(project.getProfilesIds());
            activatedProfiles.addAll(project.getActivatedProfilesIds().getEnabledProfiles());
        }
        this.getParameters().myProfiles = new ArrayList(availableProfiles);
        this.getParameters().myActivatedProfiles = new ArrayList(activatedProfiles);
    }

    public List<String> getProfiles() {
        return this.getParameters().myProfiles;
    }

    public List<String> getActivatedProfiles() {
        return this.getParameters().myActivatedProfiles;
    }

    public MavenExplicitProfiles getSelectedProfiles() {
        return this.getParameters().mySelectedProfiles;
    }

    public boolean setSelectedProfiles(MavenExplicitProfiles profiles) {
        this.getParameters().myMavenProjectTree = null;
        this.getParameters().mySelectedProfiles = profiles;
        return MavenProjectBuilder.runConfigurationProcess(ProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                MavenProjectBuilder.this.readMavenProjectTree(indicator);
                indicator.setText2("");
            }
        });
    }

    private static boolean runConfigurationProcess(String message, MavenTask p) {
        try {
            MavenUtil.run(null, message, p);
        }
        catch (MavenProcessCanceledException e) {
            return false;
        }
        return true;
    }

    private void readMavenProjectTree(MavenProgressIndicator process) throws MavenProcessCanceledException {
        MavenProjectsTree tree = new MavenProjectsTree();
        tree.addManagedFilesWithProfiles(this.getParameters().myFiles, this.getParameters().mySelectedProfiles);
        tree.updateAll(false, this.getGeneralSettings(), process);
        this.getParameters().myMavenProjectTree = tree;
        this.getParameters().mySelectedProjects = tree.getRootProjects();
    }

    public List<MavenProject> getList() {
        return this.getParameters().myMavenProjectTree.getRootProjects();
    }

    public void setList(List<MavenProject> projects) {
        this.getParameters().mySelectedProjects = projects;
    }

    public boolean isMarked(MavenProject element) {
        return this.getParameters().mySelectedProjects.contains(element);
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().myOpenModulesConfigurator;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().myOpenModulesConfigurator = on;
    }

    public MavenGeneralSettings getGeneralSettings() {
        if (this.getParameters().myGeneralSettingsCache == null) {
            AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                this.getParameters().myGeneralSettingsCache = this.getDirectProjectsSettings().generalSettings.clone();
            }
            finally {
                accessToken.finish();
            }
        }
        return this.getParameters().myGeneralSettingsCache;
    }

    public MavenImportingSettings getImportingSettings() {
        if (this.getParameters().myImportingSettingsCache == null) {
            AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                this.getParameters().myImportingSettingsCache = this.getDirectProjectsSettings().importingSettings.clone();
            }
            finally {
                accessToken.finish();
            }
        }
        return this.getParameters().myImportingSettingsCache;
    }

    private MavenWorkspaceSettings getDirectProjectsSettings() {
        Project project;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = project = this.isUpdate() ? this.getProjectToUpdate() : null;
        if (project == null || project.isDisposed()) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return MavenWorkspaceSettingsComponent.getInstance(project).getSettings();
    }

    public void setFiles(List<VirtualFile> files) {
        this.getParameters().myFiles = files;
    }

    @Nullable
    public Project getProjectToUpdate() {
        if (this.getParameters().myProjectToUpdate == null) {
            this.getParameters().myProjectToUpdate = MavenProjectBuilder.getCurrentProject();
        }
        return this.getParameters().myProjectToUpdate;
    }

    @Nullable
    public VirtualFile getRootDirectory() {
        if (this.getParameters().myImportRoot == null && this.isUpdate()) {
            Project project = this.getProjectToUpdate();
            this.getParameters().myImportRoot = project != null ? project.getBaseDir() : null;
        }
        return this.getParameters().myImportRoot;
    }

    public String getSuggestedProjectName() {
        List<MavenProject> list = this.getParameters().myMavenProjectTree.getRootProjects();
        if (list.size() == 1) {
            return list.get(0).getMavenId().getArtifactId();
        }
        return null;
    }

    public void setFileToImport(String path) {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        this.getParameters().myImportRoot = file == null || file.isDirectory() ? file : file.getParent();
    }

    private static class Parameters {
        private Project myProjectToUpdate;
        private MavenGeneralSettings myGeneralSettingsCache;
        private MavenImportingSettings myImportingSettingsCache;
        private VirtualFile myImportRoot;
        private List<VirtualFile> myFiles;
        private List<String> myProfiles = new ArrayList<String>();
        private List<String> myActivatedProfiles = new ArrayList<String>();
        private MavenExplicitProfiles mySelectedProfiles = MavenExplicitProfiles.NONE;
        private MavenProjectsTree myMavenProjectTree;
        private List<MavenProject> mySelectedProjects;
        private boolean myOpenModulesConfigurator;

        private Parameters() {
        }
    }
}

