/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManagerState;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ResourceBundleManager", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/resourceBundles.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class ResourceBundleManager
implements PersistentStateComponent<ResourceBundleManagerState> {
    private static final Logger LOG = Logger.getInstance(ResourceBundleManager.class);
    private ResourceBundleManagerState myState = new ResourceBundleManagerState();

    public ResourceBundleManager(PsiManager manager) {
        manager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/ResourceBundleManager$1", "childMoved"));
                }
                PsiElement child = event.getChild();
                if (!(child instanceof PsiFile)) {
                    return;
                }
                final PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)child);
                if (propertiesFile == null) {
                    return;
                }
                final String oldParentUrl = this.getUrl(event.getOldParent());
                if (oldParentUrl == null) {
                    return;
                }
                final String newParentUrl = this.getUrl(event.getNewParent());
                if (newParentUrl == null) {
                    return;
                }
                NotNullLazyValue<Pair<String, String>> oldAndNewUrls = new NotNullLazyValue<Pair<String, String>>(){

                    @NotNull
                    protected Pair<String, String> compute() {
                        String newUrl = propertiesFile.getVirtualFile().getUrl();
                        Pair pair = Pair.create((Object)(oldParentUrl + newUrl.substring(newParentUrl.length())), (Object)newUrl);
                        if (pair == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager$1$1", "compute"));
                        }
                        return pair;
                    }
                };
                if (!ResourceBundleManager.this.myState.getDissociatedFiles().isEmpty() && ResourceBundleManager.this.myState.getDissociatedFiles().remove(((Pair)oldAndNewUrls.getValue()).getFirst())) {
                    ResourceBundleManager.this.myState.getDissociatedFiles().add((String)((Pair)oldAndNewUrls.getValue()).getSecond());
                }
                for (CustomResourceBundleState customResourceBundleState : ResourceBundleManager.this.myState.getCustomResourceBundles()) {
                    if (!customResourceBundleState.getFileUrls().remove(((Pair)oldAndNewUrls.getValue()).getFirst())) continue;
                    customResourceBundleState.getFileUrls().add((String)((Pair)oldAndNewUrls.getValue()).getSecond());
                    break;
                }
            }

            @Nullable
            private String getUrl(PsiElement element) {
                return !(element instanceof PsiDirectory) ? null : ((PsiDirectory)element).getVirtualFile().getUrl();
            }

            public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/ResourceBundleManager$1", "beforeChildRemoval"));
                }
                PsiElement child = event.getChild();
                if (!(child instanceof PsiFile)) {
                    return;
                }
                PropertiesFile file = PropertiesImplUtil.getPropertiesFile((PsiFile)child);
                if (file == null) {
                    return;
                }
                final VirtualFile virtualFile = file.getVirtualFile();
                NotNullLazyValue<String> url = new NotNullLazyValue<String>(){

                    @NotNull
                    protected String compute() {
                        String string = virtualFile.getUrl();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager$1$2", "compute"));
                        }
                        return string;
                    }
                };
                if (!ResourceBundleManager.this.myState.getDissociatedFiles().isEmpty()) {
                    ResourceBundleManager.this.myState.getDissociatedFiles().remove(url.getValue());
                }
                for (CustomResourceBundleState customResourceBundleState : ResourceBundleManager.this.myState.getCustomResourceBundles()) {
                    Set<String> urls = customResourceBundleState.getFileUrls();
                    if (!urls.remove(url.getValue())) continue;
                    if (urls.size() >= 2) break;
                    ResourceBundleManager.this.myState.getCustomResourceBundles().remove(customResourceBundleState);
                    break;
                }
            }
        });
    }

    public static ResourceBundleManager getInstance(Project project) {
        return (ResourceBundleManager)ServiceManager.getService((Project)project, ResourceBundleManager.class);
    }

    @Nullable
    public String getFullName(final @NotNull PropertiesFile propertiesFile) {
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/intellij/lang/properties/ResourceBundleManager", "getFullName"));
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<String>(){

            public String compute() {
                PsiDirectory directory = propertiesFile.getParent();
                String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
                if (packageQualifiedName == null) {
                    return null;
                }
                StringBuilder qName = new StringBuilder(packageQualifiedName);
                if (qName.length() > 0) {
                    qName.append(".");
                }
                qName.append(ResourceBundleManager.this.getBaseName(propertiesFile.getContainingFile()));
                return qName.toString();
            }
        });
    }

    @NotNull
    public String getBaseName(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/ResourceBundleManager", "getBaseName"));
        }
        String string = this.getBaseName(file.getVirtualFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager", "getBaseName"));
        }
        return string;
    }

    @NotNull
    private String getBaseName(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/ResourceBundleManager", "getBaseName"));
        }
        CustomResourceBundleState customResourceBundle = this.getCustomResourceBundleState(file);
        if (customResourceBundle != null) {
            String string = customResourceBundle.getBaseName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager", "getBaseName"));
            }
            return string;
        }
        if (this.isDefaultDissociated(file)) {
            String string = file.getNameWithoutExtension();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager", "getBaseName"));
            }
            return string;
        }
        String string = PropertiesUtil.getDefaultBaseName(file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager", "getBaseName"));
        }
        return string;
    }

    public void dissociateResourceBundle(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/ResourceBundleManager", "dissociateResourceBundle"));
        }
        if (resourceBundle instanceof CustomResourceBundle) {
            CustomResourceBundleState state = this.getCustomResourceBundleState(resourceBundle.getDefaultPropertiesFile().getVirtualFile());
            LOG.assertTrue(state != null);
            this.myState.getCustomResourceBundles().remove(state);
        } else {
            if (EmptyResourceBundle.getInstance() != resourceBundle) {
                ((ResourceBundleImpl)resourceBundle).invalidate();
            }
            for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                VirtualFile file = propertiesFile.getContainingFile().getVirtualFile();
                this.myState.getDissociatedFiles().add(file.getUrl());
            }
        }
    }

    public void combineToResourceBundle(@NotNull List<PropertiesFile> propertiesFiles, String baseName) {
        if (propertiesFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFiles", "com/intellij/lang/properties/ResourceBundleManager", "combineToResourceBundle"));
        }
        this.myState.getCustomResourceBundles().add(new CustomResourceBundleState().addAll(ContainerUtil.map(propertiesFiles, (Function)new Function<PropertiesFile, String>(){

            public String fun(PropertiesFile file) {
                return file.getVirtualFile().getUrl();
            }
        })).setBaseName(baseName));
    }

    @Nullable
    public CustomResourceBundle getCustomResourceBundle(@NotNull PropertiesFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/ResourceBundleManager", "getCustomResourceBundle"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        CustomResourceBundleState state = this.getCustomResourceBundleState(virtualFile);
        return state == null ? null : CustomResourceBundle.fromState(state, file.getProject());
    }

    public boolean isDefaultDissociated(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/properties/ResourceBundleManager", "isDefaultDissociated"));
        }
        if (this.myState.getDissociatedFiles().isEmpty() && this.myState.getCustomResourceBundles().isEmpty()) {
            return false;
        }
        String url = virtualFile.getUrl();
        return this.myState.getDissociatedFiles().contains(url) || this.getCustomResourceBundleState(virtualFile) != null;
    }

    @Nullable
    private String getCustomResourceBundleName(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/properties/ResourceBundleManager", "getCustomResourceBundleName"));
        }
        CustomResourceBundleState customResourceBundle = this.getCustomResourceBundleState(virtualFile);
        return customResourceBundle == null ? null : customResourceBundle.getBaseName();
    }

    @Nullable
    private CustomResourceBundleState getCustomResourceBundleState(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/properties/ResourceBundleManager", "getCustomResourceBundleState"));
        }
        if (this.myState.getCustomResourceBundles().isEmpty()) {
            return null;
        }
        String url = virtualFile.getUrl();
        for (CustomResourceBundleState customResourceBundleState : this.myState.getCustomResourceBundles()) {
            if (!customResourceBundleState.getFileUrls().contains(url)) continue;
            return customResourceBundleState;
        }
        return null;
    }

    @Nullable
    public ResourceBundleManagerState getState() {
        return this.myState.isEmpty() ? null : this.myState;
    }

    public void loadState(ResourceBundleManagerState state) {
        this.myState = state.removeNonExistentFiles();
    }
}

