/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ClassFinder {
    private final List<String> classNameList = new ArrayList<String>();
    private final int startPackageName;

    public ClassFinder(File classPathRoot, String packageRoot) throws IOException {
        this.startPackageName = classPathRoot.getAbsolutePath().length() + 1;
        String directoryOffset = packageRoot.replace('.', File.separatorChar);
        this.findAndStoreTestClasses(new File(classPathRoot, directoryOffset));
    }

    @Nullable
    private String computeClassName(File file) {
        String absPath = file.getAbsolutePath();
        if (absPath.endsWith("Test.class")) {
            return StringUtil.trimEnd((String)absPath.substring(this.startPackageName), (String)".class").replace(File.separatorChar, '.');
        }
        return null;
    }

    private void findAndStoreTestClasses(File current) throws IOException {
        if (current.isDirectory()) {
            for (File file : current.listFiles()) {
                this.findAndStoreTestClasses(file);
            }
        } else {
            ContainerUtil.addIfNotNull(this.classNameList, (Object)this.computeClassName(current));
        }
    }

    public Collection<String> getClasses() {
        return this.classNameList;
    }
}

