/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CustomizableLanguageCodeStylePanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionTableWithPreviewPanel
extends CustomizableLanguageCodeStylePanel {
    protected TreeTable myTreeTable;
    private final JPanel myPanel = new JPanel();
    private final List<Option> myOptions = new ArrayList<Option>();
    private final List<Option> myCustomOptions = new ArrayList<Option>();
    private final Set<String> myAllowedOptions = new THashSet();
    private final Map<String, String> myRenamedFields = new THashMap();
    private boolean myShowAllStandardOptions;
    protected boolean isFirstUpdate = true;
    public final ColumnInfo TITLE = new ColumnInfo("TITLE"){

        public Object valueOf(Object o) {
            if (o instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)o;
                return node.getText();
            }
            return o.toString();
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }
    };
    public final ColumnInfo VALUE = new ColumnInfo("VALUE"){
        private final TableCellEditor myEditor;
        private final TableCellRenderer myRenderer;
        {
            this.myEditor = new MyValueEditor();
            this.myRenderer = new MyValueRenderer();
        }

        public Object valueOf(Object o) {
            if (o instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)o;
                return node.getValue();
            }
            return null;
        }

        public TableCellRenderer getRenderer(Object o) {
            return this.myRenderer;
        }

        public TableCellEditor getEditor(Object item) {
            return this.myEditor;
        }

        public boolean isCellEditable(Object o) {
            return o instanceof MyTreeNode && ((MyTreeNode)o).isEnabled();
        }

        public void setValue(Object o, Object o1) {
            MyTreeNode node = (MyTreeNode)o;
            node.setValue(o1);
        }
    };
    public final ColumnInfo[] COLUMNS = new ColumnInfo[]{this.TITLE, this.VALUE};
    private final TreeCellRenderer myTitleRenderer = new TreeCellRenderer(){
        private final JLabel myLabel = new JLabel();

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$5", "getTreeCellRendererComponent"));
            }
            if (value instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)value;
                this.myLabel.setText(OptionTableWithPreviewPanel.this.getRenamedTitle(node.getKey().field.getName(), node.getText()));
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(node.getKey().groupName == null ? 1 : 0));
                this.myLabel.setEnabled(node.isEnabled());
            } else {
                this.myLabel.setText(OptionTableWithPreviewPanel.this.getRenamedTitle(value.toString(), value.toString()));
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
                this.myLabel.setEnabled(true);
            }
            Color foreground = selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.myLabel.setForeground(foreground);
            JLabel jLabel = this.myLabel;
            if (jLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$5", "getTreeCellRendererComponent"));
            }
            return jLabel;
        }
    };

    public OptionTableWithPreviewPanel(CodeStyleSettings settings) {
        super(settings);
    }

    @Override
    protected void init() {
        super.init();
        this.myPanel.setLayout(new GridBagLayout());
        this.initTables();
        this.myTreeTable = this.createOptionsTree(this.getSettings());
        this.myTreeTable.setBackground(UIUtil.getPanelBackground());
        this.myTreeTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        this.myPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel previewPanel = OptionTableWithPreviewPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.isFirstUpdate = false;
        this.customizeSettings();
    }

    @Override
    protected void resetDefaultNames() {
        this.myRenamedFields.clear();
    }

    public void showAllStandardOptions() {
        this.myShowAllStandardOptions = true;
        for (Option each : this.myOptions) {
            each.setEnabled(true);
        }
        for (Option each : this.myCustomOptions) {
            each.setEnabled(false);
        }
    }

    public void showStandardOptions(String ... optionNames) {
        Collections.addAll(this.myAllowedOptions, optionNames);
        for (Option each : this.myOptions) {
            each.setEnabled(false);
            for (String optionName : optionNames) {
                if (!each.field.getName().equals(optionName)) continue;
                each.setEnabled(true);
            }
        }
        for (Option each : this.myCustomOptions) {
            each.setEnabled(false);
        }
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, Object ... options) {
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName, Object ... options) {
        if (this.isFirstUpdate) {
            Option option = options.length == 2 ? new SelectionOption(settingsClass, fieldName, title, groupName, anchor, anchorFieldName, (String[])options[0], (int[])options[1]) : new BooleanOption(settingsClass, fieldName, title, groupName, anchor, anchorFieldName);
            this.myCustomOptions.add(option);
            option.setEnabled(true);
        } else {
            for (Option each : this.myCustomOptions) {
                if (each.clazz != settingsClass || !each.field.getName().equals(fieldName)) continue;
                each.setEnabled(true);
            }
        }
    }

    public void renameStandardOption(String fieldName, String newTitle) {
        this.myRenamedFields.put(fieldName, newTitle);
    }

    protected TreeTable createOptionsTree(CodeStyleSettings settings) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        THashMap groupsMap = new THashMap();
        List sorted = this.sortOptions(ContainerUtil.concat(this.myOptions, this.myCustomOptions));
        for (Option each : sorted) {
            String groupName;
            if (!this.myCustomOptions.contains(each) && !this.myAllowedOptions.contains(each.field.getName()) && !this.myShowAllStandardOptions) continue;
            String group = each.groupName;
            MyTreeNode newNode = new MyTreeNode(each, each.title, settings);
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)groupsMap.get(group);
            if (groupNode != null) {
                groupNode.add(newNode);
                continue;
            }
            if (group == null) {
                groupName = each.title;
                groupNode = newNode;
            } else {
                groupName = group;
                groupNode = new DefaultMutableTreeNode(groupName);
                groupNode.add(newNode);
            }
            groupsMap.put(groupName, groupNode);
            rootNode.add(groupNode);
        }
        ListTreeTableModel model = new ListTreeTableModel((TreeNode)rootNode, this.COLUMNS);
        TreeTable treeTable = new TreeTable((TreeTableModel)model){

            public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
                TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
                UIUtil.setLineStyleAngled((ClientPropertyHolder)tableRenderer);
                tableRenderer.setRootVisible(false);
                tableRenderer.setShowsRootHandles(true);
                return tableRenderer;
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellRenderer(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellRenderer renderer = OptionTableWithPreviewPanel.this.COLUMNS[column].getRenderer(node);
                return renderer == null ? super.getCellRenderer(row, column) : renderer;
            }

            public TableCellEditor getCellEditor(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellEditor(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellEditor editor = OptionTableWithPreviewPanel.this.COLUMNS[column].getEditor(node);
                return editor == null ? super.getCellEditor(row, column) : editor;
            }
        };
        new TreeTableSpeedSearch(treeTable).setComparator(new SpeedSearchComparator(false));
        treeTable.setRootVisible(false);
        TreeTableTree tree = treeTable.getTree();
        tree.setCellRenderer(this.myTitleRenderer);
        tree.setShowsRootHandles(true);
        treeTable.setSelectionMode(0);
        treeTable.setTableHeader(null);
        OptionTableWithPreviewPanel.expandTree((JTree)tree);
        treeTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(1);
        treeTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
        int maxWidth = tree.getPreferredScrollableViewportSize().width + 10;
        TableColumn titleColumn = treeTable.getColumnModel().getColumn(0);
        titleColumn.setPreferredWidth(maxWidth);
        titleColumn.setMinWidth(maxWidth);
        titleColumn.setMaxWidth(maxWidth);
        titleColumn.setResizable(false);
        TableColumn levelColumn = treeTable.getColumnModel().getColumn(1);
        Dimension valueSize = new JLabel(ApplicationBundle.message((String)"option.table.sizing.text", (Object[])new Object[0])).getPreferredSize();
        treeTable.setPreferredScrollableViewportSize(new Dimension(maxWidth + valueSize.width + 10, 20));
        return treeTable;
    }

    private String getRenamedTitle(String fieldOrGroupName, String defaultName) {
        String result = this.myRenamedFields.get(fieldOrGroupName);
        return result == null ? defaultName : result;
    }

    private static void expandTree(JTree tree) {
        int rowCount;
        int oldRowCount = 0;
        while ((rowCount = tree.getRowCount()) != oldRowCount) {
            oldRowCount = rowCount;
            for (int i = 0; i < rowCount; ++i) {
                tree.expandRow(i);
            }
        }
    }

    protected abstract void initTables();

    private void resetNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode) {
            ((MyTreeNode)node).reset(settings);
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            this.resetNode(child, settings);
        }
    }

    private void applyNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode) {
            ((MyTreeNode)node).apply(settings);
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            this.applyNode(child, settings);
        }
    }

    private boolean isModified(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode && ((MyTreeNode)node).isModified(settings)) {
            return true;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            if (!this.isModified(child, settings)) continue;
            return true;
        }
        return false;
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.addOption(fieldName, title, null);
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @NotNull String[] options, @NotNull int[] values) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.addOption(fieldName, title, null, options, values);
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, int minValue, int maxValue, int defaultValue, String defaultValueText) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.myOptions.add(new IntOption(null, fieldName, title, groupName, null, null, minValue, maxValue, defaultValue, defaultValueText));
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.myOptions.add(new BooleanOption(null, fieldName, title, groupName, null, null));
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, @NotNull String[] options, @NotNull int[] values) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.myOptions.add(new SelectionOption(null, fieldName, title, groupName, null, null, options, values));
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        this.applyNode(root, settings);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        return this.isModified(root, settings);
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        this.resetNode(root, settings);
    }

    @Override
    public Set<String> processListOptions() {
        HashSet<String> options = new HashSet<String>();
        this.collectOptions(options, this.myOptions);
        this.collectOptions(options, this.myCustomOptions);
        return options;
    }

    private void collectOptions(Set<String> optionNames, List<Option> optionList) {
        for (Option option : optionList) {
            if (option.groupName != null) {
                optionNames.add(option.groupName);
            }
            optionNames.add(option.title);
        }
    }

    private class MyValueEditor
    extends AbstractTableCellEditor {
        private final JCheckBox myBooleanEditor = new JBCheckBox();
        private JBComboBoxTableCellEditorComponent myOptionsEditor = new JBComboBoxTableCellEditorComponent();
        private MyIntOptionEditor myIntOptionsEditor = new MyIntOptionEditor();
        private Component myCurrentEditor = null;
        private MyTreeNode myCurrentNode = null;

        public MyValueEditor() {
            ActionListener itemChoosen = new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueEditor$1", "actionPerformed"));
                    }
                    if (MyValueEditor.this.myCurrentNode != null) {
                        MyValueEditor.this.myCurrentNode.setValue(MyValueEditor.this.getCellEditorValue());
                        OptionTableWithPreviewPanel.this.somethingChanged();
                    }
                }
            };
            this.myBooleanEditor.addActionListener(itemChoosen);
            this.myOptionsEditor.addActionListener(itemChoosen);
            this.myBooleanEditor.putClientProperty("JComponent.sizeVariant", "small");
            this.myOptionsEditor.putClientProperty((Object)"JComponent.sizeVariant", (Object)"small");
        }

        public Object getCellEditorValue() {
            if (this.myCurrentEditor == this.myOptionsEditor) {
                return this.myOptionsEditor.getEditorValue();
            }
            if (this.myCurrentEditor == this.myBooleanEditor) {
                return this.myBooleanEditor.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.myCurrentEditor == this.myIntOptionsEditor) {
                return this.myIntOptionsEditor.getPresentableValue();
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DefaultMutableTreeNode defaultNode = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row).getLastPathComponent();
            this.myCurrentEditor = null;
            this.myCurrentNode = null;
            if (defaultNode instanceof MyTreeNode) {
                MyTreeNode node;
                this.myCurrentNode = node = (MyTreeNode)defaultNode;
                if (node.getKey() instanceof BooleanOption) {
                    this.myCurrentEditor = this.myBooleanEditor;
                    this.myBooleanEditor.setSelected(node.getValue() == Boolean.TRUE);
                    this.myBooleanEditor.setEnabled(node.isEnabled());
                } else if (node.getKey() instanceof IntOption) {
                    IntOption intOption = (IntOption)node.getKey();
                    this.myCurrentEditor = this.myIntOptionsEditor;
                    this.myIntOptionsEditor.setText(intOption.isDefaultText(node.getValue()) ? "" : node.getValue().toString());
                    this.myIntOptionsEditor.setMinValue(intOption.getMinValue());
                    this.myIntOptionsEditor.setMaxValue(intOption.getMaxValue());
                    this.myIntOptionsEditor.setDefaultValue(intOption.getDefaultValue());
                    this.myIntOptionsEditor.setDefaultValueText(intOption.getDefaultValueText());
                } else {
                    this.myCurrentEditor = this.myOptionsEditor;
                    this.myOptionsEditor.setCell(table, row, column);
                    this.myOptionsEditor.setText(String.valueOf(node.getValue()));
                    this.myOptionsEditor.setOptions((Object[])((SelectionOption)node.getKey()).options);
                    this.myOptionsEditor.setDefaultValue(node.getValue());
                }
            }
            this.myCurrentEditor.setBackground(table.getBackground());
            return this.myCurrentEditor;
        }
    }

    private static class MyIntOptionEditor
    extends JTextField {
        private int myMinValue;
        private int myMaxValue;
        private int myDefaultValue;
        private String myDefaultValueText;

        private MyIntOptionEditor() {
        }

        public Object getPresentableValue() {
            int value = this.validateAndGetIntOption();
            return value == this.myDefaultValue && this.myDefaultValueText != null ? this.myDefaultValueText : Integer.valueOf(value);
        }

        private int validateAndGetIntOption() {
            try {
                int value = Integer.parseInt(this.getText());
                return value >= this.myMinValue && value <= this.myMaxValue ? value : this.myDefaultValue;
            }
            catch (NumberFormatException nfe) {
                return this.myDefaultValue;
            }
        }

        public void setMinValue(int minValue) {
            this.myMinValue = minValue;
        }

        public void setMaxValue(int maxValue) {
            this.myMaxValue = maxValue;
        }

        public void setDefaultValue(int defaultValue) {
            this.myDefaultValue = defaultValue;
        }

        public void setDefaultValueText(String defaultValueText) {
            this.myDefaultValueText = defaultValueText;
        }
    }

    private class MyValueRenderer
    implements TableCellRenderer {
        private final JLabel myComboBox = new JLabel();
        private final JCheckBox myCheckBox = new JBCheckBox();
        private final JPanel myEmptyLabel = new JPanel();
        private final JLabel myIntLabel = new JLabel();

        private MyValueRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
            }
            boolean isEnabled = true;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row).getLastPathComponent();
            if (node instanceof MyTreeNode) {
                isEnabled = ((MyTreeNode)node).isEnabled();
            }
            if (!table.isEnabled()) {
                isEnabled = false;
            }
            Color background = table.getBackground();
            if (value instanceof Boolean) {
                this.myCheckBox.setSelected((Boolean)value);
                this.myCheckBox.setBackground(background);
                this.myCheckBox.setEnabled(isEnabled);
                JCheckBox jCheckBox = this.myCheckBox;
                if (jCheckBox == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
                }
                return jCheckBox;
            }
            if (value instanceof String) {
                this.myComboBox.setText((String)value);
                this.myComboBox.setBackground(background);
                this.myComboBox.setEnabled(isEnabled);
                JLabel jLabel = this.myComboBox;
                if (jLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
                }
                return jLabel;
            }
            if (value instanceof Integer) {
                this.myIntLabel.setText(value.toString());
                JLabel jLabel = this.myIntLabel;
                if (jLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
                }
                return jLabel;
            }
            this.myCheckBox.putClientProperty("JComponent.sizeVariant", "small");
            this.myComboBox.putClientProperty("JComponent.sizeVariant", "small");
            this.myEmptyLabel.setBackground(background);
            JPanel jPanel = this.myEmptyLabel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
            }
            return jPanel;
        }
    }

    private class MyTreeNode
    extends DefaultMutableTreeNode {
        private final Option myKey;
        private final String myText;
        private Object myValue;

        public MyTreeNode(Option key, String text, CodeStyleSettings settings) {
            this.myKey = key;
            this.myText = text;
            this.myValue = key.getValue(settings);
            this.setUserObject(this.myText);
        }

        public Option getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public Object getValue() {
            return this.myValue;
        }

        public void setValue(Object value) {
            this.myValue = value;
        }

        public void reset(CodeStyleSettings settings) {
            this.setValue(this.myKey.getValue(settings));
        }

        public boolean isModified(CodeStyleSettings settings) {
            return !this.myValue.equals(this.myKey.getValue(settings));
        }

        public void apply(CodeStyleSettings settings) {
            this.myKey.setValue(this.myValue, settings);
        }

        public boolean isEnabled() {
            return this.myKey.isEnabled();
        }
    }

    private class IntOption
    extends Option {
        private final int myMinValue;
        private final int myMaxValue;
        private final int myDefaultValue;
        @Nullable
        private String myDefaultValueText;

        public IntOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFiledName, int minValue, int maxValue, @Nullable int defaultValue, String defaultValueText) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$IntOption", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$IntOption", "<init>"));
            }
            super(clazz, fieldName, title, groupName, anchor, anchorFiledName);
            this.myMinValue = minValue;
            this.myMaxValue = maxValue;
            this.myDefaultValue = defaultValue;
            this.myDefaultValueText = defaultValueText;
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                int value = this.field.getInt(this.getSettings(settings));
                return value == this.myDefaultValue && this.myDefaultValueText != null ? this.myDefaultValueText : Integer.valueOf(value);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        public void setValue(Object value, CodeStyleSettings settings) {
            try {
                if (this.myDefaultValueText != null && !this.myDefaultValueText.equals(value)) {
                    this.field.setInt(this.getSettings(settings), (Integer)value);
                } else {
                    this.field.setInt(this.getSettings(settings), -1);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public int getMinValue() {
            return this.myMinValue;
        }

        public int getMaxValue() {
            return this.myMaxValue;
        }

        public int getDefaultValue() {
            return this.myDefaultValue;
        }

        public boolean isDefaultText(Object value) {
            return this.myDefaultValueText != null && this.myDefaultValueText.equals(value);
        }

        @Nullable
        public String getDefaultValueText() {
            return this.myDefaultValueText;
        }
    }

    private class SelectionOption
    extends Option {
        @NotNull
        final String[] options;
        @NotNull
        final int[] values;

        public SelectionOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @NotNull String anchorFiledName, @NotNull String[] options, int[] values) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption", "<init>"));
            }
            super(clazz, fieldName, title, groupName, anchor, anchorFiledName);
            this.options = options;
            this.values = values;
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                int value = this.field.getInt(this.getSettings(settings));
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] != value) continue;
                    return this.options[i];
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void setValue(Object value, CodeStyleSettings settings) {
            try {
                for (int i = 0; i < this.values.length; ++i) {
                    if (!this.options[i].equals(value)) continue;
                    this.field.setInt(this.getSettings(settings), this.values[i]);
                    return;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private class BooleanOption
    extends Option {
        private BooleanOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFiledName) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$BooleanOption", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$BooleanOption", "<init>"));
            }
            super(clazz, fieldName, title, groupName, anchor, anchorFiledName);
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                return this.field.getBoolean(this.getSettings(settings)) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (IllegalAccessException ignore) {
                return null;
            }
        }

        @Override
        public void setValue(Object value, CodeStyleSettings settings) {
            try {
                this.field.setBoolean(this.getSettings(settings), (Boolean)value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private abstract class Option
    extends CustomizableLanguageCodeStylePanel.OrderedOption {
        @Nullable
        final Class<? extends CustomCodeStyleSettings> clazz;
        @NotNull
        final Field field;
        @NotNull
        final String title;
        @Nullable
        final String groupName;
        private boolean myEnabled;

        public Option(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFiledName) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$Option", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$Option", "<init>"));
            }
            super(fieldName, anchor, anchorFiledName);
            this.myEnabled = false;
            this.clazz = clazz;
            this.title = title;
            this.groupName = groupName;
            try {
                Class styleSettingsClass = clazz == null ? CommonCodeStyleSettings.class : clazz;
                this.field = styleSettingsClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public abstract Object getValue(CodeStyleSettings var1);

        public abstract void setValue(Object var1, CodeStyleSettings var2);

        protected Object getSettings(CodeStyleSettings settings) {
            if (this.clazz != null) {
                return settings.getCustomSettings(this.clazz);
            }
            return settings.getCommonSettings(OptionTableWithPreviewPanel.this.getDefaultLanguage());
        }
    }
}

