/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.FilePathCompletionContributor");

    public FilePathCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/FilePathCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/FilePathCompletionContributor$1", "addCompletions"));
                }
                PsiReference psiReference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
                if (FilePathCompletionContributor.getReference(psiReference) != null && parameters.getInvocationCount() == 1) {
                    String shortcut = CompletionContributor.getActionShortcut((String)"CodeCompletion");
                    result.addLookupAdvertisement(CodeInsightBundle.message((String)"class.completion.file.path", (Object[])new Object[]{shortcut}));
                }
            }
        });
        CompletionProvider<CompletionParameters> provider = new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/FilePathCompletionContributor$2", "addCompletions"));
                }
                if (_result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/codeInsight/completion/FilePathCompletionContributor$2", "addCompletions"));
                }
                if (!parameters.isExtendedCompletion()) {
                    return;
                }
                CompletionResultSet result = _result.caseInsensitive();
                PsiElement e = parameters.getPosition();
                Project project = e.getProject();
                PsiReference psiReference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
                Pair fileReferencePair = FilePathCompletionContributor.getReference(psiReference);
                if (fileReferencePair != null) {
                    FileReference first = (FileReference)fileReferencePair.getFirst();
                    if (first == null) {
                        return;
                    }
                    FileReferenceSet set = first.getFileReferenceSet();
                    String prefix = set.getPathString().substring(0, parameters.getOffset() - set.getElement().getTextRange().getStartOffset() - set.getStartInElement());
                    List pathPrefixParts = null;
                    int lastSlashIndex = prefix.lastIndexOf(47);
                    if (lastSlashIndex != -1) {
                        pathPrefixParts = StringUtil.split((String)prefix.substring(0, lastSlashIndex), (String)"/");
                        prefix = prefix.substring(lastSlashIndex + 1);
                    }
                    CompletionResultSet __result = result.withPrefixMatcher(prefix).caseInsensitive();
                    PsiFile originalFile = parameters.getOriginalFile();
                    VirtualFile contextFile = originalFile.getVirtualFile();
                    if (contextFile != null) {
                        String[] fileNames = FilePathCompletionContributor.getAllNames(project);
                        TreeSet<String> resultNames = new TreeSet<String>();
                        for (String fileName : fileNames) {
                            if (!FilePathCompletionContributor.filenameMatchesPrefixOrType(fileName, prefix, set.getSuitableFileTypes(), parameters.getInvocationCount())) continue;
                            resultNames.add(fileName);
                        }
                        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
                        Module contextModule = index.getModuleForFile(contextFile);
                        if (contextModule != null) {
                            List<FileReferenceHelper> helpers = FileReferenceHelperRegistrar.getHelpers(originalFile);
                            GlobalSearchScope scope = ProjectScope.getProjectScope((Project)project);
                            for (String name : resultNames) {
                                ProgressManager.checkCanceled();
                                PsiFile[] files = FilenameIndex.getFilesByName(project, name, scope);
                                if (files.length <= 0) continue;
                                for (PsiFile file : files) {
                                    ProgressManager.checkCanceled();
                                    VirtualFile virtualFile = file.getVirtualFile();
                                    if (virtualFile == null || !virtualFile.isValid() || Comparing.equal((Object)virtualFile, (Object)contextFile)) continue;
                                    ArrayList<FileReferenceHelper> helperList = new ArrayList<FileReferenceHelper>();
                                    for (FileReferenceHelper contextHelper : helpers) {
                                        ProgressManager.checkCanceled();
                                        if (!contextHelper.isMine(project, virtualFile) || pathPrefixParts != null && !FilePathCompletionContributor.fileMatchesPathPrefix(contextHelper.getPsiFileSystemItem(project, virtualFile), pathPrefixParts)) continue;
                                        helperList.add(contextHelper);
                                    }
                                    if (helperList.isEmpty()) continue;
                                    __result.addElement((LookupElement)new FilePathLookupItem(file, helperList));
                                }
                            }
                        }
                    }
                    if (set.getSuitableFileTypes().length > 0 && parameters.getInvocationCount() == 1) {
                        String shortcut = CompletionContributor.getActionShortcut((String)"CodeCompletion");
                        result.addLookupAdvertisement(CodeInsightBundle.message((String)"class.completion.file.path.all.variants", (Object[])new Object[]{shortcut}));
                    }
                    if (((Boolean)fileReferencePair.getSecond()).booleanValue()) {
                        result.stopHere();
                    }
                }
            }
        };
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)provider);
    }

    private static boolean filenameMatchesPrefixOrType(String fileName, String prefix, FileType[] suitableFileTypes, int invocationCount) {
        boolean prefixMatched;
        boolean bl = prefixMatched = prefix.length() == 0 || StringUtil.startsWithIgnoreCase((String)fileName, (String)prefix);
        if (prefixMatched && (suitableFileTypes.length == 0 || invocationCount > 2)) {
            return true;
        }
        if (prefixMatched) {
            String extension = FileUtilRt.getExtension((String)fileName);
            if (extension.length() == 0) {
                return false;
            }
            for (FileType fileType : suitableFileTypes) {
                for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations(fileType)) {
                    if (!FileNameMatcherEx.acceptsCharSequence((FileNameMatcher)matcher, (CharSequence)fileName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean fileMatchesPathPrefix(@Nullable PsiFileSystemItem file, @NotNull List<String> pathPrefix) {
        PsiFileSystemItem parent;
        if (pathPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPrefix", "com/intellij/codeInsight/completion/FilePathCompletionContributor", "fileMatchesPathPrefix"));
        }
        if (file == null) {
            return false;
        }
        ArrayList<String> contextParts = new ArrayList<String>();
        PsiFileSystemItem parentFile = file;
        while ((parent = parentFile.getParent()) != null) {
            if (parent.getName().length() > 0) {
                contextParts.add(0, parent.getName().toLowerCase());
            }
            parentFile = parent;
        }
        String path = StringUtil.join(contextParts, (String)"/");
        int nextIndex = 0;
        for (String s : pathPrefix) {
            nextIndex = path.indexOf(s.toLowerCase(), nextIndex);
            if (nextIndex != -1) continue;
            return false;
        }
        return true;
    }

    private static String[] getAllNames(@NotNull Project project) {
        ChooseByNameContributor[] nameContributors;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/FilePathCompletionContributor", "getAllNames"));
        }
        HashSet<String> names = new HashSet<String>();
        for (ChooseByNameContributor contributor : nameContributors = (ChooseByNameContributor[])ChooseByNameContributor.FILE_EP_NAME.getExtensions()) {
            try {
                names.addAll(Arrays.asList(contributor.getNames(project, false)));
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return ArrayUtil.toStringArray(names);
    }

    @Nullable
    private static Pair<FileReference, Boolean> getReference(PsiReference original) {
        PsiFileReference fileReference;
        if (original == null) {
            return null;
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference : multiReference.getReferences()) {
                if (!(reference instanceof FileReference)) continue;
                return Pair.create((Object)((FileReference)reference), (Object)false);
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = ((FileReferenceOwner)original).getLastFileReference()) instanceof FileReference) {
            return Pair.create((Object)((FileReference)fileReference), (Object)true);
        }
        return null;
    }

    public static class FilePathLookupItem
    extends LookupElement {
        private final String myName;
        private final String myPath;
        private final String myInfo;
        private final Icon myIcon;
        private final PsiFile myFile;
        private final List<FileReferenceHelper> myHelpers;

        public FilePathLookupItem(@NotNull PsiFile file, @NotNull List<FileReferenceHelper> helpers) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem", "<init>"));
            }
            if (helpers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpers", "com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem", "<init>"));
            }
            this.myName = file.getName();
            this.myPath = file.getVirtualFile().getPath();
            this.myHelpers = helpers;
            this.myInfo = FileInfoManager.getFileAdditionalInfo((PsiElement)file);
            this.myIcon = file.getFileType().getIcon();
            this.myFile = file;
        }

        public String toString() {
            return String.format("%s%s", this.myName, this.myInfo == null ? "" : " (" + this.myInfo + ")");
        }

        @NotNull
        public Object getObject() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem", "getObject"));
            }
            return psiFile;
        }

        @NotNull
        public String getLookupString() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem", "getLookupString"));
            }
            return string;
        }

        public void handleInsert(InsertionContext context) {
            PsiReference psiReference;
            Pair fileReferencePair;
            context.commitDocument();
            if (this.myFile.isValid() && (fileReferencePair = FilePathCompletionContributor.getReference(psiReference = context.getFile().findReferenceAt(context.getStartOffset()))) != null) {
                FileReference ref = (FileReference)fileReferencePair.getFirst();
                context.setTailOffset(ref.getRangeInElement().getEndOffset() + ref.getElement().getTextRange().getStartOffset());
                ref.bindToElement((PsiElement)this.myFile);
            }
        }

        public void renderElement(LookupElementPresentation presentation) {
            String relativePath = this.getRelativePath();
            StringBuilder sb = new StringBuilder();
            if (this.myInfo != null) {
                sb.append(" (").append(this.myInfo);
            }
            if (relativePath != null && !relativePath.equals(this.myName)) {
                if (this.myInfo != null) {
                    sb.append(", ");
                } else {
                    sb.append(" (");
                }
                sb.append(relativePath);
            }
            if (sb.length() > 0) {
                sb.append(')');
            }
            presentation.setItemText(this.myName);
            if (sb.length() > 0) {
                presentation.setTailText(sb.toString(), true);
            }
            presentation.setIcon(this.myIcon);
        }

        @Nullable
        private String getRelativePath() {
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            for (FileReferenceHelper helper : this.myHelpers) {
                PsiFileSystemItem root = helper.findRoot(this.myFile.getProject(), virtualFile);
                String path = PsiFileSystemItemUtil.getRelativePath(root, helper.getPsiFileSystemItem(this.myFile.getProject(), virtualFile));
                if (path == null) continue;
                return path;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            FilePathLookupItem that = (FilePathLookupItem)((Object)o);
            if (!this.myName.equals(that.myName)) {
                return false;
            }
            return this.myPath.equals(that.myPath);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myPath.hashCode();
            return result;
        }
    }
}

