/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingUpdate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.FoldingUpdate");
    private static final Key<ParameterizedCachedValue<Runnable, Couple<Boolean>>> CODE_FOLDING_KEY = Key.create((String)"code folding");
    private static final Key<String> CODE_FOLDING_FILE_EXTENSION_KEY = Key.create((String)"code folding file extension");
    private static final Comparator<PsiElement> COMPARE_BY_OFFSET_REVERSED = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement element, PsiElement element1) {
            int startOffsetDiff = element1.getTextRange().getStartOffset() - element.getTextRange().getStartOffset();
            return startOffsetDiff == 0 ? element1.getTextRange().getEndOffset() - element.getTextRange().getEndOffset() : startOffsetDiff;
        }
    };
    private static final Key<Object> LAST_UPDATE_INJECTED_STAMP_KEY = Key.create((String)"LAST_UPDATE_INJECTED_STAMP_KEY");

    private FoldingUpdate() {
    }

    @Nullable
    static Runnable updateFoldRegions(final @NotNull Editor editor, @NotNull PsiFile file, boolean applyDefaultState, boolean quick) {
        String oldExtension;
        ParameterizedCachedValue value;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "updateFoldRegions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "updateFoldRegions"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final Project project = file.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        String currentFileExtension = null;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            currentFileExtension = virtualFile.getExtension();
        }
        if ((value = (ParameterizedCachedValue)editor.getUserData(CODE_FOLDING_KEY)) != null && ((oldExtension = (String)editor.getUserData(CODE_FOLDING_FILE_EXTENSION_KEY)) == null ? currentFileExtension != null : !oldExtension.equals(currentFileExtension))) {
            value = null;
            editor.putUserData(CODE_FOLDING_KEY, null);
        }
        editor.putUserData(CODE_FOLDING_FILE_EXTENSION_KEY, (Object)currentFileExtension);
        if (value != null && value.hasUpToDateValue() && !applyDefaultState) {
            return null;
        }
        if (quick) {
            return (Runnable)FoldingUpdate.getUpdateResult(file, document, quick, project, editor, applyDefaultState).getValue();
        }
        return (Runnable)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)editor, CODE_FOLDING_KEY, (ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<Runnable, Couple<Boolean>>(){

            public CachedValueProvider.Result<Runnable> compute(Couple<Boolean> param) {
                Document document = editor.getDocument();
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                return FoldingUpdate.getUpdateResult(file, document, (Boolean)param.first, project, editor, (Boolean)param.second);
            }
        }, false, (Object)Couple.of((Object)quick, (Object)applyDefaultState));
    }

    private static CachedValueProvider.Result<Runnable> getUpdateResult(PsiFile file, @NotNull Document document, boolean quick, Project project, final Editor editor, boolean applyDefaultState) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "getUpdateResult"));
        }
        FoldingMap elementsToFoldMap = FoldingUpdate.getFoldingsFor(file, document, quick);
        final UpdateFoldRegionsOperation operation = new UpdateFoldRegionsOperation(project, editor, file, elementsToFoldMap, applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO, false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)operation);
            }
        };
        HashSet<Document> dependencies = new HashSet<Document>();
        dependencies.add(document);
        for (FoldingDescriptor descriptor : elementsToFoldMap.values()) {
            dependencies.addAll(descriptor.getDependencies());
        }
        return CachedValueProvider.Result.create((Object)runnable, (Object[])ArrayUtil.toObjectArray(dependencies));
    }

    @Nullable
    public static Runnable updateInjectedFoldRegions(final @NotNull Editor editor, @NotNull PsiFile file, final boolean applyDefaultState) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "updateInjectedFoldRegions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "updateInjectedFoldRegions"));
        }
        if (file instanceof PsiCompiledElement) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final Project project = file.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        final FoldingModel foldingModel = editor.getFoldingModel();
        final long timeStamp = document.getModificationStamp();
        Object lastTimeStamp = editor.getUserData(LAST_UPDATE_INJECTED_STAMP_KEY);
        if (lastTimeStamp instanceof Long && (Long)lastTimeStamp == timeStamp) {
            return null;
        }
        ConcurrentList<DocumentWindow> injectedDocuments = InjectedLanguageUtil.getCachedInjectedDocuments(file);
        if (injectedDocuments.isEmpty()) {
            return null;
        }
        final ArrayList injectedEditors = new ArrayList();
        final ArrayList injectedFiles = new ArrayList();
        final ArrayList maps = new ArrayList();
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid()) continue;
            InjectedLanguageUtil.enumerate(injectedDocument, file, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                public void visit(@NotNull PsiFile injectedFile, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedFile", "com/intellij/codeInsight/folding/impl/FoldingUpdate$4", "visit"));
                    }
                    if (places == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/codeInsight/folding/impl/FoldingUpdate$4", "visit"));
                    }
                    if (!injectedFile.isValid()) {
                        return;
                    }
                    Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                    if (!(injectedEditor instanceof EditorWindow)) {
                        return;
                    }
                    injectedEditors.add((EditorWindow)injectedEditor);
                    injectedFiles.add(injectedFile);
                    FoldingMap map = new FoldingMap();
                    maps.add(map);
                    FoldingUpdate.getFoldingsFor(injectedFile, injectedEditor.getDocument(), map, false);
                }
            });
        }
        return new Runnable(){

            @Override
            public void run() {
                final ArrayList<UpdateFoldRegionsOperation> updateOperations = new ArrayList<UpdateFoldRegionsOperation>(injectedEditors.size());
                for (int i = 0; i < injectedEditors.size(); ++i) {
                    EditorWindow injectedEditor = (EditorWindow)injectedEditors.get(i);
                    PsiFile injectedFile = (PsiFile)injectedFiles.get(i);
                    if (!injectedEditor.getDocument().isValid()) continue;
                    FoldingMap map = (FoldingMap)((Object)maps.get(i));
                    updateOperations.add(new UpdateFoldRegionsOperation(project, injectedEditor, injectedFile, map, applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO, true));
                }
                foldingModel.runBatchFoldingOperation(new Runnable(){

                    @Override
                    public void run() {
                        for (Runnable operation : updateOperations) {
                            operation.run();
                        }
                    }
                });
                editor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, (Object)timeStamp);
            }
        };
    }

    public static boolean supportsDumbModeFolding(@NotNull Editor editor) {
        PsiFile file;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "supportsDumbModeFolding"));
        }
        Project project = editor.getProject();
        if (project != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            return FoldingUpdate.supportsDumbModeFolding(file);
        }
        return true;
    }

    public static boolean supportsDumbModeFolding(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "supportsDumbModeFolding"));
        }
        FileViewProvider viewProvider = file.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null || DumbService.isDumbAware((Object)foldingBuilder)) continue;
            return false;
        }
        return true;
    }

    static FoldingMap getFoldingsFor(@NotNull PsiFile file, @NotNull Document document, boolean quick) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "getFoldingsFor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "getFoldingsFor"));
        }
        FoldingMap foldingMap = new FoldingMap();
        if (file instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        FoldingUpdate.getFoldingsFor(file, document, foldingMap, quick);
        return foldingMap;
    }

    private static void getFoldingsFor(@NotNull PsiFile file, @NotNull Document document, @NotNull FoldingMap elementsToFoldMap, boolean quick) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "getFoldingsFor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "getFoldingsFor"));
        }
        if (elementsToFoldMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToFoldMap", "com/intellij/codeInsight/folding/impl/FoldingUpdate", "getFoldingsFor"));
        }
        FileViewProvider viewProvider = file.getViewProvider();
        TextRange docRange = TextRange.from((int)0, (int)document.getTextLength());
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psi = viewProvider.getPsi(language);
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (psi == null || foldingBuilder == null) continue;
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)quick)) {
                TextRange range = descriptor.getRange();
                if (!docRange.contains(range)) {
                    Attachment[] attachmentArray;
                    String string = "Folding descriptor " + descriptor + " made by " + foldingBuilder + " for " + language + " and called on file " + psi + " is outside document range: " + docRange;
                    if (ApplicationManager.getApplication().isInternal()) {
                        Attachment[] attachmentArray2 = new Attachment[2];
                        attachmentArray2[0] = AttachmentFactory.createAttachment(document);
                        attachmentArray = attachmentArray2;
                        attachmentArray2[1] = new Attachment("psiTree.txt", DebugUtil.psiToString((PsiElement)psi, false, true));
                    } else {
                        attachmentArray = new Attachment[]{};
                    }
                    LOG.error(string, attachmentArray);
                }
                elementsToFoldMap.putValue(descriptor.getElement().getPsi(), descriptor);
            }
        }
    }

    public static class FoldingMap
    extends MultiMap<PsiElement, FoldingDescriptor> {
        public FoldingMap() {
        }

        public FoldingMap(FoldingMap map) {
            super((MultiMap)map);
        }

        @NotNull
        protected Map<PsiElement, Collection<FoldingDescriptor>> createMap() {
            TreeMap<PsiElement, Collection<FoldingDescriptor>> treeMap = new TreeMap<PsiElement, Collection<FoldingDescriptor>>(COMPARE_BY_OFFSET_REVERSED);
            if (treeMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/FoldingUpdate$FoldingMap", "createMap"));
            }
            return treeMap;
        }

        @NotNull
        protected Collection<FoldingDescriptor> createCollection() {
            ArrayList<FoldingDescriptor> arrayList = new ArrayList<FoldingDescriptor>(1);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/FoldingUpdate$FoldingMap", "createCollection"));
            }
            return arrayList;
        }
    }
}

