/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfaOptionalSupport {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DfaOptionalSupport");
    private static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";

    DfaOptionalSupport() {
    }

    @Nullable
    static LocalQuickFix registerReplaceOptionalOfWithOfNullableFix(@NotNull PsiExpression qualifier) {
        PsiClass containingClass;
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport", "registerReplaceOptionalOfWithOfNullableFix"));
        }
        PsiMethodCallExpression call = DfaOptionalSupport.findCallExpression((PsiElement)qualifier);
        PsiMethod method = call == null ? null : call.resolveMethod();
        PsiClass psiClass = containingClass = method == null ? null : method.getContainingClass();
        if (containingClass != null && "of".equals(method.getName())) {
            String qualifiedName = containingClass.getQualifiedName();
            if ("java.util.Optional".equals(qualifiedName)) {
                return new ReplaceOptionalCallFix("ofNullable", false);
            }
            if (GUAVA_OPTIONAL.equals(qualifiedName)) {
                return new ReplaceOptionalCallFix("fromNullable", false);
            }
        }
        return null;
    }

    private static PsiMethodCallExpression findCallExpression(@NotNull PsiElement anchor) {
        PsiElement parent;
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport", "findCallExpression"));
        }
        PsiElement argList = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor).getParent();
        if (argList instanceof PsiExpressionList && (parent = argList.getParent()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)parent;
        }
        return null;
    }

    private static boolean isJdkOptional(@NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport", "isJdkOptional"));
        }
        PsiMethodCallExpression parent = DfaOptionalSupport.findCallExpression(anchor);
        PsiMethod method = parent == null ? null : DfaOptionalSupport.resolveOfNullable((PsiCallExpression)DfaOptionalSupport.findCallExpression(anchor));
        return method != null && "ofNullable".equals(method.getName());
    }

    @NotNull
    static LocalQuickFix createReplaceOptionalOfNullableWithEmptyFix(@NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport", "createReplaceOptionalOfNullableWithEmptyFix"));
        }
        ReplaceOptionalCallFix replaceOptionalCallFix = new ReplaceOptionalCallFix(DfaOptionalSupport.isJdkOptional(anchor) ? "empty" : "absent", true);
        if (replaceOptionalCallFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport", "createReplaceOptionalOfNullableWithEmptyFix"));
        }
        return replaceOptionalCallFix;
    }

    @NotNull
    static LocalQuickFix createReplaceOptionalOfNullableWithOfFix() {
        ReplaceOptionalCallFix replaceOptionalCallFix = new ReplaceOptionalCallFix("of", false);
        if (replaceOptionalCallFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport", "createReplaceOptionalOfNullableWithOfFix"));
        }
        return replaceOptionalCallFix;
    }

    @Nullable
    static PsiMethod resolveOfNullable(PsiCallExpression expression) {
        String name = ((PsiMethodCallExpression)expression).getMethodExpression().getReferenceName();
        if ("ofNullable".equals(name) || "fromNullable".equals(name)) {
            String qname;
            PsiMethod method = expression.resolveMethod();
            PsiClass psiClass = method == null ? null : method.getContainingClass();
            String string = qname = psiClass == null ? null : psiClass.getQualifiedName();
            if ("java.util.Optional".equals(qname) || GUAVA_OPTIONAL.equals(qname)) {
                return method;
            }
        }
        return null;
    }

    private static class ReplaceOptionalCallFix
    implements LocalQuickFix {
        private final String myTargetMethodName;
        private final boolean myClearArguments;

        public ReplaceOptionalCallFix(String targetMethodName, boolean clearArguments) {
            this.myTargetMethodName = targetMethodName;
            this.myClearArguments = clearArguments;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport$ReplaceOptionalCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = "Replace with '." + this.myTargetMethodName + "()'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport$ReplaceOptionalCallFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport$ReplaceOptionalCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/DfaOptionalSupport$ReplaceOptionalCallFix", "applyFix"));
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            if (methodCallExpression != null) {
                PsiExpressionList argList;
                PsiExpression[] args;
                PsiReferenceExpression ofNullableExprName = ((PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("Optional." + this.myTargetMethodName + "(null)", null)).getMethodExpression();
                PsiElement referenceNameElement = methodCallExpression.getMethodExpression().getReferenceNameElement();
                if (referenceNameElement != null) {
                    PsiElement ofNullableNameElement = ofNullableExprName.getReferenceNameElement();
                    LOG.assertTrue(ofNullableNameElement != null);
                    referenceNameElement.replace(ofNullableNameElement);
                }
                if (this.myClearArguments && (args = (argList = methodCallExpression.getArgumentList()).getExpressions()).length > 0) {
                    argList.deleteChildRange((PsiElement)args[0], (PsiElement)args[args.length - 1]);
                }
            }
        }
    }
}

