/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.java18StreamApi.AddMethodsDialog;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class StaticPseudoFunctionalStyleMethodOptions {
    private static final String PIPELINE_ELEMENT_NAME = "pipelineElement";
    private static final String FQN_ATTR = "classFqn";
    private static final String METHOD_ATTR = "method";
    private static final String STREAM_API_METHOD_ATTR = "streamApiMethod";
    private static final String DELETE_ATTR = "toDelete";
    private final List<PipelineElement> myElements = new ArrayList<PipelineElement>();

    public StaticPseudoFunctionalStyleMethodOptions() {
        StaticPseudoFunctionalStyleMethodOptions.restoreDefault(this.myElements);
    }

    private static void restoreDefault(List<PipelineElement> elements) {
        elements.clear();
        String guavaIterables = "com.google.common.collect.Iterables";
        elements.add(new PipelineElement("com.google.common.collect.Iterables", "transform", "map"));
        elements.add(new PipelineElement("com.google.common.collect.Iterables", "filter", "filter"));
        elements.add(new PipelineElement("com.google.common.collect.Iterables", "find", "#findMatched"));
        elements.add(new PipelineElement("com.google.common.collect.Iterables", "all", "allMatch"));
        elements.add(new PipelineElement("com.google.common.collect.Iterables", "any", "anyMatch"));
    }

    @NotNull
    public Collection<PipelineElement> findElementsByMethodName(final @NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions", "findElementsByMethodName"));
        }
        List list = ContainerUtil.filter(this.myElements, (Condition)new Condition<PipelineElement>(){

            public boolean value(PipelineElement element) {
                return methodName.equals(element.getMethodName());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions", "findElementsByMethodName"));
        }
        return list;
    }

    public void readExternal(@NotNull Element xmlElement) {
        if (xmlElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions", "readExternal"));
        }
        StaticPseudoFunctionalStyleMethodOptions.restoreDefault(this.myElements);
        for (Element element : xmlElement.getChildren(PIPELINE_ELEMENT_NAME)) {
            String fqn = element.getAttributeValue(FQN_ATTR);
            String method = element.getAttributeValue(METHOD_ATTR);
            String streamApiMethod = element.getAttributeValue(STREAM_API_METHOD_ATTR);
            boolean toDelete = element.getAttribute(DELETE_ATTR) != null;
            PipelineElement pipelineElement = new PipelineElement(fqn, method, streamApiMethod);
            if (toDelete) {
                this.myElements.remove(pipelineElement);
                continue;
            }
            this.myElements.add(pipelineElement);
        }
    }

    public void writeExternal(@NotNull Element xmlElement) {
        if (xmlElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions", "writeExternal"));
        }
        ArrayList<PipelineElement> toRemoveElements = new ArrayList<PipelineElement>();
        StaticPseudoFunctionalStyleMethodOptions.restoreDefault(toRemoveElements);
        toRemoveElements.removeAll(this.myElements);
        for (PipelineElement element : toRemoveElements) {
            xmlElement.addContent(this.createXmlElement(element).setAttribute(DELETE_ATTR, ""));
        }
        ArrayList<PipelineElement> defaultElements = new ArrayList<PipelineElement>();
        StaticPseudoFunctionalStyleMethodOptions.restoreDefault(defaultElements);
        for (PipelineElement element : this.myElements) {
            if (defaultElements.contains(element)) continue;
            xmlElement.addContent(this.createXmlElement(element));
        }
    }

    public Element createXmlElement(PipelineElement element) {
        return new Element(PIPELINE_ELEMENT_NAME).setAttribute(FQN_ATTR, element.getHandlerClass()).setAttribute(METHOD_ATTR, element.getMethodName()).setAttribute(STREAM_API_METHOD_ATTR, element.getStreamApiMethodName());
    }

    public JComponent createPanel() {
        final JBList list = new JBList();
        list.setModel((ListModel)new SettingsListModel());
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<PipelineElement>(){

            protected void customizeCellRenderer(JList list, PipelineElement element, int index, boolean selected, boolean hasFocus) {
                String classFQName = element.getHandlerClass();
                String[] split = classFQName.split("\\.");
                int classShortNameIndex = classFQName.length() - split[split.length - 1].length();
                this.append(classFQName.substring(0, classShortNameIndex));
                this.append(classFQName.substring(classShortNameIndex), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES.derive(1, (Color)JBColor.BLUE, null, null));
                this.append("." + element.getMethodName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        });
        return ToolbarDecorator.createDecorator((JList)list).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Project currentProject = (Project)CommonDataKeys.PROJECT.getData(button.getDataContext());
                if (currentProject == null) {
                    return;
                }
                AddMethodsDialog dlg = new AddMethodsDialog(currentProject, (Component)list, false);
                if (dlg.showAndGet()) {
                    PipelineElement newElement = dlg.getSelectedElement();
                    if (StaticPseudoFunctionalStyleMethodOptions.this.myElements.contains(newElement)) {
                        return;
                    }
                    StaticPseudoFunctionalStyleMethodOptions.this.myElements.add(newElement);
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            list.updateUI();
                        }
                    });
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                StaticPseudoFunctionalStyleMethodOptions.this.myElements.remove(list.getSelectedIndex());
            }
        }).createPanel();
    }

    private class SettingsListModel
    implements ListModel {
        private SettingsListModel() {
        }

        @Override
        public int getSize() {
            return StaticPseudoFunctionalStyleMethodOptions.this.myElements.size();
        }

        public PipelineElement getElementAt(int index) {
            return (PipelineElement)StaticPseudoFunctionalStyleMethodOptions.this.myElements.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    public static class PipelineElement {
        private final String myHandlerClass;
        private final String myMethodName;
        private final String myStreamApiMethod;

        public PipelineElement(@NotNull String handlerClass, @NotNull String methodName, @NotNull String streamApiMethod) {
            if (handlerClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerClass", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions$PipelineElement", "<init>"));
            }
            if (methodName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions$PipelineElement", "<init>"));
            }
            if (streamApiMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", StaticPseudoFunctionalStyleMethodOptions.STREAM_API_METHOD_ATTR, "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodOptions$PipelineElement", "<init>"));
            }
            this.myHandlerClass = handlerClass;
            this.myMethodName = methodName;
            this.myStreamApiMethod = streamApiMethod;
        }

        public String getHandlerClass() {
            return this.myHandlerClass;
        }

        public String getMethodName() {
            return this.myMethodName;
        }

        public String getStreamApiMethodName() {
            return this.myStreamApiMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineElement element = (PipelineElement)o;
            if (!this.myHandlerClass.equals(element.myHandlerClass)) {
                return false;
            }
            if (!this.myMethodName.equals(element.myMethodName)) {
                return false;
            }
            return this.myStreamApiMethod.equals(element.myStreamApiMethod);
        }

        public int hashCode() {
            int result = this.myHandlerClass.hashCode();
            result = 31 * result + this.myMethodName.hashCode();
            result = 31 * result + this.myStreamApiMethod.hashCode();
            return result;
        }
    }
}

