/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RedundantTypeArgsInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.miscGenerics.RedundantTypeArgsInspection");
    private final LocalQuickFix myQuickFixAction = new MyQuickFixAction();

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.type.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("RedundantTypeArguments" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getShortName"));
        }
        return "RedundantTypeArguments";
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "checkMethod"));
        }
        PsiCodeBlock body = psiMethod.getBody();
        if (body != null) {
            return this.getDescriptions((PsiElement)body, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager inspectionManager, boolean isOnTheFly) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDescriptions"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDescriptions"));
        }
        final ArrayList problems = new ArrayList();
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0) {
                    this.checkCallExpression((PsiJavaCodeReferenceElement)expression.getMethodExpression(), typeArguments, (PsiCallExpression)expression, inspectionManager, problems);
                }
            }

            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement classReference;
                super.visitNewExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0 && (classReference = expression.getClassReference()) != null) {
                    this.checkCallExpression(classReference, typeArguments, (PsiCallExpression)expression, inspectionManager, problems);
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                super.visitMethodReferenceExpression(expression);
                RedundantTypeArgsInspection.checkMethodReference(expression, inspectionManager, problems);
            }

            private void checkCallExpression(PsiJavaCodeReferenceElement reference, PsiType[] typeArguments, PsiCallExpression expression, InspectionManager inspectionManager2, List<ProblemDescriptor> problems2) {
                PsiMethod method;
                PsiTypeParameter[] typeParameters;
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                JavaResolveResult resolveResult = reference.advancedResolve(false);
                PsiElement element = resolveResult.getElement();
                if (element instanceof PsiMethod && resolveResult.isValidResult() && (typeParameters = (method = (PsiMethod)element).getTypeParameters()).length == typeArguments.length) {
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
                    PsiSubstitutor psiSubstitutor = resolveHelper.inferTypeArguments(typeParameters, parameters, argumentList.getExpressions(), PsiSubstitutor.EMPTY, (PsiElement)expression, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                    int length = typeParameters.length;
                    for (int i = 0; i < length; ++i) {
                        PsiTypeParameter typeParameter = typeParameters[i];
                        PsiType inferredType = (PsiType)psiSubstitutor.getSubstitutionMap().get(typeParameter);
                        if (!typeArguments[i].equals(inferredType)) {
                            return;
                        }
                        if (PsiUtil.resolveClassInType((PsiType)method.getReturnType()) != typeParameter || PsiPrimitiveType.getUnboxedType((PsiType)inferredType) == null) continue;
                        return;
                    }
                    PsiCallExpression copy = (PsiCallExpression)expression.copy();
                    try {
                        PsiMethodCallExpression expr = (PsiMethodCallExpression)JavaPsiFacade.getInstance((Project)copy.getProject()).getElementFactory().createExpressionFromText("foo()", null);
                        copy.getTypeArgumentList().replace((PsiElement)expr.getTypeArgumentList());
                        if (copy.resolveMethod() != element) {
                            return;
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                        return;
                    }
                    ProblemDescriptor descriptor = inspectionManager2.createProblemDescriptor((PsiElement)expression.getTypeArgumentList(), InspectionsBundle.message((String)"inspection.redundant.type.problem.descriptor", (Object[])new Object[0]), RedundantTypeArgsInspection.this.myQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                    problems2.add(descriptor);
                }
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void checkMethodReference(PsiMethodReferenceExpression expression, InspectionManager inspectionManager, List<ProblemDescriptor> problems) {
        PsiMethodReferenceExpression copy;
        JavaResolveResult simplifiedResolve;
        PsiElement candidate;
        JavaResolveResult result;
        PsiElement element;
        PsiType psiType;
        PsiTypeElement qualifierTypeElement = expression.getQualifierType();
        if (qualifierTypeElement != null && (psiType = qualifierTypeElement.getType()) instanceof PsiClassType && !((PsiClassType)psiType).isRaw() && (element = (result = expression.advancedResolve(false)).getElement()) instanceof PsiTypeParameterListOwner && (candidate = (simplifiedResolve = (copy = RedundantTypeArgsInspection.createMethodReference(expression, qualifierTypeElement)).advancedResolve(false)).getElement()) == element) {
            PsiJavaCodeReferenceElement referenceElement = qualifierTypeElement.getInnermostComponentReferenceElement();
            LOG.assertTrue(referenceElement != null, (Object)qualifierTypeElement);
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            LOG.assertTrue(parameterList != null);
            ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, InspectionsBundle.message((String)"inspection.redundant.type.problem.descriptor", (Object[])new Object[0]), (LocalQuickFix)new MyMethodReferenceFixAction(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
            problems.add(descriptor);
        }
    }

    private static PsiMethodReferenceExpression createMethodReference(PsiMethodReferenceExpression expression, PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
        PsiMethodReferenceExpression copy = (PsiMethodReferenceExpression)expression.copy();
        copy.getQualifierType().replace((PsiElement)elementFactory.createTypeElement((PsiType)((PsiClassType)type).rawType()));
        return copy;
    }

    private static class MyMethodReferenceFixAction
    implements LocalQuickFix {
        private MyMethodReferenceFixAction() {
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.type.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "applyFix"));
            }
            PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiTypeElement.class);
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)typeElement)) {
                return;
            }
            PsiMethodReferenceExpression expression = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiMethodReferenceExpression.class);
            if (expression != null) {
                expression.replace((PsiElement)RedundantTypeArgsInspection.createMethodReference(expression, typeElement));
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "getFamilyName"));
            }
            return string;
        }
    }

    private static class MyQuickFixAction
    implements LocalQuickFix {
        private MyQuickFixAction() {
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.type.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "applyFix"));
            }
            PsiReferenceParameterList typeArgumentList = (PsiReferenceParameterList)descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)typeArgumentList)) {
                return;
            }
            try {
                PsiMethodCallExpression expr = (PsiMethodCallExpression)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText("foo()", null);
                typeArgumentList.replace((PsiElement)expr.getTypeArgumentList());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "getFamilyName"));
            }
            return string;
        }
    }
}

