/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompilerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerUtil");

    public static String quotePath(String path) {
        if (path != null && path.indexOf(32) != -1) {
            path = path.replaceAll("\\\\", "\\\\\\\\");
            path = '\"' + path + '\"';
        }
        return path;
    }

    public static void refreshIOFiles(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/compiler/impl/CompilerUtil", "refreshIOFiles"));
        }
        if (!files.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(files);
        }
    }

    public static void refreshIODirectories(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/compiler/impl/CompilerUtil", "refreshIODirectories"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
        for (File file : files) {
            VirtualFile virtualFile = lfs.refreshAndFindFileByIoFile(file);
            if (virtualFile == null) continue;
            filesToRefresh.add(virtualFile);
        }
        if (!filesToRefresh.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, true, null, filesToRefresh);
        }
    }

    public static void refreshOutputDirectories(Collection<File> outputs, boolean async) {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> toRefresh = new ArrayList<VirtualFile>();
        int newDirectories = 0;
        for (File ioOutput : outputs) {
            VirtualFile parent;
            VirtualFile output = fileSystem.findFileByIoFile(ioOutput);
            if (output != null) {
                toRefresh.add(output);
                continue;
            }
            if (!ioOutput.exists() || (parent = fileSystem.refreshAndFindFileByIoFile(ioOutput.getParentFile())) == null) continue;
            parent.getChildren();
            toRefresh.add(parent);
            ++newDirectories;
        }
        if (newDirectories > 10) {
            LOG.info(newDirectories + " new output directories were created, refreshing their parents together to avoid too many rootsChange events");
            RefreshQueue.getInstance().refresh(async, false, null, toRefresh);
        } else {
            LOG.debug("Refreshing " + outputs.size() + " outputs");
            fileSystem.refreshIoFiles(outputs, async, false, null);
        }
    }

    public static void refreshIOFile(File file) {
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (vFile != null) {
            vFile.refresh(false, false);
        }
    }

    public static void addSourceCommandLineSwitch(Sdk jdk, LanguageLevel chunkLanguageLevel, @NonNls List<String> commandLine) {
        String versionString = jdk.getVersionString();
        if (StringUtil.isEmpty((String)versionString)) {
            throw new IllegalArgumentException(CompilerBundle.message((String)"javac.error.unknown.jdk.version", (Object[])new Object[]{jdk.getName()}));
        }
        LanguageLevel applicableLanguageLevel = CompilerUtil.getApplicableLanguageLevel(versionString, chunkLanguageLevel);
        if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_8)) {
            commandLine.add("-source");
            commandLine.add("8");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_7)) {
            commandLine.add("-source");
            commandLine.add("1.7");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_6)) {
            commandLine.add("-source");
            commandLine.add("1.6");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_5)) {
            commandLine.add("-source");
            commandLine.add("1.5");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_4)) {
            commandLine.add("-source");
            commandLine.add("1.4");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_3) && !CompilerUtil.isOfVersion(versionString, "1.3") && !CompilerUtil.isOfVersion(versionString, "1.2") && !CompilerUtil.isOfVersion(versionString, "1.1")) {
            commandLine.add("-source");
            commandLine.add("1.3");
        }
    }

    @NotNull
    public static LanguageLevel getApplicableLanguageLevel(String versionString, @NotNull LanguageLevel languageLevel) {
        boolean is1OrNewer;
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/compiler/impl/CompilerUtil", "getApplicableLanguageLevel"));
        }
        boolean is8OrNewer = CompilerUtil.isOfVersion(versionString, "1.8") || CompilerUtil.isOfVersion(versionString, "8.0");
        boolean is7OrNewer = is8OrNewer || CompilerUtil.isOfVersion(versionString, "1.7") || CompilerUtil.isOfVersion(versionString, "7.0");
        boolean is6OrNewer = is7OrNewer || CompilerUtil.isOfVersion(versionString, "1.6") || CompilerUtil.isOfVersion(versionString, "6.0");
        boolean is5OrNewer = is6OrNewer || CompilerUtil.isOfVersion(versionString, "1.5") || CompilerUtil.isOfVersion(versionString, "5.0");
        boolean is4OrNewer = is5OrNewer || CompilerUtil.isOfVersion(versionString, "1.4");
        boolean is3OrNewer = is4OrNewer || CompilerUtil.isOfVersion(versionString, "1.3");
        boolean is2OrNewer = is3OrNewer || CompilerUtil.isOfVersion(versionString, "1.2");
        boolean bl = is1OrNewer = is2OrNewer || CompilerUtil.isOfVersion(versionString, "1.0") || CompilerUtil.isOfVersion(versionString, "1.1");
        if (!is1OrNewer) {
            LanguageLevel languageLevel2 = languageLevel;
            if (languageLevel2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerUtil", "getApplicableLanguageLevel"));
            }
            return languageLevel2;
        }
        if (LanguageLevel.JDK_1_8.equals((Object)languageLevel) && !is8OrNewer) {
            languageLevel = LanguageLevel.JDK_1_7;
        }
        if (LanguageLevel.JDK_1_7.equals((Object)languageLevel) && !is7OrNewer) {
            languageLevel = LanguageLevel.JDK_1_6;
        }
        if (LanguageLevel.JDK_1_6.equals((Object)languageLevel) && !is6OrNewer) {
            languageLevel = LanguageLevel.JDK_1_5;
        }
        if (LanguageLevel.JDK_1_5.equals((Object)languageLevel) && !is5OrNewer) {
            languageLevel = LanguageLevel.JDK_1_4;
        }
        if (LanguageLevel.JDK_1_4.equals((Object)languageLevel) && !is4OrNewer) {
            languageLevel = LanguageLevel.JDK_1_3;
        }
        LanguageLevel languageLevel3 = languageLevel;
        if (languageLevel3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerUtil", "getApplicableLanguageLevel"));
        }
        return languageLevel3;
    }

    public static boolean isOfVersion(String versionString, String checkedVersion) {
        return versionString.contains(checkedVersion);
    }

    public static <T extends Throwable> void runInContext(CompileContext context, String title, ThrowableRunnable<T> action) throws T {
        if (title != null) {
            context.getProgressIndicator().pushState();
            context.getProgressIndicator().setText(title);
        }
        try {
            action.run();
        }
        finally {
            if (title != null) {
                context.getProgressIndicator().popState();
            }
        }
    }

    public static void logDuration(String activityName, long duration) {
        LOG.info(activityName + " took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
    }
}

