/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FrameExtraVariablesProvider;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaFramesListRenderer;
import com.intellij.debugger.engine.JavaStaticGroup;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.FrameVariablesTree;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStackFrame
extends XStackFrame {
    private static final Logger LOG = Logger.getInstance(JavaStackFrame.class);
    private final DebugProcessImpl myDebugProcess;
    @Nullable
    private final XSourcePosition myXSourcePosition;
    private final NodeManagerImpl myNodeManager;
    @NotNull
    private final StackFrameDescriptorImpl myDescriptor;
    private static final JavaFramesListRenderer FRAME_RENDERER = new JavaFramesListRenderer();
    private JavaDebuggerEvaluator myEvaluator;
    private final String myEqualityObject;

    public JavaStackFrame(@NotNull StackFrameProxyImpl stackFrameProxy, @NotNull MethodsTracker tracker) {
        if (stackFrameProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackFrameProxy", "com/intellij/debugger/engine/JavaStackFrame", "<init>"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/debugger/engine/JavaStackFrame", "<init>"));
        }
        this(new StackFrameDescriptorImpl(stackFrameProxy, tracker), true);
    }

    public JavaStackFrame(@NotNull StackFrameDescriptorImpl descriptor, boolean update) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/debugger/engine/JavaStackFrame", "<init>"));
        }
        this.myEvaluator = null;
        this.myDescriptor = descriptor;
        if (update) {
            this.myDescriptor.setContext(null);
            this.myDescriptor.updateRepresentation(null, DescriptorLabelListener.DUMMY_LISTENER);
        }
        this.myEqualityObject = update ? NodeManagerImpl.getContextKeyForFrame(this.myDescriptor.getFrameProxy()) : null;
        this.myDebugProcess = (DebugProcessImpl)descriptor.getDebugProcess();
        this.myNodeManager = this.myDebugProcess.getXdebugProcess().getNodeManager();
        this.myXSourcePosition = this.myDescriptor.getSourcePosition() != null ? DebuggerUtilsEx.toXSourcePosition(this.myDescriptor.getSourcePosition()) : null;
    }

    @NotNull
    public StackFrameDescriptorImpl getDescriptor() {
        StackFrameDescriptorImpl stackFrameDescriptorImpl = this.myDescriptor;
        if (stackFrameDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaStackFrame", "getDescriptor"));
        }
        return stackFrameDescriptorImpl;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.myEvaluator == null) {
            this.myEvaluator = new JavaDebuggerEvaluator(this.myDebugProcess, this);
        }
        return this.myEvaluator;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myXSourcePosition;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        XStackFrame frame;
        XDebugSession xSession;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaStackFrame", "customizePresentation"));
        }
        StackFrameDescriptorImpl selectedDescriptor = null;
        DebuggerSession session = this.myDebugProcess.getSession();
        if (session != null && (xSession = session.getXDebugSession()) != null && (frame = xSession.getCurrentStackFrame()) instanceof JavaStackFrame) {
            selectedDescriptor = ((JavaStackFrame)frame).getDescriptor();
        }
        FRAME_RENDERER.customizePresentation(this.myDescriptor, component, selectedDescriptor);
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaStackFrame", "computeChildren"));
        }
        XStackFrame xFrame = this.getDescriptor().getXStackFrame();
        if (xFrame != null) {
            xFrame.computeChildren(node);
            return;
        }
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction() {
                XValueChildrenList children = new XValueChildrenList();
                JavaStackFrame.this.buildVariablesThreadAction(JavaStackFrame.this.getFrameDebuggerContext(), children, node);
                node.addChildren(children, true);
            }
        });
    }

    DebuggerContextImpl getFrameDebuggerContext() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebuggerContextImpl context = this.myDebugProcess.getDebuggerContext();
        if (context.getFrameProxy() != this.getStackFrameProxy()) {
            SuspendContextImpl threadSuspendContext = SuspendManagerUtil.getSuspendContextForThread(context.getSuspendContext(), this.getStackFrameProxy().threadProxy());
            context = DebuggerContextImpl.createDebuggerContext(this.myDebugProcess.mySession, threadSuspendContext, this.getStackFrameProxy().threadProxy(), this.getStackFrameProxy());
            context.setPositionCache(this.myDescriptor.getSourcePosition());
            context.initCaches();
        }
        return context;
    }

    private void buildVariablesThreadAction(DebuggerContextImpl debuggerContext, XValueChildrenList children, XCompositeNode node) {
        try {
            ReferenceType thisRefType;
            StaticDescriptorImpl staticDecriptor;
            EvaluationContextImpl evaluationContext = debuggerContext.createEvaluationContext();
            if (evaluationContext == null) {
                return;
            }
            if (!debuggerContext.isEvaluationPossible()) {
                node.setErrorMessage(MessageDescriptor.EVALUATION_NOT_POSSIBLE.getLabel());
            }
            Location location = this.myDescriptor.getLocation();
            ObjectReference thisObjectReference = this.myDescriptor.getThisObject();
            if (thisObjectReference != null) {
                ValueDescriptorImpl thisDescriptor = this.myNodeManager.getThisDescriptor(null, thisObjectReference);
                children.add((XNamedValue)JavaValue.create(thisDescriptor, evaluationContext, this.myNodeManager));
            } else if (location != null && (staticDecriptor = this.myNodeManager.getStaticDescriptor(this.myDescriptor, location.declaringType())).isExpandable()) {
                children.addTopGroup((XValueGroup)new JavaStaticGroup(staticDecriptor, evaluationContext, this.myNodeManager));
            }
            DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
            if (debugProcess == null) {
                return;
            }
            Pair<Method, Value> methodValuePair = debugProcess.getLastExecutedMethod();
            if (methodValuePair != null) {
                ValueDescriptorImpl returnValueDescriptor = this.myNodeManager.getMethodReturnValueDescriptor(this.myDescriptor, (Method)methodValuePair.getFirst(), (Value)methodValuePair.getSecond());
                children.add((XNamedValue)JavaValue.create(returnValueDescriptor, evaluationContext, this.myNodeManager));
            }
            for (Pair<Breakpoint, Event> pair : DebuggerUtilsEx.getEventDescriptors(debuggerContext.getSuspendContext())) {
                ObjectReference exception;
                Event debugEvent = (Event)pair.getSecond();
                if (!(debugEvent instanceof ExceptionEvent) || (exception = ((ExceptionEvent)debugEvent).exception()) == null) continue;
                ValueDescriptorImpl exceptionDescriptor = this.myNodeManager.getThrownExceptionObjectDescriptor(this.myDescriptor, exception);
                children.add((XNamedValue)JavaValue.create(exceptionDescriptor, evaluationContext, this.myNodeManager));
            }
            ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            if (classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && thisObjectReference != null && debugProcess.getVirtualMachineProxy().canGetSyntheticAttribute() && (thisRefType = thisObjectReference.referenceType()) instanceof ClassType && location != null && thisRefType.equals(location.declaringType()) && thisRefType.name().contains("$")) {
                ClassType clsType = (ClassType)thisRefType;
                for (Field field : clsType.fields()) {
                    if (!DebuggerUtils.isSynthetic((TypeComponent)field) || !StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) continue;
                    FieldDescriptorImpl fieldDescriptor = this.myNodeManager.getFieldDescriptor(this.myDescriptor, thisObjectReference, field);
                    children.add((XNamedValue)JavaValue.create(fieldDescriptor, evaluationContext, this.myNodeManager));
                }
            }
            try {
                this.buildVariables(debuggerContext, evaluationContext, children, node);
            }
            catch (EvaluateException e) {
                node.setErrorMessage(e.getMessage());
            }
        }
        catch (InvalidStackFrameException e) {
            LOG.info((Throwable)e);
        }
        catch (InternalException e) {
            if (e.errorCode() == 35) {
                node.setErrorMessage(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{e.getMessage()}));
            }
            throw e;
        }
    }

    private void buildVariables(DebuggerContextImpl debuggerContext, EvaluationContextImpl evaluationContext, XValueChildrenList children, XCompositeNode node) throws EvaluateException {
        block14: {
            boolean myAutoWatchMode = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
            if (evaluationContext == null) {
                return;
            }
            final SourcePosition sourcePosition = debuggerContext.getSourcePosition();
            if (sourcePosition == null) {
                return;
            }
            try {
                if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions() && !myAutoWatchMode) {
                    this.superBuildVariables(evaluationContext, children);
                } else {
                    final Map<String, LocalVariableProxyImpl> visibleVariables = FrameVariablesTree.getVisibleVariables(this.getStackFrameProxy());
                    final EvaluationContextImpl evalContext = evaluationContext;
                    Pair usedVars = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<Set<String>, Set<TextWithImports>>>(){

                        public Pair<Set<String>, Set<TextWithImports>> compute() {
                            return FrameVariablesTree.findReferencedVars(visibleVariables.keySet(), sourcePosition, evalContext);
                        }
                    });
                    if (myAutoWatchMode) {
                        for (String var : (Set)usedVars.first) {
                            LocalVariableDescriptorImpl descriptor = this.myNodeManager.getLocalVariableDescriptor(null, visibleVariables.get(var));
                            children.add((XNamedValue)JavaValue.create(descriptor, evaluationContext, this.myNodeManager));
                        }
                    } else {
                        this.superBuildVariables(evaluationContext, children);
                    }
                    EvaluationContextImpl evalContextCopy = evaluationContext.createEvaluationContext(evaluationContext.getThisObject());
                    evalContextCopy.setAutoLoadClasses(false);
                    Set<TextWithImports> extraVars = JavaStackFrame.computeExtraVars((Pair<Set<String>, Set<TextWithImports>>)usedVars, sourcePosition, evalContext);
                    this.addToChildrenFrom(extraVars, children, evaluationContext);
                    this.addToChildrenFrom((Set)usedVars.second, children, evalContextCopy);
                }
            }
            catch (EvaluateException e) {
                if (e.getCause() instanceof AbsentInformationException) {
                    StackFrameProxyImpl frame = this.getStackFrameProxy();
                    List<Value> argValues = frame.getArgumentValues();
                    int index = 0;
                    for (Value argValue : argValues) {
                        children.add((XNamedValue)this.createArgumentValue(index++, argValue, null, evaluationContext));
                    }
                    children.add((XNamedValue)new DummyMessageValueNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE.getLabel(), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON));
                    List<DecompiledLocalVariable> decompiled = FrameVariablesTree.collectVariablesFromBytecode(frame, argValues.size());
                    if (decompiled.isEmpty()) break block14;
                    try {
                        Map<DecompiledLocalVariable, Value> values = LocalVariablesUtil.fetchValues(frame.getStackFrame(), decompiled);
                        for (DecompiledLocalVariable var : decompiled) {
                            children.add((XNamedValue)this.createArgumentValue(var.getSlot(), values.get(var), var.getName(), evaluationContext));
                        }
                    }
                    catch (Exception ex) {
                        LOG.info((Throwable)ex);
                        break block14;
                    }
                }
                throw e;
            }
        }
    }

    private static Set<TextWithImports> computeExtraVars(Pair<Set<String>, Set<TextWithImports>> usedVars, SourcePosition sourcePosition, EvaluationContextImpl evalContext) {
        HashSet<String> alreadyCollected = new HashSet<String>((Collection)usedVars.first);
        for (TextWithImports text : (Set)usedVars.second) {
            alreadyCollected.add(text.getText());
        }
        HashSet<TextWithImports> extra = new HashSet<TextWithImports>();
        for (FrameExtraVariablesProvider provider : (FrameExtraVariablesProvider[])FrameExtraVariablesProvider.EP_NAME.getExtensions()) {
            if (!provider.isAvailable(sourcePosition, evalContext)) continue;
            extra.addAll(provider.collectVariables(sourcePosition, evalContext, alreadyCollected));
        }
        return extra;
    }

    private void addToChildrenFrom(Set<TextWithImports> expressions, XValueChildrenList children, EvaluationContextImpl evaluationContext) {
        for (TextWithImports text : expressions) {
            WatchItemDescriptor descriptor = this.myNodeManager.getWatchItemDescriptor(null, text, null);
            children.add((XNamedValue)JavaValue.create(descriptor, evaluationContext, this.myNodeManager));
        }
    }

    private JavaValue createArgumentValue(int index, Value value, String name, EvaluationContextImpl evaluationContext) {
        ArgumentValueDescriptorImpl descriptor = this.myNodeManager.getArgumentValueDescriptor(null, index, value, name);
        descriptor.setContext(evaluationContext);
        return JavaValue.create(null, descriptor, evaluationContext, this.myNodeManager, true);
    }

    protected void superBuildVariables(EvaluationContextImpl evaluationContext, XValueChildrenList children) throws EvaluateException {
        StackFrameProxyImpl frame = this.getStackFrameProxy();
        for (LocalVariableProxyImpl local : frame.visibleVariables()) {
            LocalVariableDescriptorImpl descriptor = this.myNodeManager.getLocalVariableDescriptor(null, local);
            children.add((XNamedValue)JavaValue.create(descriptor, evaluationContext, this.myNodeManager));
        }
    }

    public StackFrameProxyImpl getStackFrameProxy() {
        return this.myDescriptor.getFrameProxy();
    }

    @Nullable
    public Object getEqualityObject() {
        return this.myEqualityObject;
    }

    public String toString() {
        if (this.myXSourcePosition != null) {
            return "JavaFrame " + this.myXSourcePosition.getFile().getName() + ":" + this.myXSourcePosition.getLine();
        }
        return "JavaFrame position unknown";
    }

    static class DummyMessageValueNode
    extends XNamedValue {
        private final String myMessage;
        private final Icon myIcon;

        public DummyMessageValueNode(String message, Icon icon) {
            super("");
            this.myMessage = message;
            this.myIcon = icon;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode", "computePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode", "computePresentation"));
            }
            node.setPresentation(this.myIcon, new XValuePresentation(){

                @NotNull
                public String getSeparator() {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1", "getSeparator"));
                    }
                    return "";
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    if (renderer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1", "renderValue"));
                    }
                    renderer.renderValue(DummyMessageValueNode.this.myMessage);
                }
            }, false);
        }
    }
}

