/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class LineFragmentSplitter {
    @NotNull
    private final CharSequence myText1;
    @NotNull
    private final CharSequence myText2;
    @NotNull
    private final List<ByWord.InlineChunk> myWords1;
    @NotNull
    private final List<ByWord.InlineChunk> myWords2;
    @NotNull
    private final FairDiffIterable myIterable;
    @NotNull
    private final ProgressIndicator myIndicator;
    @NotNull
    private final List<WordBlock> myResult;
    private int last1;
    private int last2;
    private boolean lastHasEqualWords;
    private boolean hasEqualWords;

    public LineFragmentSplitter(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<ByWord.InlineChunk> words1, @NotNull List<ByWord.InlineChunk> words2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/LineFragmentSplitter", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/LineFragmentSplitter", "<init>"));
        }
        if (words1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words1", "com/intellij/diff/comparison/LineFragmentSplitter", "<init>"));
        }
        if (words2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words2", "com/intellij/diff/comparison/LineFragmentSplitter", "<init>"));
        }
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/LineFragmentSplitter", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/LineFragmentSplitter", "<init>"));
        }
        this.myResult = new ArrayList<WordBlock>();
        this.last1 = -1;
        this.last2 = -1;
        this.lastHasEqualWords = false;
        this.hasEqualWords = false;
        this.myText1 = text1;
        this.myText2 = text2;
        this.myWords1 = words1;
        this.myWords2 = words2;
        this.myIterable = iterable;
        this.myIndicator = indicator;
    }

    @NotNull
    public List<WordBlock> run() {
        for (Range range : this.myIterable.iterateUnchanged()) {
            int count = range.end1 - range.start1;
            for (int i = 0; i < count; ++i) {
                int index1 = range.start1 + i;
                int index2 = range.start2 + i;
                if (LineFragmentSplitter.isNewline(this.myWords1, index1) && LineFragmentSplitter.isNewline(this.myWords2, index2)) {
                    this.addLineChunk(index1, index2);
                    continue;
                }
                if (LineFragmentSplitter.isFirstInLine(this.myWords1, index1) && LineFragmentSplitter.isFirstInLine(this.myWords2, index2)) {
                    this.addLineChunk(index1 - 1, index2 - 1);
                }
                this.hasEqualWords = true;
            }
        }
        this.addLineChunk(this.myWords1.size(), this.myWords2.size());
        List<WordBlock> list = this.myResult;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/LineFragmentSplitter", "run"));
        }
        return list;
    }

    private void addLineChunk(int end1, int end2) {
        if (this.last1 > end1 || this.last2 > end2) {
            return;
        }
        WordBlock block = this.createBlock(this.last1, this.last2, end1, end2);
        if (block.offsets.isEmpty()) {
            return;
        }
        WordBlock lastBlock = (WordBlock)ContainerUtil.getLastItem(this.myResult);
        if (lastBlock != null && this.shouldMergeBlocks(lastBlock, block)) {
            this.myResult.remove(this.myResult.size() - 1);
            this.myResult.add(LineFragmentSplitter.mergeBlocks(lastBlock, block));
            this.lastHasEqualWords = this.hasEqualWords || this.lastHasEqualWords;
        } else {
            this.myResult.add(block);
            this.lastHasEqualWords = this.hasEqualWords;
        }
        this.hasEqualWords = false;
        this.last1 = end1;
        this.last2 = end2;
    }

    @NotNull
    private WordBlock createBlock(int start1, int start2, int end1, int end2) {
        int startOffset1 = LineFragmentSplitter.getOffset(this.myWords1, this.myText1, start1);
        int startOffset2 = LineFragmentSplitter.getOffset(this.myWords2, this.myText2, start2);
        int endOffset1 = LineFragmentSplitter.getOffset(this.myWords1, this.myText1, end1);
        int endOffset2 = LineFragmentSplitter.getOffset(this.myWords2, this.myText2, end2);
        start1 = Math.max(0, start1 + 1);
        start2 = Math.max(0, start2 + 1);
        end1 = Math.min(end1 + 1, this.myWords1.size());
        end2 = Math.min(end2 + 1, this.myWords2.size());
        WordBlock wordBlock = new WordBlock(new Range(start1, end1, start2, end2), new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        if (wordBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/LineFragmentSplitter", "createBlock"));
        }
        return wordBlock;
    }

    private boolean shouldMergeBlocks(@NotNull WordBlock lastBlock, @NotNull WordBlock newBlock) {
        if (lastBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastBlock", "com/intellij/diff/comparison/LineFragmentSplitter", "shouldMergeBlocks"));
        }
        if (newBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBlock", "com/intellij/diff/comparison/LineFragmentSplitter", "shouldMergeBlocks"));
        }
        if (!this.lastHasEqualWords && !this.hasEqualWords) {
            return true;
        }
        if (this.isEqualsIgnoreWhitespace(newBlock) && this.isEqualsIgnoreWhitespace(lastBlock)) {
            return true;
        }
        return this.noWordsInside(lastBlock) || this.noWordsInside(newBlock);
    }

    private boolean isEqualsIgnoreWhitespace(@NotNull WordBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/comparison/LineFragmentSplitter", "isEqualsIgnoreWhitespace"));
        }
        CharSequence sequence1 = this.myText1.subSequence(block.offsets.start1, block.offsets.end1);
        CharSequence sequence2 = this.myText2.subSequence(block.offsets.start2, block.offsets.end2);
        return StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2);
    }

    @NotNull
    private static WordBlock mergeBlocks(@NotNull WordBlock start, @NotNull WordBlock end) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/diff/comparison/LineFragmentSplitter", "mergeBlocks"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/diff/comparison/LineFragmentSplitter", "mergeBlocks"));
        }
        WordBlock wordBlock = new WordBlock(new Range(start.words.start1, end.words.end1, start.words.start2, end.words.end2), new Range(start.offsets.start1, end.offsets.end1, start.offsets.start2, end.offsets.end2));
        if (wordBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/LineFragmentSplitter", "mergeBlocks"));
        }
        return wordBlock;
    }

    private static int getOffset(@NotNull List<ByWord.InlineChunk> words, @NotNull CharSequence text, int index) {
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/diff/comparison/LineFragmentSplitter", "getOffset"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/LineFragmentSplitter", "getOffset"));
        }
        if (index == -1) {
            return 0;
        }
        if (index == words.size()) {
            return text.length();
        }
        ByWord.InlineChunk chunk = words.get(index);
        assert (chunk instanceof ByWord.NewlineChunk);
        return chunk.getOffset2();
    }

    private static boolean isNewline(@NotNull List<ByWord.InlineChunk> words1, int index) {
        if (words1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words1", "com/intellij/diff/comparison/LineFragmentSplitter", "isNewline"));
        }
        return words1.get(index) instanceof ByWord.NewlineChunk;
    }

    private static boolean isFirstInLine(@NotNull List<ByWord.InlineChunk> words1, int index) {
        if (words1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words1", "com/intellij/diff/comparison/LineFragmentSplitter", "isFirstInLine"));
        }
        if (index == 0) {
            return true;
        }
        return words1.get(index - 1) instanceof ByWord.NewlineChunk;
    }

    private boolean noWordsInside(@NotNull WordBlock block) {
        int i;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/comparison/LineFragmentSplitter", "noWordsInside"));
        }
        for (i = block.words.start1; i < block.words.end1; ++i) {
            if (this.myWords1.get(i) instanceof ByWord.NewlineChunk) continue;
            return false;
        }
        for (i = block.words.start2; i < block.words.end2; ++i) {
            if (this.myWords2.get(i) instanceof ByWord.NewlineChunk) continue;
            return false;
        }
        return true;
    }

    public static class WordBlock {
        @NotNull
        public final Range words;
        @NotNull
        public final Range offsets;

        public WordBlock(@NotNull Range words, @NotNull Range offsets) {
            if (words == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/diff/comparison/LineFragmentSplitter$WordBlock", "<init>"));
            }
            if (offsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsets", "com/intellij/diff/comparison/LineFragmentSplitter$WordBlock", "<init>"));
            }
            this.words = words;
            this.offsets = offsets;
        }
    }
}

