/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.OnesideContentPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OnesideDiffViewer<T extends EditorHolder>
extends ListenerDiffViewerBase {
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final OnesideContentPanel myContentPanel;
    @NotNull
    private final Side mySide;
    @NotNull
    private final T myHolder;

    public OnesideDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "<init>"));
        }
        super(context, request);
        this.mySide = Side.fromRight((boolean)(this.myRequest.getContents().get(0) instanceof EmptyContent));
        this.myHolder = this.createEditorHolder(factory);
        JComponent titlePanels = this.createTitle();
        this.myContentPanel = new OnesideContentPanel((EditorHolder)this.myHolder, titlePanels);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context);
    }

    @Override
    protected void onDispose() {
        this.destroyEditorHolder();
        super.onDispose();
    }

    @NotNull
    protected T createEditorHolder(@NotNull EditorHolderFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "createEditorHolder"));
        }
        DiffContent content = (DiffContent)this.mySide.select(this.myRequest.getContents());
        T t = factory.create(content, this.myContext);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "createEditorHolder"));
        }
        return t;
    }

    private void destroyEditorHolder() {
        Disposer.dispose(this.myHolder);
    }

    @NotNull
    protected JComponent createTitle() {
        List<JComponent> simpleTitles = DiffUtil.createSimpleTitles(this.myRequest);
        JComponent jComponent = (JComponent)this.mySide.select(simpleTitles);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "createTitle"));
        }
        return jComponent;
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "getComponent"));
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return ((EditorHolder)this.getEditorHolder()).getPreferredFocusedComponent();
    }

    @NotNull
    public Side getSide() {
        Side side = this.mySide;
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "getSide"));
        }
        return side;
    }

    @NotNull
    protected DiffContent getContent() {
        DiffContent diffContent = (DiffContent)this.mySide.select(this.myRequest.getContents());
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "getContent"));
        }
        return diffContent;
    }

    @NotNull
    protected T getEditorHolder() {
        T t = this.myHolder;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "getEditorHolder"));
        }
        return t;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return DiffUtil.getVirtualFile(this.myRequest, this.mySide);
        }
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getContent();
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        return this.getContent().getOpenFileDescriptor();
    }

    public static <T extends EditorHolder> boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "canShowRequest"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/OnesideDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        DiffContent content1 = (DiffContent)contents.get(0);
        DiffContent content2 = (DiffContent)contents.get(1);
        if (content1 instanceof EmptyContent && factory.wantShowContent(content2, context)) {
            return true;
        }
        return content2 instanceof EmptyContent && factory.wantShowContent(content1, context);
    }
}

