/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDesktopEntryAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.CreateDesktopEntryAction");

    public static boolean isAvailable() {
        return SystemInfo.isUnix && SystemInfo.hasXdgOpen();
    }

    public void update(AnActionEvent event) {
        boolean enabled = CreateDesktopEntryAction.isAvailable();
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent event) {
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        Project project = event.getProject();
        CreateDesktopEntryDialog dialog = new CreateDesktopEntryDialog(project);
        if (!dialog.showAndGet()) {
            return;
        }
        final boolean globalEntry = dialog.myGlobalEntryCheckBox.isSelected();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, event.getPresentation().getText()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateDesktopEntryAction$1", "run"));
                }
                CreateDesktopEntryAction.createDesktopEntry(this.getProject(), indicator, globalEntry);
            }
        });
    }

    public static void createDesktopEntry(@Nullable Project project, @NotNull ProgressIndicator indicator, boolean globalEntry) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateDesktopEntryAction", "createDesktopEntry"));
        }
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        double step = (1.0 - indicator.getFraction()) / 3.0;
        try {
            indicator.setText(ApplicationBundle.message((String)"desktop.entry.checking", (Object[])new Object[0]));
            CreateDesktopEntryAction.check();
            indicator.setFraction(indicator.getFraction() + step);
            indicator.setText(ApplicationBundle.message((String)"desktop.entry.preparing", (Object[])new Object[0]));
            File entry = CreateDesktopEntryAction.prepare();
            indicator.setFraction(indicator.getFraction() + step);
            indicator.setText(ApplicationBundle.message((String)"desktop.entry.installing", (Object[])new Object[0]));
            CreateDesktopEntryAction.install(entry, globalEntry);
            indicator.setFraction(indicator.getFraction() + step);
            String message = ApplicationBundle.message((String)"desktop.entry.success", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
            if (ApplicationManager.getApplication() != null) {
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Desktop entry created", message, NotificationType.INFORMATION));
            }
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication() == null) {
                throw new RuntimeException(e);
            }
            String message = e.getMessage();
            if (!StringUtil.isEmptyOrSpaces((String)message)) {
                LOG.warn((Throwable)e);
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Failed to create desktop entry", message, NotificationType.ERROR), (Project)project);
            }
            LOG.error((Throwable)e);
        }
    }

    private static void check() throws ExecutionException, InterruptedException {
        int result = new GeneralCommandLine(new String[]{"which", "xdg-desktop-menu"}).createProcess().waitFor();
        if (result != 0) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.xdg.missing", (Object[])new Object[0]));
        }
    }

    private static File prepare() throws IOException {
        String iconPath;
        String homePath = PathManager.getHomePath();
        assert (new File(homePath).isDirectory()) : "Invalid home path: '" + homePath + "'";
        String binPath = homePath + "/bin";
        assert (new File(binPath).isDirectory()) : "Invalid bin path: '" + binPath + "'";
        String name = ApplicationNamesInfo.getInstance().getFullProductName();
        if (PlatformUtils.isIdeaCommunity()) {
            name = name + " Community Edition";
        }
        if ((iconPath = AppUIUtil.findIcon(binPath)) == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.icon.missing", (Object[])new Object[]{binPath}));
        }
        String execPath = CreateDesktopEntryAction.findScript(binPath);
        if (execPath == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])new Object[]{binPath}));
        }
        String wmClass = AppUIUtil.getFrameClass();
        String content = ExecUtil.loadTemplate((ClassLoader)CreateDesktopEntryAction.class.getClassLoader(), (String)"entry.desktop", (Map)ContainerUtil.newHashMap(Arrays.asList("$NAME$", "$SCRIPT$", "$ICON$", "$WM_CLASS$"), Arrays.asList(name, execPath, iconPath, wmClass)));
        String entryName = wmClass + ".desktop";
        File entryFile = new File(FileUtil.getTempDirectory(), entryName);
        FileUtil.writeToFile((File)entryFile, (String)content);
        entryFile.deleteOnExit();
        return entryFile;
    }

    @Nullable
    private static String findScript(String binPath) {
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        String execPath = binPath + '/' + productName + ".sh";
        if (new File(execPath).canExecute()) {
            return execPath;
        }
        execPath = binPath + '/' + productName.toLowerCase(Locale.US) + ".sh";
        if (new File(execPath).canExecute()) {
            return execPath;
        }
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        execPath = binPath + '/' + scriptName + ".sh";
        if (new File(execPath).canExecute()) {
            return execPath;
        }
        return null;
    }

    private static void install(File entryFile, boolean globalEntry) throws IOException, ExecutionException, InterruptedException {
        if (globalEntry) {
            File script = ExecUtil.createTempExecutableScript((String)"sudo", (String)".sh", (String)("#!/bin/sh\nxdg-desktop-menu install --mode system \"" + entryFile.getAbsolutePath() + "\"\n" + "RV=$?\n" + "xdg-desktop-menu forceupdate --mode system\n" + "exit $RV\n"));
            script.deleteOnExit();
            String prompt = ApplicationBundle.message((String)"desktop.entry.sudo.prompt", (Object[])new Object[0]);
            int result = ExecUtil.sudoAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{script.getPath()}), (String)prompt).getExitCode();
            if (result != 0) {
                throw new RuntimeException("'" + script.getAbsolutePath() + "' : " + result);
            }
        } else {
            int result = new GeneralCommandLine(new String[]{"xdg-desktop-menu", "install", "--mode", "user", entryFile.getAbsolutePath()}).createProcess().waitFor();
            if (result != 0) {
                throw new RuntimeException("'" + entryFile.getAbsolutePath() + "' : " + result);
            }
            new GeneralCommandLine(new String[]{"xdg-desktop-menu", "forceupdate", "--mode", "user"}).createProcess().waitFor();
        }
    }

    public static class CreateDesktopEntryDialog
    extends DialogWrapper {
        private JPanel myContentPane;
        private JLabel myLabel;
        private JCheckBox myGlobalEntryCheckBox;

        public CreateDesktopEntryDialog(Project project) {
            super(project);
            this.$$$setupUI$$$();
            this.init();
            this.setTitle("Create Desktop Entry");
            this.myLabel.setText(this.myLabel.getText().replace("$APP_NAME$", ApplicationNamesInfo.getInstance().getProductName()));
        }

        protected JComponent createCenterPanel() {
            return this.myContentPane;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.myContentPane = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
            this.myGlobalEntryCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Create entry for all users");
            jCheckBox.setMnemonic('A');
            jCheckBox.setDisplayedMnemonicIndex(17);
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myLabel = jLabel = new JLabel();
            jLabel.setText("<html>You can create a desktop entry for easier starting $APP_NAME$ from a system menu<br>and better desktop integration.<html>");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myContentPane;
        }
    }
}

