/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeStructure;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class FavoritesPanel {
    private final Project myProject;
    private final FavoritesTreeViewPanel myViewPanel;
    private final DnDAwareTree myTree;
    private final AbstractTreeBuilder myTreeBuilder;
    private final FavoritesTreeStructure myTreeStructure;
    private final Image myFavoritesImage = IconUtil.toImage((Icon)AllIcons.Toolwindows.ToolWindowFavorites);

    public FavoritesPanel(Project project) {
        this.myProject = project;
        this.myViewPanel = new FavoritesTreeViewPanel(this.myProject);
        this.myTree = this.myViewPanel.getTree();
        this.myTreeBuilder = this.myViewPanel.getBuilder();
        if (this.myTreeBuilder != null) {
            Disposer.register((Disposable)this.myProject, (Disposable)this.myTreeBuilder);
        }
        this.myTreeStructure = this.myViewPanel.getFavoritesTreeStructure();
        this.setupDnD();
    }

    public FavoritesTreeViewPanel getPanel() {
        return this.myViewPanel;
    }

    private void setupDnD() {
        DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setBeanProvider((Function)new Function<DnDActionInfo, DnDDragStartBean>(){

            public DnDDragStartBean fun(DnDActionInfo info) {
                FavoritesTreeNodeDescriptor root;
                Object o;
                TreePath path = FavoritesPanel.this.myTree.getPathForLocation(info.getPoint().x, info.getPoint().y);
                if (path != null && path.getPathCount() == 3 && (o = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && (o = ((DefaultMutableTreeNode)o).getUserObject()) instanceof FavoritesTreeNodeDescriptor && (root = ((FavoritesTreeNodeDescriptor)((Object)o)).getFavoritesRoot()) != o && (o = root.getElement()) instanceof FavoritesListNode && ((FavoritesListNode)((Object)o)).getProvider() == null) {
                    return new DnDDragStartBean((Object)path);
                }
                return new DnDDragStartBean(""){

                    public boolean isEmpty() {
                        return true;
                    }
                };
            }
        }).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Object obj = event.getAttachedObject();
                if ("".equals(obj)) {
                    event.setDropPossible(false);
                    return false;
                }
                if (obj instanceof TreePath && ((TreePath)obj).getPathCount() <= 2) {
                    event.setDropPossible(false);
                    return true;
                }
                FavoritesListNode node = FavoritesPanel.this.myViewPanel.findFavoritesListNode(event.getPoint());
                if (obj instanceof TreePath && ((FavoritesPanel)FavoritesPanel.this).myViewPanel.myTree.getPath((PresentableNodeDescriptor)node).isDescendant((TreePath)obj) || node != null && node.getProvider() != null) {
                    event.setDropPossible(false);
                    return false;
                }
                FavoritesPanel.this.highlight(node, event);
                if (node != null) {
                    event.setDropPossible(true);
                    return true;
                }
                event.setDropPossible(false);
                return false;
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                FavoritesListNode node = FavoritesPanel.this.myViewPanel.findFavoritesListNode(event.getPoint());
                FavoritesManager mgr = FavoritesManager.getInstance(FavoritesPanel.this.myProject);
                if (node == null) {
                    return;
                }
                String listTo = (String)node.getValue();
                Object obj = event.getAttachedObject();
                if (obj instanceof TreePath) {
                    TreePath path = (TreePath)obj;
                    String listFrom = (String)FavoritesTreeViewPanel.getListNodeFromPath(path).getValue();
                    if (listTo.equals(listFrom)) {
                        return;
                    }
                    if (path.getPathCount() == 3) {
                        AbstractTreeNode abstractTreeNode = ((FavoritesTreeNodeDescriptor)((Object)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject())).getElement();
                        Object element = abstractTreeNode.getValue();
                        mgr.removeRoot(listFrom, Collections.singletonList(abstractTreeNode));
                        if (element instanceof SmartPsiElementPointer) {
                            element = ((SmartPsiElementPointer)element).getElement();
                        }
                        mgr.addRoots(listTo, null, element);
                    }
                } else if (obj instanceof TransferableWrapper) {
                    FavoritesPanel.this.myViewPanel.dropPsiElements(mgr, node, ((TransferableWrapper)obj).getPsiElements());
                } else if (obj instanceof DnDNativeTarget.EventInfo) {
                    FavoritesPanel.this.myViewPanel.dropPsiElements(mgr, node, (PsiElement[])FavoritesPanel.this.getPsiFiles(FileCopyPasteUtil.getFileList(((DnDNativeTarget.EventInfo)obj).getTransferable())));
                }
            }
        }).setImageProvider((Function)new Function<DnDActionInfo, DnDImage>(){

            public DnDImage fun(DnDActionInfo info) {
                return new DnDImage(FavoritesPanel.this.myFavoritesImage, new Point(-FavoritesPanel.this.myFavoritesImage.getWidth(null) / 2, -FavoritesPanel.this.myFavoritesImage.getHeight(null) / 2));
            }
        }).enableAsNativeTarget().setDisposableParent((Disposable)this.myProject).install();
    }

    private void highlight(FavoritesListNode node, DnDEvent event) {
        if (node != null) {
            Rectangle bounds;
            Object userObject;
            Object pathObj;
            TreePath pathToList;
            for (pathToList = this.myTree.getPath((PresentableNodeDescriptor)node); !(pathToList == null || (pathObj = pathToList.getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)pathObj).getUserObject()) instanceof FavoritesTreeNodeDescriptor && ((FavoritesTreeNodeDescriptor)((Object)userObject)).getElement() == node); pathToList = pathToList.getParentPath()) {
            }
            if (pathToList != null && (bounds = this.myTree.getPathBounds(pathToList)) != null) {
                event.setHighlighting(new RelativeRectangle((Component)((Object)this.myTree), bounds), 1);
            }
        } else {
            event.hideHighlighter();
        }
    }

    @Nullable
    protected PsiFileSystemItem[] getPsiFiles(@Nullable List<File> fileList) {
        if (fileList == null) {
            return null;
        }
        ArrayList<PsiDirectory> sourceFiles = new ArrayList<PsiDirectory>();
        for (File file : fileList) {
            PsiDirectory psiFile;
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (vFile == null || (psiFile = vFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(vFile) : PsiManager.getInstance((Project)this.myProject).findFile(vFile)) == null) continue;
            sourceFiles.add(psiFile);
        }
        return sourceFiles.toArray(new PsiFileSystemItem[sourceFiles.size()]);
    }
}

