/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.NewScratchFileAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScratchWidget
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    static final String WIDGET_ID = "Scratch";
    private final TextPanel.WithIconAndArrows myPanel = new TextPanel.WithIconAndArrows();

    public ScratchWidget(Project project) {
        super(project);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchWidget$1", "onClick"));
                }
                Project project = ScratchWidget.this.getProject();
                Editor editor = ScratchWidget.this.getEditor();
                VirtualFile file = ScratchWidget.this.getSelectedFile();
                if (project == null || editor == null || file == null) {
                    return false;
                }
                ScratchWidget.this.showPopup(project, file);
                return true;
            }
        }.installOn((Component)this.myPanel);
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/scratch/ScratchWidget$2", "after"));
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent.getRequestor() != "FileContentUtilCore.saveOrReload") continue;
                    ScratchWidget.this.update();
                    break;
                }
            }
        });
    }

    private void showPopup(Project project, final VirtualFile file) {
        final PerFileMappings<Language> fileService = ScratchFileService.getInstance().getScratchesMapping();
        ListPopup popup = NewScratchFileAction.buildLanguageSelectionPopup(project, "Change Language", (Language)fileService.getMapping(file), new Consumer<Language>(){

            public void consume(Language language) {
                fileService.setMapping(file, (Object)language);
                ScratchWidget.this.update();
            }
        });
        Dimension dimension = popup.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup.show(new RelativePoint((Component)this.myPanel, at));
    }

    @NotNull
    public String ID() {
        if (WIDGET_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchWidget", "ID"));
        }
        return WIDGET_ID;
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/scratch/ScratchWidget", "getPresentation"));
        }
        return null;
    }

    private void update() {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        final VirtualFile file = this.getSelectedFile();
        ScratchFileService fileService = ScratchFileService.getInstance();
        if (file != null && fileService.getRootType(file) instanceof ScratchRootType) {
            Language lang = (Language)fileService.getScratchesMapping().getMapping(file);
            if (lang == null) {
                lang = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)file.getFileType()).getLanguage(), file, project);
            }
            this.myPanel.setText(lang.getDisplayName());
            this.myPanel.setBorder(StatusBarWidget.WidgetBorder.WIDE);
            this.myPanel.setIcon(ScratchWidget.getDefaultIcon(lang));
            this.myPanel.setVisible(true);
            if (Boolean.TRUE.equals(file.getUserData(NewScratchFileAction.IS_NEW_SCRATCH))) {
                file.putUserData(NewScratchFileAction.IS_NEW_SCRATCH, null);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ScratchWidget.this.myPanel.isVisible()) {
                            ScratchWidget.this.showPopup(ScratchWidget.this.getProject(), file);
                        }
                    }
                });
            }
        } else {
            this.myPanel.setBorder(null);
            this.myPanel.setVisible(false);
        }
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(WIDGET_ID);
        }
    }

    public StatusBarWidget copy() {
        return new ScratchWidget(this.myProject);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/ScratchWidget", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchWidget", "fileOpened"));
        }
        this.update();
        super.fileOpened(source, file);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/ScratchWidget", "fileClosed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchWidget", "fileClosed"));
        }
        this.update();
        super.fileClosed(source, file);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scratch/ScratchWidget", "selectionChanged"));
        }
        this.update();
        super.selectionChanged(event);
    }

    private static Icon getDefaultIcon(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/ScratchWidget", "getDefaultIcon"));
        }
        LanguageFileType associatedLanguage = language.getAssociatedFileType();
        return associatedLanguage != null ? associatedLanguage.getIcon() : null;
    }
}

