/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class MacIntelliJBorderPainter {
    private static final Icon L = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/macBorderLeft.png");
    private static final Icon R = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/macBorderRight.png");
    private static final Icon T = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/macBorderTop.png");
    private static final Icon B = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/macBorderBottom.png");
    private static final Icon TL = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/macBorderTopLeft.png");
    private static final Icon TR = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/macBorderTopRight.png");
    private static final Icon BL = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/macBorderBottomLeft.png");
    private static final Icon BR = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/macBorderBottomRight.png");

    public static void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yOffset;
        int xOffset;
        g = g.create(x, y, width, height);
        TL.paintIcon(c, g, x, y);
        BL.paintIcon(c, g, x, y + height - BL.getIconHeight());
        TR.paintIcon(c, g, x + width - TR.getIconWidth(), y);
        BR.paintIcon(c, g, x + width - BR.getIconWidth(), y + height - BR.getIconHeight());
        int stop = x + width - TR.getIconWidth();
        int top = y;
        int bottom = y + height - B.getIconHeight();
        g.setClip(xOffset, y, width - L.getIconWidth() - R.getIconWidth(), height);
        for (xOffset = x + TL.getIconWidth(); xOffset < stop; xOffset += T.getIconWidth()) {
            T.paintIcon(c, g, xOffset, top);
            B.paintIcon(c, g, xOffset, bottom);
        }
        int left = x;
        int right = x + width - R.getIconWidth();
        stop = y + height - B.getIconHeight();
        g.setClip(x, yOffset, width, height - T.getIconHeight() - B.getIconHeight());
        for (yOffset = y + T.getIconHeight(); yOffset < stop; yOffset += L.getIconHeight()) {
            L.paintIcon(c, g, left, yOffset);
            R.paintIcon(c, g, right, yOffset);
        }
        g.dispose();
    }
}

