/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class MacIntelliJButtonUI
extends DarculaButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static final Icon LEFT = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/buttonLeft.png");
    private static final Icon RIGHT = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/buttonRight.png");
    private static final Icon MIDDLE = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/buttonMiddle.png");
    private static final Icon LEFT_SELECTED = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/selectedButtonLeft.png");
    private static final Icon RIGHT_SELECTED = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/selectedButtonRight.png");
    private static final Icon MIDDLE_SELECTED = DarculaLaf.loadIcon("/com/intellij/ide/ui/laf/icons/selectedButtonMiddle.png");

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJButtonUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (MacIntelliJButtonUI.isHelpButton(c)) {
            ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h, (Color)this.getButtonColor2()));
            int off = JBUI.scale((int)22);
            int x = (w - off) / 2;
            int y = (h - off) / 2;
            g.fillOval(x, y, off, off);
            AllIcons.Actions.Help.paintIcon(c, g, x + JBUI.scale((int)3), y + JBUI.scale((int)3));
        } else {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            String text = this.layout(b, SwingUtilities2.getFontMetrics((JComponent)b, g), b.getWidth(), b.getHeight());
            Border border = c.getBorder();
            if (b.isFocusPainted() && b.hasFocus() && border instanceof MacIntelliJBorder) {
                border.paintBorder(b, g, 1, 1, b.getWidth() - 2, b.getHeight() - 4);
            }
            boolean isDefault = b instanceof JButton && ((JButton)b).isDefaultButton();
            boolean square = MacIntelliJButtonUI.isSquare(c);
            int x = 3;
            int y = (h - MacIntelliJButtonUI.viewRect.height) / 2;
            Icon icon = isDefault ? LEFT_SELECTED : LEFT;
            icon.paintIcon(b, g, x, y);
            int stop = w - 3 - RIGHT.getIconWidth();
            Graphics gg = g.create(0, 0, w, h);
            gg.setClip(x += icon.getIconWidth(), y, stop - x, h);
            Icon icon2 = icon = isDefault ? MIDDLE_SELECTED : MIDDLE;
            while (x < stop) {
                icon.paintIcon(b, gg, x, y);
                x += icon.getIconWidth();
            }
            gg.dispose();
            icon = isDefault ? RIGHT_SELECTED : RIGHT;
            icon.paintIcon(b, g, stop, y);
            this.clearTextShiftOffset();
            if (b.getIcon() != null) {
                this.paintIcon(g, c, iconRect);
            }
            if (text != null && !text.equals("")) {
                View v = (View)c.getClientProperty("html");
                if (v != null) {
                    v.paint(g, textRect);
                } else {
                    this.paintText(g, b, textRect, text);
                }
            }
        }
    }

    private String layout(AbstractButton b, FontMetrics fm, int width, int height) {
        Insets i = b.getInsets();
        MacIntelliJButtonUI.viewRect.x = i.left;
        MacIntelliJButtonUI.viewRect.y = i.top;
        MacIntelliJButtonUI.viewRect.width = width - (i.right + MacIntelliJButtonUI.viewRect.x);
        MacIntelliJButtonUI.viewRect.height = height - (i.bottom + MacIntelliJButtonUI.viewRect.y);
        MacIntelliJButtonUI.textRect.height = 0;
        MacIntelliJButtonUI.textRect.width = 0;
        MacIntelliJButtonUI.textRect.y = 0;
        MacIntelliJButtonUI.textRect.x = 0;
        MacIntelliJButtonUI.iconRect.height = 0;
        MacIntelliJButtonUI.iconRect.width = 0;
        MacIntelliJButtonUI.iconRect.y = 0;
        MacIntelliJButtonUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    @Override
    protected Color getButtonColor1() {
        return super.getButtonColor1();
    }

    @Override
    protected Color getButtonColor2() {
        return super.getButtonColor2();
    }

    @Override
    protected Color getSelectedButtonColor1() {
        return new Color(7123962);
    }

    @Override
    protected Color getSelectedButtonColor2() {
        return new Color(491263);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        return new Dimension(size.width + 16, 27);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }
}

